/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json;

import com.atlassian.jira.rest.client.api.domain.IssueType;
import com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import java.net.URI;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class IssueTypeJsonParser
implements JsonObjectParser<IssueType> {
    @Override
    public IssueType parse(JSONObject json) throws JSONException {
        URI selfUri = JsonParseUtil.getSelfUri(json);
        long id = json.getLong("id");
        String name = json.getString("name");
        boolean isSubtask = json.getBoolean("subtask");
        String iconUrl = JsonParseUtil.getOptionalString(json, "iconUrl");
        URI iconUri = iconUrl == null ? null : JsonParseUtil.parseURI(iconUrl);
        String description = JsonParseUtil.getOptionalString(json, "description");
        return new IssueType(selfUri, Long.valueOf(id), name, isSubtask, description, iconUri);
    }
}

