/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira;

import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.domain.ServerInfo;
import java.net.URI;
import java.util.Map;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.DefaultComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.OptionsGroup;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorHelper;
import org.apache.camel.component.jira.JiraConfiguration;
import org.apache.camel.component.jira.oauth.JiraOAuthAuthenticationHandler;
import org.apache.camel.component.jira.oauth.OAuthAsynchronousJiraRestClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraVerifierExtension
extends DefaultComponentVerifierExtension {
    private static final Logger LOG = LoggerFactory.getLogger(JiraVerifierExtension.class);

    public JiraVerifierExtension() {
        super("jira");
    }

    protected ComponentVerifierExtension.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.PARAMETERS).error(ResultErrorHelper.requiresOption((String)"jiraUrl", parameters)).errors(ResultErrorHelper.requiresAny(parameters, (OptionsGroup[])new OptionsGroup[]{OptionsGroup.withName((String)"basic_authentication").options(new String[]{"username", "password", "!requestToken", "!privateKey", "!consumerKey", "!verificationCode", "!accessToken"}), OptionsGroup.withName((String)"oauth_authentication").options(new String[]{"requestToken", "privateKey", "consumerKey", "verificationCode", "accessToken", "!username", "!password"})}));
        super.verifyParametersAgainstCatalog(builder, parameters);
        return builder.build();
    }

    protected ComponentVerifierExtension.Result verifyConnectivity(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.CONNECTIVITY);
        try {
            JiraRestClient client;
            JiraConfiguration conf = (JiraConfiguration)this.setProperties(new JiraConfiguration(), parameters);
            OAuthAsynchronousJiraRestClientFactory factory = new OAuthAsynchronousJiraRestClientFactory();
            URI jiraServerUri = URI.create(conf.getJiraUrl());
            if (conf.getUsername() != null) {
                client = factory.createWithBasicHttpAuthentication(jiraServerUri, conf.getUsername(), conf.getPassword());
            } else {
                JiraOAuthAuthenticationHandler oAuthHandler = new JiraOAuthAuthenticationHandler(conf.getConsumerKey(), conf.getVerificationCode(), conf.getPrivateKey(), conf.getAccessToken(), conf.getJiraUrl());
                client = factory.create(jiraServerUri, oAuthHandler);
            }
            ServerInfo serverInfo = (ServerInfo)client.getMetadataClient().getServerInfo().claim();
            LOG.info("Verify connectivity to jira server OK: {}", (Object)serverInfo);
        }
        catch (RestClientException e) {
            ResultErrorBuilder errorBuilder = ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, (String)e.getMessage()).detail("jira_exception_message", (Object)e.getMessage()).detail("jira_status_code", (Object)e.getStatusCode()).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_CLASS, (Object)((Object)((Object)e)).getClass().getName()).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_INSTANCE, (Object)e);
            builder.error(errorBuilder.build());
        }
        catch (Exception e) {
            ResultErrorBuilder errorBuilder = ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, (String)e.getMessage()).detail("jira_exception_message", (Object)e.getMessage()).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_CLASS, (Object)e.getClass().getName()).detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_INSTANCE, (Object)e);
            builder.error(errorBuilder.build());
        }
        return builder.build();
    }
}

