/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.producer;

import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.Issue;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.jira.JiraEndpoint;
import org.apache.camel.support.DefaultProducer;

public class FetchIssueProducer
extends DefaultProducer {
    public FetchIssueProducer(JiraEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) {
        String issueKey = (String)exchange.getIn().getHeader("IssueKey", String.class);
        if (issueKey == null) {
            throw new IllegalArgumentException("Missing exchange input header named IssueKey");
        }
        JiraRestClient client = ((JiraEndpoint)this.getEndpoint()).getClient();
        IssueRestClient issueClient = client.getIssueClient();
        Issue issue = (Issue)issueClient.getIssue(issueKey).claim();
        exchange.getMessage().setBody((Object)issue);
    }
}

