/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.producer;

import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.BasicIssue;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.IssueType;
import com.atlassian.jira.rest.client.api.domain.Priority;
import com.atlassian.jira.rest.client.api.domain.input.IssueInputBuilder;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.jira.JiraEndpoint;
import org.apache.camel.support.DefaultProducer;

public class AddIssueProducer
extends DefaultProducer {
    public AddIssueProducer(JiraEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) {
        JiraRestClient client = ((JiraEndpoint)this.getEndpoint()).getClient();
        String projectKey = (String)exchange.getIn().getHeader("ProjectKey", String.class);
        Long issueTypeId = (Long)exchange.getIn().getHeader("IssueTypeId", Long.class);
        String issueTypeName = (String)exchange.getIn().getHeader("IssueTypeName", String.class);
        String summary = (String)exchange.getIn().getHeader("IssueSummary", String.class);
        String assigneeName = (String)exchange.getIn().getHeader("IssueAssignee", String.class);
        String priorityName = (String)exchange.getIn().getHeader("IssuePriorityName", String.class);
        Long priorityId = (Long)exchange.getIn().getHeader("IssuePriorityId", Long.class);
        List components = (List)exchange.getIn().getHeader("IssueComponents", List.class);
        List watchers = (List)exchange.getIn().getHeader("IssueWatchersAdd", List.class);
        if (issueTypeId == null && issueTypeName != null) {
            Iterable issueTypes = (Iterable)client.getMetadataClient().getIssueTypes().claim();
            for (IssueType type : issueTypes) {
                if (!issueTypeName.equals(type.getName())) continue;
                issueTypeId = type.getId();
                break;
            }
        }
        if (priorityId == null && priorityName != null) {
            Iterable priorities = (Iterable)client.getMetadataClient().getPriorities().claim();
            for (Priority pri : priorities) {
                if (!priorityName.equals(pri.getName())) continue;
                priorityId = pri.getId();
                break;
            }
        }
        if (projectKey == null) {
            throw new IllegalArgumentException("A valid project key is required.");
        }
        if (issueTypeId == null) {
            throw new IllegalArgumentException("A valid issue type id is required, actual: id(" + issueTypeId + "), name(" + issueTypeName + ")");
        }
        if (summary == null) {
            throw new IllegalArgumentException("A summary field is required, actual value: " + summary);
        }
        IssueInputBuilder builder = new IssueInputBuilder(projectKey, issueTypeId);
        builder.setDescription((String)exchange.getIn().getBody(String.class));
        builder.setSummary(summary);
        if (components != null && !components.isEmpty()) {
            builder.setComponentsNames((Iterable)components);
        }
        if (priorityId != null) {
            builder.setPriorityId(priorityId);
        }
        if (assigneeName != null) {
            builder.setAssigneeName(assigneeName);
        }
        IssueRestClient issueClient = client.getIssueClient();
        BasicIssue issueCreated = (BasicIssue)issueClient.createIssue(builder.build()).claim();
        Issue issue = (Issue)issueClient.getIssue(issueCreated.getKey()).claim();
        if (watchers != null && !watchers.isEmpty()) {
            for (String watcher : watchers) {
                issueClient.addWatcher(issue.getWatchers().getSelf(), watcher);
            }
        }
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().copyFrom(exchange.getIn());
            exchange.getOut().setBody((Object)issue);
        } else {
            exchange.getIn().setBody((Object)issue);
        }
    }
}

