/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.jms.ConsumerType;
import org.apache.camel.component.jms.DefaultTaskExecutorType;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsKeyFormatStrategy;
import org.apache.camel.component.jms.JmsMessageType;
import org.apache.camel.component.jms.MessageCreatedStrategy;
import org.apache.camel.component.jms.MessageListenerContainerFactory;
import org.apache.camel.component.jms.QueueBrowseStrategy;
import org.apache.camel.component.jms.ReplyToType;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ErrorHandler;

public class JmsComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private JmsConfiguration getOrCreateConfiguration(JmsComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new JmsConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        JmsComponent target = (JmsComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "acceptmessageswhilestopping": 
            case "acceptMessagesWhileStopping": {
                this.getOrCreateConfiguration(target).setAcceptMessagesWhileStopping((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "acknowledgementmodename": 
            case "acknowledgementModeName": {
                this.getOrCreateConfiguration(target).setAcknowledgementModeName((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "allowadditionalheaders": 
            case "allowAdditionalHeaders": {
                this.getOrCreateConfiguration(target).setAllowAdditionalHeaders((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "allowautowiredconnectionfactory": 
            case "allowAutoWiredConnectionFactory": {
                target.setAllowAutoWiredConnectionFactory((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "allowautowireddestinationresolver": 
            case "allowAutoWiredDestinationResolver": {
                target.setAllowAutoWiredDestinationResolver((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "allownullbody": 
            case "allowNullBody": {
                this.getOrCreateConfiguration(target).setAllowNullBody((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "allowreplymanagerquickstop": 
            case "allowReplyManagerQuickStop": {
                this.getOrCreateConfiguration(target).setAllowReplyManagerQuickStop((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "allowserializedheaders": 
            case "allowSerializedHeaders": {
                this.getOrCreateConfiguration(target).setAllowSerializedHeaders((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "alwayscopymessage": 
            case "alwaysCopyMessage": {
                this.getOrCreateConfiguration(target).setAlwaysCopyMessage((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "artemisstreamingenabled": 
            case "artemisStreamingEnabled": {
                this.getOrCreateConfiguration(target).setArtemisStreamingEnabled((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "asyncconsumer": 
            case "asyncConsumer": {
                this.getOrCreateConfiguration(target).setAsyncConsumer((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "asyncstartlistener": 
            case "asyncStartListener": {
                this.getOrCreateConfiguration(target).setAsyncStartListener((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "asyncstoplistener": 
            case "asyncStopListener": {
                this.getOrCreateConfiguration(target).setAsyncStopListener((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "autostartup": 
            case "autoStartup": {
                this.getOrCreateConfiguration(target).setAutoStartup((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "cachelevel": 
            case "cacheLevel": {
                this.getOrCreateConfiguration(target).setCacheLevel((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "cachelevelname": 
            case "cacheLevelName": {
                this.getOrCreateConfiguration(target).setCacheLevelName((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "clientid": 
            case "clientId": {
                this.getOrCreateConfiguration(target).setClientId((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "concurrentconsumers": 
            case "concurrentConsumers": {
                this.getOrCreateConfiguration(target).setConcurrentConsumers((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((JmsConfiguration)JmsComponentConfigurer.property((CamelContext)camelContext, JmsConfiguration.class, (Object)value));
                return true;
            }
            case "connectionfactory": 
            case "connectionFactory": {
                this.getOrCreateConfiguration(target).setConnectionFactory((ConnectionFactory)JmsComponentConfigurer.property((CamelContext)camelContext, ConnectionFactory.class, (Object)value));
                return true;
            }
            case "consumertype": 
            case "consumerType": {
                this.getOrCreateConfiguration(target).setConsumerType((ConsumerType)((Object)JmsComponentConfigurer.property((CamelContext)camelContext, ConsumerType.class, (Object)value)));
                return true;
            }
            case "correlationproperty": 
            case "correlationProperty": {
                this.getOrCreateConfiguration(target).setCorrelationProperty((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "defaulttaskexecutortype": 
            case "defaultTaskExecutorType": {
                this.getOrCreateConfiguration(target).setDefaultTaskExecutorType((DefaultTaskExecutorType)((Object)JmsComponentConfigurer.property((CamelContext)camelContext, DefaultTaskExecutorType.class, (Object)value)));
                return true;
            }
            case "deliverydelay": 
            case "deliveryDelay": {
                this.getOrCreateConfiguration(target).setDeliveryDelay((Long)JmsComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "deliverymode": 
            case "deliveryMode": {
                this.getOrCreateConfiguration(target).setDeliveryMode((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "deliverypersistent": 
            case "deliveryPersistent": {
                this.getOrCreateConfiguration(target).setDeliveryPersistent((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "destinationresolver": 
            case "destinationResolver": {
                this.getOrCreateConfiguration(target).setDestinationResolver((DestinationResolver)JmsComponentConfigurer.property((CamelContext)camelContext, DestinationResolver.class, (Object)value));
                return true;
            }
            case "disablereplyto": 
            case "disableReplyTo": {
                this.getOrCreateConfiguration(target).setDisableReplyTo((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "disabletimetolive": 
            case "disableTimeToLive": {
                this.getOrCreateConfiguration(target).setDisableTimeToLive((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "durablesubscriptionname": 
            case "durableSubscriptionName": {
                this.getOrCreateConfiguration(target).setDurableSubscriptionName((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "eagerloadingofproperties": 
            case "eagerLoadingOfProperties": {
                this.getOrCreateConfiguration(target).setEagerLoadingOfProperties((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "eagerpoisonbody": 
            case "eagerPoisonBody": {
                this.getOrCreateConfiguration(target).setEagerPoisonBody((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "errorhandler": 
            case "errorHandler": {
                this.getOrCreateConfiguration(target).setErrorHandler((ErrorHandler)JmsComponentConfigurer.property((CamelContext)camelContext, ErrorHandler.class, (Object)value));
                return true;
            }
            case "errorhandlerlogstacktrace": 
            case "errorHandlerLogStackTrace": {
                this.getOrCreateConfiguration(target).setErrorHandlerLogStackTrace((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "errorhandlerlogginglevel": 
            case "errorHandlerLoggingLevel": {
                this.getOrCreateConfiguration(target).setErrorHandlerLoggingLevel((LoggingLevel)JmsComponentConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "exceptionlistener": 
            case "exceptionListener": {
                this.getOrCreateConfiguration(target).setExceptionListener((ExceptionListener)JmsComponentConfigurer.property((CamelContext)camelContext, ExceptionListener.class, (Object)value));
                return true;
            }
            case "explicitqosenabled": 
            case "explicitQosEnabled": {
                this.getOrCreateConfiguration(target).setExplicitQosEnabled((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "exposelistenersession": 
            case "exposeListenerSession": {
                this.getOrCreateConfiguration(target).setExposeListenerSession((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "forcesendoriginalmessage": 
            case "forceSendOriginalMessage": {
                this.getOrCreateConfiguration(target).setForceSendOriginalMessage((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "formatdateheaderstoiso8601": 
            case "formatDateHeadersToIso8601": {
                this.getOrCreateConfiguration(target).setFormatDateHeadersToIso8601((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                target.setHeaderFilterStrategy((HeaderFilterStrategy)JmsComponentConfigurer.property((CamelContext)camelContext, HeaderFilterStrategy.class, (Object)value));
                return true;
            }
            case "idleconsumerlimit": 
            case "idleConsumerLimit": {
                this.getOrCreateConfiguration(target).setIdleConsumerLimit((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "idletaskexecutionlimit": 
            case "idleTaskExecutionLimit": {
                this.getOrCreateConfiguration(target).setIdleTaskExecutionLimit((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "includealljmsxproperties": 
            case "includeAllJMSXProperties": {
                this.getOrCreateConfiguration(target).setIncludeAllJMSXProperties((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "includesentjmsmessageid": 
            case "includeSentJMSMessageID": {
                this.getOrCreateConfiguration(target).setIncludeSentJMSMessageID((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "jmskeyformatstrategy": 
            case "jmsKeyFormatStrategy": {
                this.getOrCreateConfiguration(target).setJmsKeyFormatStrategy((JmsKeyFormatStrategy)JmsComponentConfigurer.property((CamelContext)camelContext, JmsKeyFormatStrategy.class, (Object)value));
                return true;
            }
            case "jmsmessagetype": 
            case "jmsMessageType": {
                this.getOrCreateConfiguration(target).setJmsMessageType((JmsMessageType)((Object)JmsComponentConfigurer.property((CamelContext)camelContext, JmsMessageType.class, (Object)value)));
                return true;
            }
            case "lazycreatetransactionmanager": 
            case "lazyCreateTransactionManager": {
                this.getOrCreateConfiguration(target).setLazyCreateTransactionManager((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "mapjmsmessage": 
            case "mapJmsMessage": {
                this.getOrCreateConfiguration(target).setMapJmsMessage((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxconcurrentconsumers": 
            case "maxConcurrentConsumers": {
                this.getOrCreateConfiguration(target).setMaxConcurrentConsumers((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "maxmessagespertask": 
            case "maxMessagesPerTask": {
                this.getOrCreateConfiguration(target).setMaxMessagesPerTask((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "messageconverter": 
            case "messageConverter": {
                this.getOrCreateConfiguration(target).setMessageConverter((MessageConverter)JmsComponentConfigurer.property((CamelContext)camelContext, MessageConverter.class, (Object)value));
                return true;
            }
            case "messagecreatedstrategy": 
            case "messageCreatedStrategy": {
                this.getOrCreateConfiguration(target).setMessageCreatedStrategy((MessageCreatedStrategy)JmsComponentConfigurer.property((CamelContext)camelContext, MessageCreatedStrategy.class, (Object)value));
                return true;
            }
            case "messageidenabled": 
            case "messageIdEnabled": {
                this.getOrCreateConfiguration(target).setMessageIdEnabled((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "messagelistenercontainerfactory": 
            case "messageListenerContainerFactory": {
                this.getOrCreateConfiguration(target).setMessageListenerContainerFactory((MessageListenerContainerFactory)JmsComponentConfigurer.property((CamelContext)camelContext, MessageListenerContainerFactory.class, (Object)value));
                return true;
            }
            case "messagetimestampenabled": 
            case "messageTimestampEnabled": {
                this.getOrCreateConfiguration(target).setMessageTimestampEnabled((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "password": {
                this.getOrCreateConfiguration(target).setPassword((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "preservemessageqos": 
            case "preserveMessageQos": {
                this.getOrCreateConfiguration(target).setPreserveMessageQos((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "priority": {
                this.getOrCreateConfiguration(target).setPriority((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "pubsubnolocal": 
            case "pubSubNoLocal": {
                this.getOrCreateConfiguration(target).setPubSubNoLocal((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "queuebrowsestrategy": 
            case "queueBrowseStrategy": {
                target.setQueueBrowseStrategy((QueueBrowseStrategy)JmsComponentConfigurer.property((CamelContext)camelContext, QueueBrowseStrategy.class, (Object)value));
                return true;
            }
            case "receivetimeout": 
            case "receiveTimeout": {
                this.getOrCreateConfiguration(target).setReceiveTimeout((Long)JmsComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "recoveryinterval": 
            case "recoveryInterval": {
                this.getOrCreateConfiguration(target).setRecoveryInterval((Long)JmsComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "replyto": 
            case "replyTo": {
                this.getOrCreateConfiguration(target).setReplyTo((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "replytocachelevelname": 
            case "replyToCacheLevelName": {
                this.getOrCreateConfiguration(target).setReplyToCacheLevelName((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "replytoconcurrentconsumers": 
            case "replyToConcurrentConsumers": {
                this.getOrCreateConfiguration(target).setReplyToConcurrentConsumers((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "replytodeliverypersistent": 
            case "replyToDeliveryPersistent": {
                this.getOrCreateConfiguration(target).setReplyToDeliveryPersistent((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "replytodestinationselectorname": 
            case "replyToDestinationSelectorName": {
                this.getOrCreateConfiguration(target).setReplyToDestinationSelectorName((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "replytomaxconcurrentconsumers": 
            case "replyToMaxConcurrentConsumers": {
                this.getOrCreateConfiguration(target).setReplyToMaxConcurrentConsumers((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "replytoontimeoutmaxconcurrentconsumers": 
            case "replyToOnTimeoutMaxConcurrentConsumers": {
                this.getOrCreateConfiguration(target).setReplyToOnTimeoutMaxConcurrentConsumers((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "replytooverride": 
            case "replyToOverride": {
                this.getOrCreateConfiguration(target).setReplyToOverride((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "replytosamedestinationallowed": 
            case "replyToSameDestinationAllowed": {
                this.getOrCreateConfiguration(target).setReplyToSameDestinationAllowed((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "replytotype": 
            case "replyToType": {
                this.getOrCreateConfiguration(target).setReplyToType((ReplyToType)((Object)JmsComponentConfigurer.property((CamelContext)camelContext, ReplyToType.class, (Object)value)));
                return true;
            }
            case "requesttimeout": 
            case "requestTimeout": {
                this.getOrCreateConfiguration(target).setRequestTimeout((Long)JmsComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "requesttimeoutcheckerinterval": 
            case "requestTimeoutCheckerInterval": {
                this.getOrCreateConfiguration(target).setRequestTimeoutCheckerInterval((Long)JmsComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "selector": {
                this.getOrCreateConfiguration(target).setSelector((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "streammessagetypeenabled": 
            case "streamMessageTypeEnabled": {
                this.getOrCreateConfiguration(target).setStreamMessageTypeEnabled((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "subscriptiondurable": 
            case "subscriptionDurable": {
                this.getOrCreateConfiguration(target).setSubscriptionDurable((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "subscriptionname": 
            case "subscriptionName": {
                this.getOrCreateConfiguration(target).setSubscriptionName((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "subscriptionshared": 
            case "subscriptionShared": {
                this.getOrCreateConfiguration(target).setSubscriptionShared((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "taskexecutor": 
            case "taskExecutor": {
                this.getOrCreateConfiguration(target).setTaskExecutor((TaskExecutor)JmsComponentConfigurer.property((CamelContext)camelContext, TaskExecutor.class, (Object)value));
                return true;
            }
            case "testconnectiononstartup": 
            case "testConnectionOnStartup": {
                this.getOrCreateConfiguration(target).setTestConnectionOnStartup((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "timetolive": 
            case "timeToLive": {
                this.getOrCreateConfiguration(target).setTimeToLive((Long)JmsComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "transacted": {
                this.getOrCreateConfiguration(target).setTransacted((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "transactionmanager": 
            case "transactionManager": {
                this.getOrCreateConfiguration(target).setTransactionManager((PlatformTransactionManager)JmsComponentConfigurer.property((CamelContext)camelContext, PlatformTransactionManager.class, (Object)value));
                return true;
            }
            case "transactionname": 
            case "transactionName": {
                this.getOrCreateConfiguration(target).setTransactionName((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "transactiontimeout": 
            case "transactionTimeout": {
                this.getOrCreateConfiguration(target).setTransactionTimeout((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "transferexception": 
            case "transferException": {
                this.getOrCreateConfiguration(target).setTransferException((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "transferexchange": 
            case "transferExchange": {
                this.getOrCreateConfiguration(target).setTransferExchange((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "usemessageidascorrelationid": 
            case "useMessageIDAsCorrelationID": {
                this.getOrCreateConfiguration(target).setUseMessageIDAsCorrelationID((Boolean)JmsComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "username": {
                this.getOrCreateConfiguration(target).setUsername((String)JmsComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "waitforprovisioncorrelationtobeupdatedcounter": 
            case "waitForProvisionCorrelationToBeUpdatedCounter": {
                this.getOrCreateConfiguration(target).setWaitForProvisionCorrelationToBeUpdatedCounter((Integer)JmsComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "waitforprovisioncorrelationtobeupdatedthreadsleepingtime": 
            case "waitForProvisionCorrelationToBeUpdatedThreadSleepingTime": {
                this.getOrCreateConfiguration(target).setWaitForProvisionCorrelationToBeUpdatedThreadSleepingTime((Long)JmsComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        CaseInsensitiveMap answer = new CaseInsensitiveMap();
        answer.put("acceptMessagesWhileStopping", Boolean.TYPE);
        answer.put("acknowledgementModeName", String.class);
        answer.put("allowAdditionalHeaders", String.class);
        answer.put("allowAutoWiredConnectionFactory", Boolean.TYPE);
        answer.put("allowAutoWiredDestinationResolver", Boolean.TYPE);
        answer.put("allowNullBody", Boolean.TYPE);
        answer.put("allowReplyManagerQuickStop", Boolean.TYPE);
        answer.put("allowSerializedHeaders", Boolean.TYPE);
        answer.put("alwaysCopyMessage", Boolean.TYPE);
        answer.put("artemisStreamingEnabled", Boolean.TYPE);
        answer.put("asyncConsumer", Boolean.TYPE);
        answer.put("asyncStartListener", Boolean.TYPE);
        answer.put("asyncStopListener", Boolean.TYPE);
        answer.put("autoStartup", Boolean.TYPE);
        answer.put("basicPropertyBinding", Boolean.TYPE);
        answer.put("bridgeErrorHandler", Boolean.TYPE);
        answer.put("cacheLevel", Integer.TYPE);
        answer.put("cacheLevelName", String.class);
        answer.put("clientId", String.class);
        answer.put("concurrentConsumers", Integer.TYPE);
        answer.put("configuration", JmsConfiguration.class);
        answer.put("connectionFactory", ConnectionFactory.class);
        answer.put("consumerType", ConsumerType.class);
        answer.put("correlationProperty", String.class);
        answer.put("defaultTaskExecutorType", DefaultTaskExecutorType.class);
        answer.put("deliveryDelay", Long.TYPE);
        answer.put("deliveryMode", Integer.class);
        answer.put("deliveryPersistent", Boolean.TYPE);
        answer.put("destinationResolver", DestinationResolver.class);
        answer.put("disableReplyTo", Boolean.TYPE);
        answer.put("disableTimeToLive", Boolean.TYPE);
        answer.put("durableSubscriptionName", String.class);
        answer.put("eagerLoadingOfProperties", Boolean.TYPE);
        answer.put("eagerPoisonBody", String.class);
        answer.put("errorHandler", ErrorHandler.class);
        answer.put("errorHandlerLogStackTrace", Boolean.TYPE);
        answer.put("errorHandlerLoggingLevel", LoggingLevel.class);
        answer.put("exceptionListener", ExceptionListener.class);
        answer.put("explicitQosEnabled", Boolean.class);
        answer.put("exposeListenerSession", Boolean.TYPE);
        answer.put("forceSendOriginalMessage", Boolean.TYPE);
        answer.put("formatDateHeadersToIso8601", Boolean.TYPE);
        answer.put("headerFilterStrategy", HeaderFilterStrategy.class);
        answer.put("idleConsumerLimit", Integer.TYPE);
        answer.put("idleTaskExecutionLimit", Integer.TYPE);
        answer.put("includeAllJMSXProperties", Boolean.TYPE);
        answer.put("includeSentJMSMessageID", Boolean.TYPE);
        answer.put("jmsKeyFormatStrategy", JmsKeyFormatStrategy.class);
        answer.put("jmsMessageType", JmsMessageType.class);
        answer.put("lazyCreateTransactionManager", Boolean.TYPE);
        answer.put("lazyStartProducer", Boolean.TYPE);
        answer.put("mapJmsMessage", Boolean.TYPE);
        answer.put("maxConcurrentConsumers", Integer.TYPE);
        answer.put("maxMessagesPerTask", Integer.TYPE);
        answer.put("messageConverter", MessageConverter.class);
        answer.put("messageCreatedStrategy", MessageCreatedStrategy.class);
        answer.put("messageIdEnabled", Boolean.TYPE);
        answer.put("messageListenerContainerFactory", MessageListenerContainerFactory.class);
        answer.put("messageTimestampEnabled", Boolean.TYPE);
        answer.put("password", String.class);
        answer.put("preserveMessageQos", Boolean.TYPE);
        answer.put("priority", Integer.TYPE);
        answer.put("pubSubNoLocal", Boolean.TYPE);
        answer.put("queueBrowseStrategy", QueueBrowseStrategy.class);
        answer.put("receiveTimeout", Long.TYPE);
        answer.put("recoveryInterval", Long.TYPE);
        answer.put("replyTo", String.class);
        answer.put("replyToCacheLevelName", String.class);
        answer.put("replyToConcurrentConsumers", Integer.TYPE);
        answer.put("replyToDeliveryPersistent", Boolean.TYPE);
        answer.put("replyToDestinationSelectorName", String.class);
        answer.put("replyToMaxConcurrentConsumers", Integer.TYPE);
        answer.put("replyToOnTimeoutMaxConcurrentConsumers", Integer.TYPE);
        answer.put("replyToOverride", String.class);
        answer.put("replyToSameDestinationAllowed", Boolean.TYPE);
        answer.put("replyToType", ReplyToType.class);
        answer.put("requestTimeout", Long.TYPE);
        answer.put("requestTimeoutCheckerInterval", Long.TYPE);
        answer.put("selector", String.class);
        answer.put("streamMessageTypeEnabled", Boolean.TYPE);
        answer.put("subscriptionDurable", Boolean.TYPE);
        answer.put("subscriptionName", String.class);
        answer.put("subscriptionShared", Boolean.TYPE);
        answer.put("taskExecutor", TaskExecutor.class);
        answer.put("testConnectionOnStartup", Boolean.TYPE);
        answer.put("timeToLive", Long.TYPE);
        answer.put("transacted", Boolean.TYPE);
        answer.put("transactionManager", PlatformTransactionManager.class);
        answer.put("transactionName", String.class);
        answer.put("transactionTimeout", Integer.TYPE);
        answer.put("transferException", Boolean.TYPE);
        answer.put("transferExchange", Boolean.TYPE);
        answer.put("useMessageIDAsCorrelationID", Boolean.TYPE);
        answer.put("username", String.class);
        answer.put("waitForProvisionCorrelationToBeUpdatedCounter", Integer.TYPE);
        answer.put("waitForProvisionCorrelationToBeUpdatedThreadSleepingTime", Long.TYPE);
        return answer;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        JmsComponent target = (JmsComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "acceptmessageswhilestopping": 
            case "acceptMessagesWhileStopping": {
                return this.getOrCreateConfiguration(target).isAcceptMessagesWhileStopping();
            }
            case "acknowledgementmodename": 
            case "acknowledgementModeName": {
                return this.getOrCreateConfiguration(target).getAcknowledgementModeName();
            }
            case "allowadditionalheaders": 
            case "allowAdditionalHeaders": {
                return this.getOrCreateConfiguration(target).getAllowAdditionalHeaders();
            }
            case "allowautowiredconnectionfactory": 
            case "allowAutoWiredConnectionFactory": {
                return target.isAllowAutoWiredConnectionFactory();
            }
            case "allowautowireddestinationresolver": 
            case "allowAutoWiredDestinationResolver": {
                return target.isAllowAutoWiredDestinationResolver();
            }
            case "allownullbody": 
            case "allowNullBody": {
                return this.getOrCreateConfiguration(target).isAllowNullBody();
            }
            case "allowreplymanagerquickstop": 
            case "allowReplyManagerQuickStop": {
                return this.getOrCreateConfiguration(target).isAllowReplyManagerQuickStop();
            }
            case "allowserializedheaders": 
            case "allowSerializedHeaders": {
                return this.getOrCreateConfiguration(target).isAllowSerializedHeaders();
            }
            case "alwayscopymessage": 
            case "alwaysCopyMessage": {
                return this.getOrCreateConfiguration(target).isAlwaysCopyMessage();
            }
            case "artemisstreamingenabled": 
            case "artemisStreamingEnabled": {
                return this.getOrCreateConfiguration(target).isArtemisStreamingEnabled();
            }
            case "asyncconsumer": 
            case "asyncConsumer": {
                return this.getOrCreateConfiguration(target).isAsyncConsumer();
            }
            case "asyncstartlistener": 
            case "asyncStartListener": {
                return this.getOrCreateConfiguration(target).isAsyncStartListener();
            }
            case "asyncstoplistener": 
            case "asyncStopListener": {
                return this.getOrCreateConfiguration(target).isAsyncStopListener();
            }
            case "autostartup": 
            case "autoStartup": {
                return this.getOrCreateConfiguration(target).isAutoStartup();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "cachelevel": 
            case "cacheLevel": {
                return this.getOrCreateConfiguration(target).getCacheLevel();
            }
            case "cachelevelname": 
            case "cacheLevelName": {
                return this.getOrCreateConfiguration(target).getCacheLevelName();
            }
            case "clientid": 
            case "clientId": {
                return this.getOrCreateConfiguration(target).getClientId();
            }
            case "concurrentconsumers": 
            case "concurrentConsumers": {
                return this.getOrCreateConfiguration(target).getConcurrentConsumers();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "connectionfactory": 
            case "connectionFactory": {
                return this.getOrCreateConfiguration(target).getConnectionFactory();
            }
            case "consumertype": 
            case "consumerType": {
                return this.getOrCreateConfiguration(target).getConsumerType();
            }
            case "correlationproperty": 
            case "correlationProperty": {
                return this.getOrCreateConfiguration(target).getCorrelationProperty();
            }
            case "defaulttaskexecutortype": 
            case "defaultTaskExecutorType": {
                return this.getOrCreateConfiguration(target).getDefaultTaskExecutorType();
            }
            case "deliverydelay": 
            case "deliveryDelay": {
                return this.getOrCreateConfiguration(target).getDeliveryDelay();
            }
            case "deliverymode": 
            case "deliveryMode": {
                return this.getOrCreateConfiguration(target).getDeliveryMode();
            }
            case "deliverypersistent": 
            case "deliveryPersistent": {
                return this.getOrCreateConfiguration(target).isDeliveryPersistent();
            }
            case "destinationresolver": 
            case "destinationResolver": {
                return this.getOrCreateConfiguration(target).getDestinationResolver();
            }
            case "disablereplyto": 
            case "disableReplyTo": {
                return this.getOrCreateConfiguration(target).isDisableReplyTo();
            }
            case "disabletimetolive": 
            case "disableTimeToLive": {
                return this.getOrCreateConfiguration(target).isDisableTimeToLive();
            }
            case "durablesubscriptionname": 
            case "durableSubscriptionName": {
                return this.getOrCreateConfiguration(target).getDurableSubscriptionName();
            }
            case "eagerloadingofproperties": 
            case "eagerLoadingOfProperties": {
                return this.getOrCreateConfiguration(target).isEagerLoadingOfProperties();
            }
            case "eagerpoisonbody": 
            case "eagerPoisonBody": {
                return this.getOrCreateConfiguration(target).getEagerPoisonBody();
            }
            case "errorhandler": 
            case "errorHandler": {
                return this.getOrCreateConfiguration(target).getErrorHandler();
            }
            case "errorhandlerlogstacktrace": 
            case "errorHandlerLogStackTrace": {
                return this.getOrCreateConfiguration(target).isErrorHandlerLogStackTrace();
            }
            case "errorhandlerlogginglevel": 
            case "errorHandlerLoggingLevel": {
                return this.getOrCreateConfiguration(target).getErrorHandlerLoggingLevel();
            }
            case "exceptionlistener": 
            case "exceptionListener": {
                return this.getOrCreateConfiguration(target).getExceptionListener();
            }
            case "explicitqosenabled": 
            case "explicitQosEnabled": {
                return this.getOrCreateConfiguration(target).getExplicitQosEnabled();
            }
            case "exposelistenersession": 
            case "exposeListenerSession": {
                return this.getOrCreateConfiguration(target).isExposeListenerSession();
            }
            case "forcesendoriginalmessage": 
            case "forceSendOriginalMessage": {
                return this.getOrCreateConfiguration(target).isForceSendOriginalMessage();
            }
            case "formatdateheaderstoiso8601": 
            case "formatDateHeadersToIso8601": {
                return this.getOrCreateConfiguration(target).isFormatDateHeadersToIso8601();
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                return target.getHeaderFilterStrategy();
            }
            case "idleconsumerlimit": 
            case "idleConsumerLimit": {
                return this.getOrCreateConfiguration(target).getIdleConsumerLimit();
            }
            case "idletaskexecutionlimit": 
            case "idleTaskExecutionLimit": {
                return this.getOrCreateConfiguration(target).getIdleTaskExecutionLimit();
            }
            case "includealljmsxproperties": 
            case "includeAllJMSXProperties": {
                return this.getOrCreateConfiguration(target).isIncludeAllJMSXProperties();
            }
            case "includesentjmsmessageid": 
            case "includeSentJMSMessageID": {
                return this.getOrCreateConfiguration(target).isIncludeSentJMSMessageID();
            }
            case "jmskeyformatstrategy": 
            case "jmsKeyFormatStrategy": {
                return this.getOrCreateConfiguration(target).getJmsKeyFormatStrategy();
            }
            case "jmsmessagetype": 
            case "jmsMessageType": {
                return this.getOrCreateConfiguration(target).getJmsMessageType();
            }
            case "lazycreatetransactionmanager": 
            case "lazyCreateTransactionManager": {
                return this.getOrCreateConfiguration(target).isLazyCreateTransactionManager();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "mapjmsmessage": 
            case "mapJmsMessage": {
                return this.getOrCreateConfiguration(target).isMapJmsMessage();
            }
            case "maxconcurrentconsumers": 
            case "maxConcurrentConsumers": {
                return this.getOrCreateConfiguration(target).getMaxConcurrentConsumers();
            }
            case "maxmessagespertask": 
            case "maxMessagesPerTask": {
                return this.getOrCreateConfiguration(target).getMaxMessagesPerTask();
            }
            case "messageconverter": 
            case "messageConverter": {
                return this.getOrCreateConfiguration(target).getMessageConverter();
            }
            case "messagecreatedstrategy": 
            case "messageCreatedStrategy": {
                return this.getOrCreateConfiguration(target).getMessageCreatedStrategy();
            }
            case "messageidenabled": 
            case "messageIdEnabled": {
                return this.getOrCreateConfiguration(target).isMessageIdEnabled();
            }
            case "messagelistenercontainerfactory": 
            case "messageListenerContainerFactory": {
                return this.getOrCreateConfiguration(target).getMessageListenerContainerFactory();
            }
            case "messagetimestampenabled": 
            case "messageTimestampEnabled": {
                return this.getOrCreateConfiguration(target).isMessageTimestampEnabled();
            }
            case "password": {
                return this.getOrCreateConfiguration(target).getPassword();
            }
            case "preservemessageqos": 
            case "preserveMessageQos": {
                return this.getOrCreateConfiguration(target).isPreserveMessageQos();
            }
            case "priority": {
                return this.getOrCreateConfiguration(target).getPriority();
            }
            case "pubsubnolocal": 
            case "pubSubNoLocal": {
                return this.getOrCreateConfiguration(target).isPubSubNoLocal();
            }
            case "queuebrowsestrategy": 
            case "queueBrowseStrategy": {
                return target.getQueueBrowseStrategy();
            }
            case "receivetimeout": 
            case "receiveTimeout": {
                return this.getOrCreateConfiguration(target).getReceiveTimeout();
            }
            case "recoveryinterval": 
            case "recoveryInterval": {
                return this.getOrCreateConfiguration(target).getRecoveryInterval();
            }
            case "replyto": 
            case "replyTo": {
                return this.getOrCreateConfiguration(target).getReplyTo();
            }
            case "replytocachelevelname": 
            case "replyToCacheLevelName": {
                return this.getOrCreateConfiguration(target).getReplyToCacheLevelName();
            }
            case "replytoconcurrentconsumers": 
            case "replyToConcurrentConsumers": {
                return this.getOrCreateConfiguration(target).getReplyToConcurrentConsumers();
            }
            case "replytodeliverypersistent": 
            case "replyToDeliveryPersistent": {
                return this.getOrCreateConfiguration(target).isReplyToDeliveryPersistent();
            }
            case "replytodestinationselectorname": 
            case "replyToDestinationSelectorName": {
                return this.getOrCreateConfiguration(target).getReplyToDestinationSelectorName();
            }
            case "replytomaxconcurrentconsumers": 
            case "replyToMaxConcurrentConsumers": {
                return this.getOrCreateConfiguration(target).getReplyToMaxConcurrentConsumers();
            }
            case "replytoontimeoutmaxconcurrentconsumers": 
            case "replyToOnTimeoutMaxConcurrentConsumers": {
                return this.getOrCreateConfiguration(target).getReplyToOnTimeoutMaxConcurrentConsumers();
            }
            case "replytooverride": 
            case "replyToOverride": {
                return this.getOrCreateConfiguration(target).getReplyToOverride();
            }
            case "replytosamedestinationallowed": 
            case "replyToSameDestinationAllowed": {
                return this.getOrCreateConfiguration(target).isReplyToSameDestinationAllowed();
            }
            case "replytotype": 
            case "replyToType": {
                return this.getOrCreateConfiguration(target).getReplyToType();
            }
            case "requesttimeout": 
            case "requestTimeout": {
                return this.getOrCreateConfiguration(target).getRequestTimeout();
            }
            case "requesttimeoutcheckerinterval": 
            case "requestTimeoutCheckerInterval": {
                return this.getOrCreateConfiguration(target).getRequestTimeoutCheckerInterval();
            }
            case "selector": {
                return this.getOrCreateConfiguration(target).getSelector();
            }
            case "streammessagetypeenabled": 
            case "streamMessageTypeEnabled": {
                return this.getOrCreateConfiguration(target).isStreamMessageTypeEnabled();
            }
            case "subscriptiondurable": 
            case "subscriptionDurable": {
                return this.getOrCreateConfiguration(target).isSubscriptionDurable();
            }
            case "subscriptionname": 
            case "subscriptionName": {
                return this.getOrCreateConfiguration(target).getSubscriptionName();
            }
            case "subscriptionshared": 
            case "subscriptionShared": {
                return this.getOrCreateConfiguration(target).isSubscriptionShared();
            }
            case "taskexecutor": 
            case "taskExecutor": {
                return this.getOrCreateConfiguration(target).getTaskExecutor();
            }
            case "testconnectiononstartup": 
            case "testConnectionOnStartup": {
                return this.getOrCreateConfiguration(target).isTestConnectionOnStartup();
            }
            case "timetolive": 
            case "timeToLive": {
                return this.getOrCreateConfiguration(target).getTimeToLive();
            }
            case "transacted": {
                return this.getOrCreateConfiguration(target).isTransacted();
            }
            case "transactionmanager": 
            case "transactionManager": {
                return this.getOrCreateConfiguration(target).getTransactionManager();
            }
            case "transactionname": 
            case "transactionName": {
                return this.getOrCreateConfiguration(target).getTransactionName();
            }
            case "transactiontimeout": 
            case "transactionTimeout": {
                return this.getOrCreateConfiguration(target).getTransactionTimeout();
            }
            case "transferexception": 
            case "transferException": {
                return this.getOrCreateConfiguration(target).isTransferException();
            }
            case "transferexchange": 
            case "transferExchange": {
                return this.getOrCreateConfiguration(target).isTransferExchange();
            }
            case "usemessageidascorrelationid": 
            case "useMessageIDAsCorrelationID": {
                return this.getOrCreateConfiguration(target).isUseMessageIDAsCorrelationID();
            }
            case "username": {
                return this.getOrCreateConfiguration(target).getUsername();
            }
            case "waitforprovisioncorrelationtobeupdatedcounter": 
            case "waitForProvisionCorrelationToBeUpdatedCounter": {
                return this.getOrCreateConfiguration(target).getWaitForProvisionCorrelationToBeUpdatedCounter();
            }
            case "waitforprovisioncorrelationtobeupdatedthreadsleepingtime": 
            case "waitForProvisionCorrelationToBeUpdatedThreadSleepingTime": {
                return this.getOrCreateConfiguration(target).getWaitForProvisionCorrelationToBeUpdatedThreadSleepingTime();
            }
        }
        return null;
    }
}

