/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.xml;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.ThreadPoolProfileBuilder;
import org.apache.camel.core.xml.AbstractCamelFactoryBean;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractCamelThreadPoolFactoryBean
extends AbstractCamelFactoryBean<ExecutorService> {
    @XmlAttribute(required=true)
    @Metadata(description="Sets the core pool size (threads to keep minimum in pool)")
    private String poolSize;
    @XmlAttribute
    @Metadata(description="Sets the maximum pool size")
    private String maxPoolSize;
    @XmlAttribute
    @Metadata(description="Sets the keep alive time for inactive threads")
    private String keepAliveTime;
    @XmlAttribute
    @Metadata(description="Sets the time unit used for keep alive time", defaultValue="SECONDS", javaType="java.util.concurrent.TimeUnit", enums="NANOSECONDS,MICROSECONDS,MILLISECONDS,SECONDS,MINUTES,HOURS,DAYS")
    private String timeUnit = TimeUnit.SECONDS.name();
    @XmlAttribute
    @Metadata(description="Sets the maximum number of tasks in the work queue. Use -1 for an unbounded queue")
    private String maxQueueSize;
    @XmlAttribute
    @Metadata(description="Sets whether to allow core threads to timeout")
    private String allowCoreThreadTimeOut;
    @XmlAttribute
    @Metadata(description="Sets the handler for tasks which cannot be executed by the thread pool.", defaultValue="CallerRuns")
    private ThreadPoolRejectedPolicy rejectedPolicy = ThreadPoolRejectedPolicy.CallerRuns;
    @XmlAttribute(required=true)
    @Metadata(description="To use a custom thread name / pattern")
    private String threadName;
    @XmlAttribute
    @Metadata(description="Whether to use a scheduled thread pool", defaultValue="false")
    private Boolean scheduled;

    @Override
    public ExecutorService getObject() throws Exception {
        int size = CamelContextHelper.parseInteger((CamelContext)this.getCamelContext(), (String)this.poolSize);
        if (size <= 0) {
            throw new IllegalArgumentException("PoolSize must be a positive number");
        }
        int max = size;
        if (this.maxPoolSize != null) {
            max = CamelContextHelper.parseInteger((CamelContext)this.getCamelContext(), (String)this.maxPoolSize);
        }
        long keepAlive = 60L;
        if (this.keepAliveTime != null) {
            keepAlive = CamelContextHelper.parseLong((CamelContext)this.getCamelContext(), (String)this.keepAliveTime);
        }
        int queueSize = -1;
        if (this.maxQueueSize != null) {
            queueSize = CamelContextHelper.parseInteger((CamelContext)this.getCamelContext(), (String)this.maxQueueSize);
        }
        boolean allow = false;
        if (this.allowCoreThreadTimeOut != null) {
            allow = CamelContextHelper.parseBoolean((CamelContext)this.getCamelContext(), (String)this.allowCoreThreadTimeOut);
        }
        TimeUnit tu = (TimeUnit)((Object)CamelContextHelper.parse((CamelContext)this.getCamelContext(), TimeUnit.class, (String)this.timeUnit));
        ThreadPoolProfile profile = new ThreadPoolProfileBuilder(this.getId()).poolSize(Integer.valueOf(size)).maxPoolSize(Integer.valueOf(max)).keepAliveTime(Long.valueOf(keepAlive), tu).maxQueueSize(Integer.valueOf(queueSize)).allowCoreThreadTimeOut(Boolean.valueOf(allow)).rejectedPolicy(this.rejectedPolicy).build();
        ExecutorService answer = this.scheduled != null && this.scheduled != false ? this.getCamelContext().getExecutorServiceManager().newScheduledThreadPool((Object)this.getId(), this.getThreadName(), profile) : this.getCamelContext().getExecutorServiceManager().newThreadPool((Object)this.getId(), this.getThreadName(), profile);
        return answer;
    }

    @Override
    public Class<ExecutorService> getObjectType() {
        return ExecutorService.class;
    }

    public String getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(String poolSize) {
        this.poolSize = poolSize;
    }

    public String getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(String maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public String getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(String keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public String getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(String timeUnit) {
        this.timeUnit = timeUnit;
    }

    public String getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(String maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public String getAllowCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    public void setAllowCoreThreadTimeOut(String allowCoreThreadTimeOut) {
        this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
    }

    public ThreadPoolRejectedPolicy getRejectedPolicy() {
        return this.rejectedPolicy;
    }

    public void setRejectedPolicy(ThreadPoolRejectedPolicy rejectedPolicy) {
        this.rejectedPolicy = rejectedPolicy;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public Boolean getScheduled() {
        return this.scheduled;
    }

    public void setScheduled(Boolean scheduled) {
        this.scheduled = scheduled;
    }
}

