/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.Injector;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringInjector
implements Injector {
    private final ConfigurableApplicationContext applicationContext;
    private int autowireMode = 3;
    private boolean dependencyCheck;

    public SpringInjector(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public <T> T newInstance(Class<T> type) {
        return this.newInstance(type, true);
    }

    public <T> T newInstance(Class<T> type, String factoryMethod) {
        T answer = null;
        try {
            Method fm = type.getMethod(factoryMethod, new Class[0]);
            if (Modifier.isStatic(fm.getModifiers()) && Modifier.isPublic(fm.getModifiers()) && fm.getReturnType() == type) {
                Object obj = fm.invoke(null, new Object[0]);
                answer = type.cast(obj);
            }
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Error invoking factory method: " + factoryMethod + " on class: " + type, (Throwable)e);
        }
        return answer;
    }

    public <T> T newInstance(Class<T> type, boolean postProcessBean) {
        Object value = postProcessBean ? this.applicationContext.getBeanFactory().createBean(type, this.autowireMode, this.dependencyCheck) : this.applicationContext.getBeanFactory().createBean(type, 0, false);
        return type.cast(value);
    }

    public boolean supportsAutoWiring() {
        return true;
    }

    public int getAutowireMode() {
        return this.autowireMode;
    }

    public void setAutowireMode(int autowireMode) {
        this.autowireMode = autowireMode;
    }

    public boolean isDependencyCheck() {
        return this.dependencyCheck;
    }

    public void setDependencyCheck(boolean dependencyCheck) {
        this.dependencyCheck = dependencyCheck;
    }

    public ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

