/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Map;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.management.DefaultInstrumentationProcessor;
import org.apache.camel.management.PerformanceCounter;
import org.apache.camel.spi.ManagementInterceptStrategy;
import org.apache.camel.util.KeyValueHolder;

public class InstrumentationInterceptStrategy
implements ManagementInterceptStrategy {
    private Map<NamedNode, PerformanceCounter> registeredCounters;
    private final Map<Processor, KeyValueHolder<NamedNode, ManagementInterceptStrategy.InstrumentationProcessor>> wrappedProcessors;

    public InstrumentationInterceptStrategy(Map<NamedNode, PerformanceCounter> registeredCounters, Map<Processor, KeyValueHolder<NamedNode, ManagementInterceptStrategy.InstrumentationProcessor>> wrappedProcessors) {
        this.registeredCounters = registeredCounters;
        this.wrappedProcessors = wrappedProcessors;
    }

    public ManagementInterceptStrategy.InstrumentationProcessor<?> createProcessor(String type) {
        return new DefaultInstrumentationProcessor(type);
    }

    public ManagementInterceptStrategy.InstrumentationProcessor<?> createProcessor(NamedNode definition, Processor target) {
        DefaultInstrumentationProcessor instrumentationProcessor = new DefaultInstrumentationProcessor(definition.getShortName(), target);
        PerformanceCounter counter = this.registeredCounters.get(definition);
        if (counter != null) {
            KeyValueHolder holder = new KeyValueHolder((Object)definition, (Object)instrumentationProcessor);
            this.wrappedProcessors.put(target, (KeyValueHolder<NamedNode, ManagementInterceptStrategy.InstrumentationProcessor>)holder);
        }
        return instrumentationProcessor;
    }
}

