/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Map;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedSendDynamicProcessorMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.SendDynamicProcessor;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.URISupport;

@ManagedResource(description="Managed SendDynamicProcessor")
public class ManagedSendDynamicProcessor
extends ManagedProcessor
implements ManagedSendDynamicProcessorMBean {
    private final SendDynamicProcessor processor;
    private String uri;
    private boolean sanitize;

    public ManagedSendDynamicProcessor(CamelContext context, SendDynamicProcessor processor, ProcessorDefinition<?> definition) {
        super(context, (Processor)processor, definition);
        this.processor = processor;
    }

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        this.sanitize = strategy.getManagementAgent().getMask() != null ? strategy.getManagementAgent().getMask() : false;
        this.uri = this.sanitize ? URISupport.sanitizeUri((String)this.processor.getUri()) : this.processor.getUri();
    }

    @Override
    public void reset() {
        super.reset();
        if (this.processor.getEndpointUtilizationStatistics() != null) {
            this.processor.getEndpointUtilizationStatistics().clear();
        }
    }

    @Override
    public Boolean getSupportExtendedInformation() {
        return true;
    }

    public SendDynamicProcessor getProcessor() {
        return this.processor;
    }

    public String getUri() {
        return this.uri;
    }

    public String getMessageExchangePattern() {
        if (this.processor.getPattern() != null) {
            return this.processor.getPattern().name();
        }
        return null;
    }

    public Integer getCacheSize() {
        return this.processor.getCacheSize();
    }

    public Boolean isIgnoreInvalidEndpoint() {
        return this.processor.isIgnoreInvalidEndpoint();
    }

    public Boolean isAllowOptimisedComponents() {
        return this.processor.isAllowOptimisedComponents();
    }

    public Boolean isOptimised() {
        return this.processor.getDynamicAware() != null;
    }

    public TabularData extendedInformation() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.endpointsUtilizationTabularType());
            EndpointUtilizationStatistics stats = this.processor.getEndpointUtilizationStatistics();
            if (stats != null) {
                for (Map.Entry entry : stats.getStatistics().entrySet()) {
                    Long hits;
                    CompositeType ct = CamelOpenMBeanTypes.endpointsUtilizationCompositeType();
                    String url = (String)entry.getKey();
                    if (this.sanitize) {
                        url = URISupport.sanitizeUri((String)url);
                    }
                    if ((hits = (Long)entry.getValue()) == null) {
                        hits = 0L;
                    }
                    CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"url", "hits"}, new Object[]{url, hits});
                    answer.put(data);
                }
            }
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

