/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jmx;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class JMXEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":serverURL";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "jmx".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "serverURL", null, false, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(31);
        props.add("initThreshold");
        props.add("notifyHigh");
        props.add("executorService");
        props.add("synchronous");
        props.add("handback");
        props.add("reconnectOnConnectionFailure");
        props.add("granularityPeriod");
        props.add("monitorType");
        props.add("password");
        props.add("bridgeErrorHandler");
        props.add("notifyLow");
        props.add("stringToCompare");
        props.add("serverURL");
        props.add("objectDomain");
        props.add("observedAttribute");
        props.add("modulus");
        props.add("differenceMode");
        props.add("offset");
        props.add("notifyMatch");
        props.add("format");
        props.add("exchangePattern");
        props.add("objectProperties");
        props.add("reconnectDelay");
        props.add("testConnectionOnStartup");
        props.add("objectName");
        props.add("notificationFilter");
        props.add("notifyDiffer");
        props.add("thresholdHigh");
        props.add("thresholdLow");
        props.add("exceptionHandler");
        props.add("user");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("password");
        secretProps.add("user");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

