/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.common.reference;

import com.bazaarvoice.jolt.common.reference.PathReference;
import com.bazaarvoice.jolt.exception.SpecException;

public abstract class BasePathReference
implements PathReference {
    private final int pathIndex;

    protected abstract char getToken();

    public BasePathReference(String refStr) {
        if (refStr == null || refStr.length() == 0 || this.getToken() != refStr.charAt(0)) {
            throw new SpecException("Invalid reference key=" + refStr + " either blank or doesn't start with correct character=" + this.getToken());
        }
        int pathIndex = 0;
        try {
            if (refStr.length() > 1) {
                String meat = refStr.substring(1);
                pathIndex = Integer.parseInt(meat);
            }
        }
        catch (NumberFormatException nfe) {
            throw new SpecException("Unable to parse '" + this.getToken() + "' reference key:" + refStr, nfe);
        }
        if (pathIndex < 0) {
            throw new SpecException("Reference:" + refStr + " can not have a negative value.");
        }
        this.pathIndex = pathIndex;
    }

    @Override
    public int getPathIndex() {
        return this.pathIndex;
    }

    @Override
    public String getCanonicalForm() {
        return this.getToken() + Integer.toString(this.pathIndex);
    }
}

