/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.modifier.spec;

import com.bazaarvoice.jolt.common.Optional;
import com.bazaarvoice.jolt.common.SpecStringParser;
import com.bazaarvoice.jolt.common.tree.MatchedElement;
import com.bazaarvoice.jolt.common.tree.WalkedPath;
import com.bazaarvoice.jolt.modifier.OpMode;
import com.bazaarvoice.jolt.modifier.function.Function;
import com.bazaarvoice.jolt.modifier.function.FunctionArg;
import com.bazaarvoice.jolt.modifier.function.FunctionEvaluator;
import com.bazaarvoice.jolt.modifier.spec.ModifierSpec;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ModifierLeafSpec
extends ModifierSpec {
    private final List<FunctionEvaluator> functionEvaluatorList = new LinkedList<FunctionEvaluator>();

    public ModifierLeafSpec(String rawJsonKey, Object rhsObj, OpMode opMode, Map<String, Function> functionsMap) {
        super(rawJsonKey, opMode);
        if (rhsObj instanceof String) {
            FunctionEvaluator functionEvaluator = ModifierLeafSpec.buildFunctionEvaluator((String)rhsObj, functionsMap);
            this.functionEvaluatorList.add(functionEvaluator);
        } else if (rhsObj instanceof List && ((List)rhsObj).size() > 0) {
            List rhsList = (List)rhsObj;
            for (Object rhs : rhsList) {
                FunctionEvaluator functionEvaluator;
                if (rhs instanceof String) {
                    functionEvaluator = ModifierLeafSpec.buildFunctionEvaluator(rhs.toString(), functionsMap);
                    this.functionEvaluatorList.add(functionEvaluator);
                    continue;
                }
                functionEvaluator = FunctionEvaluator.forArgEvaluation(FunctionArg.forLiteral(rhs, false));
                this.functionEvaluatorList.add(functionEvaluator);
            }
        } else {
            FunctionEvaluator functionEvaluator = FunctionEvaluator.forArgEvaluation(FunctionArg.forLiteral(rhsObj, false));
            this.functionEvaluatorList.add(functionEvaluator);
        }
    }

    @Override
    public void applyElement(String inputKey, Optional<Object> inputOptional, MatchedElement thisLevel, WalkedPath walkedPath, Map<String, Object> context) {
        Object parent = walkedPath.lastElement().getTreeRef();
        walkedPath.add(inputOptional.get(), thisLevel);
        Optional<Object> valueOptional = ModifierLeafSpec.getFirstAvailable(this.functionEvaluatorList, inputOptional, walkedPath, context);
        if (valueOptional.isPresent()) {
            ModifierLeafSpec.setData(parent, thisLevel, valueOptional.get(), this.opMode);
        }
        walkedPath.removeLast();
    }

    private static FunctionEvaluator buildFunctionEvaluator(String rhs, Map<String, Function> functionsMap) {
        if (!rhs.startsWith("=")) {
            return FunctionEvaluator.forArgEvaluation(ModifierLeafSpec.constructSingleArg(rhs, false));
        }
        if (!rhs.contains("(") && !rhs.endsWith(")")) {
            String functionName = rhs.substring("=".length());
            return FunctionEvaluator.forFunctionEvaluation(functionsMap.get(functionName), new FunctionArg[0]);
        }
        String fnString = rhs.substring("=".length());
        List<String> fnArgs = SpecStringParser.parseFunctionArgs(fnString);
        String functionName = fnArgs.remove(0);
        FunctionEvaluator functionEvaluator = FunctionEvaluator.forFunctionEvaluation(functionsMap.get(functionName), ModifierLeafSpec.constructArgs(fnArgs));
        return functionEvaluator;
    }

    private static Optional<Object> getFirstAvailable(List<FunctionEvaluator> functionEvaluatorList, Optional<Object> inputOptional, WalkedPath walkedPath, Map<String, Object> context) {
        Optional<Object> valueOptional = Optional.empty();
        for (FunctionEvaluator functionEvaluator : functionEvaluatorList) {
            try {
                valueOptional = functionEvaluator.evaluate(inputOptional, walkedPath, context);
                if (!valueOptional.isPresent()) continue;
                return valueOptional;
            }
            catch (Exception exception) {
            }
        }
        return valueOptional;
    }

    private static FunctionArg[] constructArgs(List<String> argsList) {
        FunctionArg[] argsArray = new FunctionArg[argsList.size()];
        for (int i = 0; i < argsList.size(); ++i) {
            String arg = argsList.get(i);
            argsArray[i] = ModifierLeafSpec.constructSingleArg(arg, true);
        }
        return argsArray;
    }

    private static FunctionArg constructSingleArg(String arg, boolean forFunction) {
        if (arg.startsWith("^")) {
            return FunctionArg.forContext(TRAVERSAL_BUILDER.build(arg.substring(1)));
        }
        if (arg.startsWith("@")) {
            return FunctionArg.forSelf(TRAVERSAL_BUILDER.build(arg));
        }
        return FunctionArg.forLiteral(arg, forFunction);
    }
}

