/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.shiftr.spec;

import com.bazaarvoice.jolt.common.Optional;
import com.bazaarvoice.jolt.common.PathEvaluatingTraversal;
import com.bazaarvoice.jolt.common.TraversalBuilder;
import com.bazaarvoice.jolt.common.pathelement.AtPathElement;
import com.bazaarvoice.jolt.common.pathelement.DollarPathElement;
import com.bazaarvoice.jolt.common.pathelement.HashPathElement;
import com.bazaarvoice.jolt.common.pathelement.TransposePathElement;
import com.bazaarvoice.jolt.common.tree.MatchedElement;
import com.bazaarvoice.jolt.common.tree.WalkedPath;
import com.bazaarvoice.jolt.exception.SpecException;
import com.bazaarvoice.jolt.shiftr.ShiftrWriter;
import com.bazaarvoice.jolt.shiftr.spec.ShiftrSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ShiftrLeafSpec
extends ShiftrSpec {
    private static final TraversalBuilder TRAVERSAL_BUILDER = new TraversalBuilder(){

        @Override
        public <T extends PathEvaluatingTraversal> T buildFromPath(String path) {
            return (T)new ShiftrWriter(path);
        }
    };
    private final List<? extends PathEvaluatingTraversal> shiftrWriters;

    public ShiftrLeafSpec(String rawKey, Object rhs) {
        super(rawKey);
        List<Object> writers;
        if (rhs instanceof String) {
            writers = Arrays.asList(TRAVERSAL_BUILDER.build(rhs));
        } else if (rhs instanceof List) {
            List rhsList = (List)rhs;
            writers = new ArrayList(rhsList.size());
            for (Object dotNotation : rhsList) {
                writers.add(TRAVERSAL_BUILDER.build(dotNotation));
            }
        } else if (rhs == null) {
            writers = Collections.emptyList();
        } else {
            throw new SpecException("Invalid Shiftr spec RHS.  Should be map, string, or array of strings.  Spec in question : " + rhs);
        }
        this.shiftrWriters = Collections.unmodifiableList(writers);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean apply(String inputKey, Optional<Object> inputOptional, WalkedPath walkedPath, Map<String, Object> output, Map<String, Object> context) {
        Object data;
        Object input = inputOptional.get();
        MatchedElement thisLevel = this.pathElement.match(inputKey, walkedPath);
        if (thisLevel == null) {
            return false;
        }
        boolean realChild = false;
        if (this.pathElement instanceof DollarPathElement || this.pathElement instanceof HashPathElement) {
            data = thisLevel.getCanonicalForm();
        } else if (this.pathElement instanceof AtPathElement) {
            data = input;
        } else if (this.pathElement instanceof TransposePathElement) {
            TransposePathElement tpe = (TransposePathElement)this.pathElement;
            Optional<Object> optional = tpe.objectEvaluate(walkedPath);
            if (!optional.isPresent()) return false;
            data = optional.get();
        } else {
            data = input;
            realChild = true;
        }
        walkedPath.add(input, thisLevel);
        for (PathEvaluatingTraversal pathEvaluatingTraversal : this.shiftrWriters) {
            pathEvaluatingTraversal.write(data, output, walkedPath);
        }
        walkedPath.removeLast();
        if (!realChild) return realChild;
        walkedPath.lastElement().getMatchedElement().incrementHashCount();
        return realChild;
    }
}

