/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import org.jooq.Configuration;
import org.jooq.ExecuteType;
import org.jooq.Record;
import org.jooq.RecordContext;
import org.jooq.RecordType;
import org.jooq.Result;
import org.jooq.impl.AbstractScope;
import org.jooq.impl.DSL;
import org.jooq.impl.Fields;

class DefaultRecordContext
extends AbstractScope
implements RecordContext {
    private final ExecuteType type;
    private final Record[] records;
    Exception exception;

    DefaultRecordContext(Configuration configuration, ExecuteType type, Record ... records) {
        super(configuration);
        this.type = type;
        this.records = records;
    }

    @Override
    public final ExecuteType type() {
        return this.type;
    }

    @Override
    public final Record record() {
        return this.records != null && this.records.length > 0 ? this.records[0] : null;
    }

    @Override
    public final Record[] batchRecords() {
        return this.records;
    }

    @Override
    public final RecordType<?> recordType() {
        Record record = this.record();
        return record != null ? new Fields(record.fields()) : null;
    }

    @Override
    public final Exception exception() {
        return this.exception;
    }

    public String toString() {
        if (this.records != null && this.records.length > 0) {
            Result<Record> result = DSL.using(this.configuration).newResult(this.records[0].fields());
            result.addAll(Arrays.asList(this.records));
            return result.toString();
        }
        return "No Records";
    }
}

