/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.PreparedStatement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.jooq.BindContext;
import org.jooq.Configuration;
import org.jooq.Constants;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Param;
import org.jooq.QueryPart;
import org.jooq.QueryPartInternal;
import org.jooq.RenderContext;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.conf.ParamType;
import org.jooq.conf.RenderFormatting;
import org.jooq.conf.RenderKeywordCase;
import org.jooq.conf.RenderNameCase;
import org.jooq.conf.RenderQuotedNames;
import org.jooq.conf.Settings;
import org.jooq.conf.SettingsTools;
import org.jooq.exception.ControlFlowSignal;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.AbstractContext;
import org.jooq.impl.DSL;
import org.jooq.impl.Identifiers;
import org.jooq.impl.Keywords;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.ScopeMarkers;
import org.jooq.impl.TableImpl;
import org.jooq.impl.Tools;
import org.jooq.impl.TopLevelCte;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;

class DefaultRenderContext
extends AbstractContext<RenderContext>
implements RenderContext {
    private static final JooqLogger log = JooqLogger.getLogger(DefaultRenderContext.class);
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[A-Za-z][A-Za-z0-9_]*");
    private static final Pattern NEWLINE = Pattern.compile("[\\n\\r]");
    private static final Set<String> SQLITE_KEYWORDS = new HashSet<String>();
    final StringBuilder sql;
    private final QueryPartList<Param<?>> bindValues;
    private int params;
    private int alias;
    private int indent;
    private Deque<Integer> indentLock;
    private boolean separator;
    private boolean newline;
    private int skipUpdateCounts;
    RenderKeywordCase cachedRenderKeywordCase;
    RenderNameCase cachedRenderNameCase;
    RenderQuotedNames cachedRenderQuotedNames;
    boolean cachedRenderFormatted;
    String cachedIndentation;
    int cachedIndentWidth;
    String cachedNewline;
    int cachedPrintMargin;

    DefaultRenderContext(Configuration configuration) {
        super(configuration, (PreparedStatement)null);
        Settings settings = configuration.settings();
        this.sql = new StringBuilder();
        this.bindValues = new QueryPartList();
        this.cachedRenderKeywordCase = SettingsTools.getRenderKeywordCase(settings);
        this.cachedRenderFormatted = Boolean.TRUE.equals(settings.isRenderFormatted());
        this.cachedRenderNameCase = SettingsTools.getRenderNameCase(settings);
        this.cachedRenderQuotedNames = SettingsTools.getRenderQuotedNames(settings);
        RenderFormatting formatting = settings.getRenderFormatting();
        if (formatting == null) {
            formatting = new RenderFormatting();
        }
        this.cachedNewline = formatting.getNewline() == null ? "\n" : formatting.getNewline();
        this.cachedIndentation = formatting.getIndentation() == null ? "  " : formatting.getIndentation();
        this.cachedIndentWidth = this.cachedIndentation.length();
        this.cachedPrintMargin = formatting.getPrintMargin() == null ? 80 : formatting.getPrintMargin();
    }

    DefaultRenderContext(RenderContext context) {
        this(context.configuration());
        this.paramType(context.paramType());
        this.qualifyCatalog(context.qualifyCatalog());
        this.qualifySchema(context.qualifySchema());
        this.quote(context.quote());
        this.castMode(context.castMode());
        this.data().putAll(context.data());
        this.declareCTE = context.declareCTE();
        this.declareWindows = context.declareWindows();
        this.declareFields = context.declareFields();
        this.declareTables = context.declareTables();
        this.declareAliases = context.declareAliases();
    }

    @Override
    public final BindContext bindValue(Object value, Field<?> field) throws DataAccessException {
        throw new UnsupportedOperationException();
    }

    final QueryPartList<Param<?>> bindValues() {
        return this.bindValues;
    }

    @Override
    void scopeMarkStart0(QueryPart part) {
        AbstractContext.ScopeStackElement e = (AbstractContext.ScopeStackElement)this.scopeStack.getOrCreate(part);
        e.positions = new int[]{this.sql.length(), -1};
        e.indent = this.indent;
    }

    @Override
    void scopeMarkEnd0(QueryPart part) {
        AbstractContext.ScopeStackElement e = (AbstractContext.ScopeStackElement)this.scopeStack.getOrCreate(part);
        e.positions[1] = this.sql.length();
    }

    @Override
    public RenderContext scopeRegister(QueryPart part) {
        if (this.scopeStack.inScope() && part instanceof TableImpl) {
            Table<?> root;
            Table<?> child = root = (Table<?>)part;
            ArrayList tables = new ArrayList();
            while (root instanceof TableImpl && (child = ((TableImpl)root).child) != null) {
                tables.add(root);
                root = child;
            }
            AbstractContext.ScopeStackElement e = (AbstractContext.ScopeStackElement)this.scopeStack.getOrCreate(root);
            if (e.joinNode == null) {
                e.joinNode = new AbstractContext.JoinNode(root);
            }
            AbstractContext.JoinNode childNode = e.joinNode;
            for (int i = tables.size() - 1; i >= 0; --i) {
                Table t = (Table)tables.get(i);
                ForeignKey k = ((TableImpl)t).childPath;
                AbstractContext.JoinNode next = childNode.children.get(k);
                if (next == null) {
                    next = new AbstractContext.JoinNode(t);
                    childNode.children.put(k, next);
                }
                childNode = next;
            }
        }
        return this;
    }

    @Override
    void scopeEnd0() {
        TopLevelCte cte = null;
        AbstractContext.ScopeStackElement beforeFirstCte = null;
        AbstractContext.ScopeStackElement afterLastCte = null;
        if (this.subqueryLevel() == 0 && (cte = (TopLevelCte)this.data((Object)Tools.DataKey.DATA_TOP_LEVEL_CTE)) != null && !cte.isEmpty()) {
            beforeFirstCte = (AbstractContext.ScopeStackElement)this.scopeStack.get(ScopeMarkers.BEFORE_FIRST_TOP_LEVEL_CTE);
            afterLastCte = (AbstractContext.ScopeStackElement)this.scopeStack.get(ScopeMarkers.AFTER_LAST_TOP_LEVEL_CTE);
        }
        for (AbstractContext.ScopeStackElement e1 : this.scopeStack) {
            String replaced = null;
            if (this.subqueryLevel() != e1.scopeLevel || e1.positions == null) continue;
            if (e1 == beforeFirstCte) {
                boolean single = cte != null && cte.size() == 1;
                RenderContext render = this.configuration.dsl().renderContext();
                if (afterLastCte != null && e1.positions[0] == afterLastCte.positions[0]) {
                    render.visit(Keywords.K_WITH);
                }
                if (single) {
                    render.formatIndentStart().formatSeparator();
                } else {
                    render.sql(' ');
                }
                ((RenderContext)((RenderContext)render.declareCTE(true)).visit(cte)).declareCTE(false);
                if (single) {
                    render.formatIndentEnd();
                }
                replaced = render.render();
            } else {
                if (e1.joinNode == null) continue;
                if (!e1.joinNode.children.isEmpty()) {
                    replaced = ((RenderContext)((RenderContext)this.configuration.dsl().renderContext().declareTables(true)).sql('(').formatIndentStart(e1.indent).formatIndentStart().formatNewLine().visit(e1.joinNode.joinTree())).formatNewLine().sql(')').render();
                }
            }
            if (replaced == null) continue;
            this.sql.replace(e1.positions[0], e1.positions[1], replaced);
            int shift = replaced.length() - (e1.positions[1] - e1.positions[0]);
            for (AbstractContext.ScopeStackElement e2 : this.scopeStack) {
                if (e2.positions == null || e2.positions[0] <= e1.positions[0]) continue;
                e2.positions[0] = e2.positions[0] + shift;
                e2.positions[1] = e2.positions[1] + shift;
            }
        }
    }

    final int peekSkipUpdateCounts() {
        return this.skipUpdateCounts;
    }

    final void incrementSkipUpdateCounts() {
        ++this.skipUpdateCounts;
    }

    @Override
    public final String peekAlias() {
        return "alias_" + (this.alias + 1);
    }

    @Override
    public final String nextAlias() {
        return "alias_" + ++this.alias;
    }

    @Override
    public final String render() {
        String prepend = null;
        String result = this.sql.toString();
        return prepend == null ? result : prepend + result;
    }

    @Override
    public final String render(QueryPart part) {
        return ((RenderContext)new DefaultRenderContext(this).visit(part)).render();
    }

    @Override
    public final RenderContext keyword(String keyword) {
        return (RenderContext)this.visit(DSL.keyword(keyword));
    }

    @Override
    public final RenderContext sql(String s) {
        return this.sql(s, s == null || !this.cachedRenderFormatted);
    }

    @Override
    public final RenderContext sql(String s, boolean literal) {
        if (!literal) {
            s = NEWLINE.matcher(s).replaceAll("$0" + this.indentation());
        }
        if (this.stringLiteral()) {
            s = StringUtils.replace(s, "'", this.stringLiteralEscapedApos);
        }
        this.sql.append(s);
        this.separator = false;
        this.newline = false;
        return this;
    }

    @Override
    public final RenderContext sql(char c) {
        this.sql.append(c);
        if (c == '\'' && this.stringLiteral()) {
            this.sql.append(c);
        }
        this.separator = false;
        this.newline = false;
        return this;
    }

    @Override
    public final RenderContext sql(int i) {
        this.sql.append(i);
        this.separator = false;
        this.newline = false;
        return this;
    }

    @Override
    public final RenderContext sql(long l) {
        this.sql.append(l);
        this.separator = false;
        this.newline = false;
        return this;
    }

    @Override
    public final RenderContext sql(float f) {
        this.sql.append(f);
        this.separator = false;
        this.newline = false;
        return this;
    }

    @Override
    public final RenderContext sql(double d) {
        this.sql.append(d);
        this.separator = false;
        this.newline = false;
        return this;
    }

    @Override
    public final RenderContext formatNewLine() {
        if (this.cachedRenderFormatted) {
            this.sql(this.cachedNewline, true);
            this.sql(this.indentation(), true);
            this.newline = true;
        }
        return this;
    }

    @Override
    public final RenderContext formatNewLineAfterPrintMargin() {
        if (this.cachedRenderFormatted && this.cachedPrintMargin > 0 && this.sql.length() - this.sql.lastIndexOf(this.cachedNewline) > this.cachedPrintMargin) {
            this.formatNewLine();
        }
        return this;
    }

    private final String indentation() {
        return StringUtils.leftPad("", this.indent, this.cachedIndentation);
    }

    @Override
    public final RenderContext format(boolean format) {
        this.cachedRenderFormatted = format;
        return this;
    }

    @Override
    public final boolean format() {
        return this.cachedRenderFormatted;
    }

    @Override
    public final RenderContext formatSeparator() {
        if (!this.separator && !this.newline) {
            if (this.cachedRenderFormatted) {
                this.formatNewLine();
            } else {
                this.sql(" ", true);
            }
            this.separator = true;
        }
        return this;
    }

    @Override
    public final RenderContext formatIndentStart() {
        return this.formatIndentStart(this.cachedIndentWidth);
    }

    @Override
    public final RenderContext formatIndentEnd() {
        return this.formatIndentEnd(this.cachedIndentWidth);
    }

    @Override
    public final RenderContext formatIndentStart(int i) {
        if (this.cachedRenderFormatted) {
            this.indent += i;
            if (this.newline) {
                this.sql.append(this.cachedIndentation);
            }
        }
        return this;
    }

    @Override
    public final RenderContext formatIndentEnd(int i) {
        if (this.cachedRenderFormatted) {
            this.indent -= i;
        }
        return this;
    }

    private final Deque<Integer> indentLock() {
        if (this.indentLock == null) {
            this.indentLock = new ArrayDeque<Integer>();
        }
        return this.indentLock;
    }

    @Override
    public final RenderContext formatIndentLockStart() {
        if (this.cachedRenderFormatted) {
            this.indentLock().push(this.indent);
            String[] lines = NEWLINE.split(this.sql);
            this.indent = lines[lines.length - 1].length();
        }
        return this;
    }

    @Override
    public final RenderContext formatIndentLockEnd() {
        if (this.cachedRenderFormatted) {
            this.indent = this.indentLock().pop();
        }
        return this;
    }

    @Override
    public final RenderContext formatPrintMargin(int margin) {
        this.cachedPrintMargin = margin;
        return this;
    }

    @Override
    public final RenderContext literal(String literal) {
        boolean needsQuote;
        if (literal == null) {
            return this;
        }
        SQLDialect family = this.family();
        boolean bl = needsQuote = family != SQLDialect.SQLITE && this.quote() || family == SQLDialect.SQLITE && SQLITE_KEYWORDS.contains(literal.toUpperCase(SettingsTools.renderLocale(this.configuration().settings()))) || family == SQLDialect.SQLITE && !IDENTIFIER_PATTERN.matcher(literal).matches();
        if (RenderNameCase.LOWER == this.cachedRenderNameCase || RenderNameCase.LOWER_IF_UNQUOTED == this.cachedRenderNameCase && !this.quote()) {
            literal = literal.toLowerCase(SettingsTools.renderLocale(this.configuration().settings()));
        } else if (RenderNameCase.UPPER == this.cachedRenderNameCase || RenderNameCase.UPPER_IF_UNQUOTED == this.cachedRenderNameCase && !this.quote()) {
            literal = literal.toUpperCase(SettingsTools.renderLocale(this.configuration().settings()));
        }
        if (needsQuote) {
            char[][][] quotes = Identifiers.QUOTES.get((Object)family);
            char start = quotes[0][0][0];
            char end = quotes[1][0][0];
            this.sql(start);
            if (literal.indexOf(end) > -1) {
                this.sql(StringUtils.replace(literal, new String(quotes[1][0]), new String(quotes[2][0])), true);
            } else {
                this.sql(literal, true);
            }
            this.sql(end);
        } else {
            this.sql(literal, true);
        }
        return this;
    }

    @Override
    @Deprecated
    public final RenderContext sql(QueryPart part) {
        return (RenderContext)this.visit(part);
    }

    @Override
    protected final void visit0(QueryPartInternal internal) {
        Param param;
        int before = this.bindValues.size();
        internal.accept(this);
        int after = this.bindValues.size();
        if (after == before && this.paramType != ParamType.INLINED && internal instanceof Param && !(param = (Param)((Object)internal)).isInline()) {
            this.bindValues.add(param);
            Integer threshold = this.settings().getInlineThreshold();
            if (threshold != null && threshold > 0) {
                this.checkForceInline(threshold);
            } else {
                switch (this.family()) {
                    case POSTGRES: {
                        this.checkForceInline(Short.MAX_VALUE);
                        break;
                    }
                    case SQLITE: {
                        this.checkForceInline(999);
                        break;
                    }
                }
            }
        }
    }

    private final void checkForceInline(int max) throws ForceInlineSignal {
        if (this.bindValues.size() > max && Boolean.TRUE.equals(this.data((Object)Tools.BooleanDataKey.DATA_COUNT_BIND_VALUES))) {
            throw new ForceInlineSignal();
        }
    }

    @Override
    @Deprecated
    public final boolean inline() {
        return this.paramType == ParamType.INLINED;
    }

    @Override
    @Deprecated
    public final boolean namedParams() {
        return this.paramType == ParamType.NAMED;
    }

    @Override
    @Deprecated
    public final RenderContext inline(boolean i) {
        this.paramType = i ? ParamType.INLINED : ParamType.INDEXED;
        return this;
    }

    @Override
    @Deprecated
    public final RenderContext namedParams(boolean r) {
        this.paramType = r ? ParamType.NAMED : ParamType.INDEXED;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("rendering    [");
        sb.append(this.render());
        sb.append("]\n");
        sb.append("parameters   [");
        sb.append((Object)this.paramType);
        sb.append("]\n");
        this.toString(sb);
        return sb.toString();
    }

    static {
        SQLITE_KEYWORDS.addAll(Arrays.asList("ABORT", "ACTION", "ADD", "AFTER", "ALL", "ALTER", "ANALYZE", "AND", "AS", "ASC", "ATTACH", "AUTOINCREMENT", "BEFORE", "BEGIN", "BETWEEN", "BY", "CASCADE", "CASE", "CAST", "CHECK", "COLLATE", "COLUMN", "COMMIT", "CONFLICT", "CONSTRAINT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "DATABASE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DETACH", "DISTINCT", "DO", "DROP", "EACH", "ELSE", "END", "ESCAPE", "EXCEPT", "EXCLUDE", "EXCLUSIVE", "EXISTS", "EXPLAIN", "FAIL", "FILTER", "FOLLOWING", "FOR", "FOREIGN", "FROM", "FULL", "GLOB", "GROUP", "GROUPS", "HAVING", "IF", "IGNORE", "IMMEDIATE", "IN", "INDEX", "INDEXED", "INITIALLY", "INNER", "INSERT", "INSTEAD", "INTERSECT", "INTO", "IS", "ISNULL", "JOIN", "KEY", "LEFT", "LIKE", "LIMIT", "MATCH", "NATURAL", "NO", "NOT", "NOTHING", "NOTNULL", "NULL", "OF", "OFFSET", "ON", "OR", "ORDER", "OTHERS", "OUTER", "OVER", "PARTITION", "PLAN", "PRAGMA", "PRECEDING", "PRIMARY", "QUERY", "RAISE", "RANGE", "RECURSIVE", "REFERENCES", "REGEXP", "REINDEX", "RELEASE", "RENAME", "REPLACE", "RESTRICT", "RIGHT", "ROLLBACK", "ROW", "ROWS", "SAVEPOINT", "SELECT", "SET", "TABLE", "TEMP", "TEMPORARY", "THEN", "TIES", "TO", "TRANSACTION", "TRIGGER", "UNBOUNDED", "UNION", "UNIQUE", "UPDATE", "USING", "VACUUM", "VALUES", "VIEW", "VIRTUAL", "WHEN", "WHERE", "WINDOW", "WITH", "WITHOUT"));
        if (!Boolean.getBoolean("org.jooq.no-logo")) {
            JooqLogger l = JooqLogger.getLogger(Constants.class);
            String message = "Thank you for using jOOQ 3.13.0";
            l.info("\n                                      \n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n@@@@@@@@@@@@@@@@  @@        @@@@@@@@@@\n@@@@@@@@@@@@@@@@@@@@        @@@@@@@@@@\n@@@@@@@@@@@@@@@@  @@  @@    @@@@@@@@@@\n@@@@@@@@@@  @@@@  @@  @@    @@@@@@@@@@\n@@@@@@@@@@        @@        @@@@@@@@@@\n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n@@@@@@@@@@        @@        @@@@@@@@@@\n@@@@@@@@@@    @@  @@  @@@@  @@@@@@@@@@\n@@@@@@@@@@    @@  @@  @@@@  @@@@@@@@@@\n@@@@@@@@@@        @@  @  @  @@@@@@@@@@\n@@@@@@@@@@        @@        @@@@@@@@@@\n@@@@@@@@@@@@@@@@@@@@@@@  @@@@@@@@@@@@@\n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  " + message + "\n                                      ");
        }
    }

    class ForceInlineSignal
    extends ControlFlowSignal {
        private static final long serialVersionUID = -9131368742983295195L;

        public ForceInlineSignal() {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Re-render query", "Forcing bind variable inlining as " + (Object)((Object)DefaultRenderContext.this.configuration().dialect()) + " does not support " + DefaultRenderContext.this.params + " bind variables (or more) in a single query");
            }
        }
    }
}

