/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Keyword;
import org.jooq.Name;
import org.jooq.SQLDialect;
import org.jooq.impl.DSL;

enum Term {
    ARRAY_AGG,
    ATAN2{

        @Override
        public String translate(SQLDialect dialect) {
            return "atan2";
        }
    }
    ,
    BIT_LENGTH{

        @Override
        public String translate(SQLDialect dialect) {
            switch (dialect.family()) {
                case DERBY: 
                case SQLITE: {
                    return "8 * length";
                }
            }
            return "bit_length";
        }
    }
    ,
    CHAR_LENGTH{

        @Override
        public String translate(SQLDialect dialect) {
            switch (dialect.family()) {
                case DERBY: 
                case SQLITE: {
                    return "length";
                }
            }
            return "char_length";
        }
    }
    ,
    CUME_DIST,
    DENSE_RANK,
    FIRST_VALUE,
    LAG,
    LAST_VALUE,
    LEAD,
    LIST_AGG{

        @Override
        public String translate(SQLDialect dialect) {
            switch (dialect.family()) {
                case SQLITE: 
                case CUBRID: 
                case H2: 
                case HSQLDB: 
                case MARIADB: 
                case MYSQL: {
                    return "group_concat";
                }
                case POSTGRES: {
                    return "string_agg";
                }
            }
            return "listagg";
        }
    }
    ,
    MEDIAN,
    MODE{

        @Override
        public String translate(SQLDialect dialect) {
            switch (dialect.family()) {
                default: 
            }
            return "mode";
        }
    }
    ,
    NTH_VALUE,
    NTILE,
    OCTET_LENGTH{

        @Override
        public String translate(SQLDialect dialect) {
            switch (dialect.family()) {
                case DERBY: 
                case SQLITE: {
                    return "length";
                }
            }
            return "octet_length";
        }
    }
    ,
    PERCENT_RANK,
    PRODUCT,
    RANK,
    ROW_NUMBER{

        @Override
        public String translate(SQLDialect dialect) {
            switch (dialect.family()) {
                case HSQLDB: {
                    return "rownum";
                }
            }
            return "row_number";
        }
    }
    ,
    STDDEV_POP{

        @Override
        public String translate(SQLDialect dialect) {
            return "stddev_pop";
        }
    }
    ,
    STDDEV_SAMP{

        @Override
        public String translate(SQLDialect dialect) {
            return "stddev_samp";
        }
    }
    ,
    VAR_POP{

        @Override
        public String translate(SQLDialect dialect) {
            return "var_pop";
        }
    }
    ,
    VAR_SAMP{

        @Override
        public String translate(SQLDialect dialect) {
            return "var_samp";
        }
    };

    private final Name name = DSL.name(this.name());
    private final Keyword keyword = DSL.keyword(this.name());
    private final String translation = this.name().toLowerCase();

    public String toString() {
        return super.toString();
    }

    public final Name toName() {
        return this.name;
    }

    public Keyword toKeyword() {
        return this.keyword;
    }

    String translate(SQLDialect dialect) {
        return this.translation;
    }
}

