/*
 * Decompiled with CFR 0.152.
 */
package org.jooq;

import org.jooq.Converter;
import org.jooq.impl.IdentityConverter;

public class Converters<T, U>
implements Converter<T, U> {
    private static final long serialVersionUID = -4307758248063822630L;
    final Converter[] chain;

    public static <T> Converter<T, T> identity(Class<T> type) {
        return new IdentityConverter<T>(type);
    }

    public static <T, U> Converter<T, U> of() {
        return new Converters<T, U>(new Converter[0]);
    }

    public static <T, U> Converter<T, U> of(Converter<T, U> converter) {
        return new Converters<T, U>(converter);
    }

    public static <T, X1, U> Converter<T, U> of(Converter<T, ? extends X1> c1, Converter<? super X1, U> c2) {
        return new Converters<T, U>(c1, c2);
    }

    public static <T, X1, X2, U> Converter<T, U> of(Converter<T, ? extends X1> c1, Converter<? super X1, ? extends X2> c2, Converter<? super X2, U> c3) {
        return new Converters<T, U>(c1, c2, c3);
    }

    public static <T, X1, X2, X3, U> Converter<T, U> of(Converter<T, ? extends X1> c1, Converter<? super X1, ? extends X2> c2, Converter<? super X2, ? extends X3> c3, Converter<? super X3, U> c4) {
        return new Converters<T, U>(c1, c2, c3, c4);
    }

    public static <T, U> Converter<U, T> inverse(final Converter<T, U> converter) {
        return new Converter<U, T>(){
            private static final long serialVersionUID = -4307758248063822630L;

            @Override
            public T from(U u) {
                return converter.to(u);
            }

            @Override
            public U to(T t) {
                return converter.from(t);
            }

            @Override
            public Class<U> fromType() {
                return converter.toType();
            }

            @Override
            public Class<T> toType() {
                return converter.fromType();
            }

            public String toString() {
                return "InverseConverter [ " + this.fromType().getName() + " -> " + this.toType().getName() + " ]";
            }
        };
    }

    Converters(Converter ... chain) {
        this.chain = chain == null ? new Converter[]{} : chain;
    }

    @Override
    public final U from(T t) {
        Object result = t;
        for (int i = 0; i < this.chain.length; ++i) {
            result = this.chain[i].from(result);
        }
        return (U)result;
    }

    @Override
    public final T to(U u) {
        Object result = u;
        for (int i = this.chain.length - 1; i >= 0; --i) {
            result = this.chain[i].to(result);
        }
        return (T)result;
    }

    @Override
    public final Class<T> fromType() {
        return this.chain[0].fromType();
    }

    @Override
    public final Class<U> toType() {
        return this.chain[this.chain.length - 1].toType();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String separator = " -> ";
        sb.append("Converters [ ");
        sb.append(this.chain[0].fromType().getName());
        for (Converter converter : this.chain) {
            sb.append(separator);
            sb.append(converter.toType().getName());
        }
        sb.append(" ]");
        return sb.toString();
    }
}

