/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.RenderContext;
import org.jooq.impl.AbstractField;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;

final class Cast<T>
extends AbstractField<T> {
    private static final long serialVersionUID = -6776617606751542856L;
    private final Field<?> field;

    public Cast(Field<?> field, DataType<T> type) {
        super(Names.N_CAST, type);
        this.field = field;
    }

    private final DataType<T> getSQLDataType() {
        return this.getDataType().getSQLDataType();
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case DERBY: {
                ctx.visit(new CastDerby());
                break;
            }
            default: {
                ctx.visit(new Native());
            }
        }
    }

    private class Native
    extends AbstractQueryPart {
        private static final long serialVersionUID = -8497561014419483312L;

        private Native() {
        }

        @Override
        public void accept(Context<?> ctx) {
            RenderContext.CastMode castMode = ctx.castMode();
            ctx.visit(Keywords.K_CAST).sql('(').castMode(RenderContext.CastMode.NEVER).visit(Cast.this.field).castMode(castMode).sql(' ').visit(Keywords.K_AS).sql(' ').sql(Cast.this.getDataType(ctx.configuration()).getCastTypeName(ctx.configuration())).sql(')');
        }
    }

    private class CastDerby
    extends Native {
        private static final long serialVersionUID = -8737153188122391258L;

        private CastDerby() {
        }

        private final Field<Boolean> asDecodeNumberToBoolean() {
            return DSL.choose(Cast.this.field).when((Field<Integer>)DSL.inline(0), DSL.inline(false)).when(DSL.inline((Integer)null), DSL.inline((Boolean)null)).otherwise(DSL.inline(true));
        }

        private final Field<Boolean> asDecodeVarcharToBoolean() {
            Field s = Cast.this.field;
            return DSL.when(s.equal(DSL.inline("0")), DSL.inline(false)).when(DSL.lower(s).equal(DSL.inline("false")), DSL.inline(false)).when(DSL.lower(s).equal(DSL.inline("f")), DSL.inline(false)).when(s.isNull(), DSL.inline((Boolean)null)).otherwise(DSL.inline(true));
        }

        @Override
        public final void accept(Context<?> ctx) {
            RenderContext.CastMode castMode = ctx.castMode();
            DataType type = Cast.this.getSQLDataType();
            if (Cast.this.field.getDataType().isNumeric() && SQLDataType.VARCHAR.equals(type)) {
                ctx.visit(Keywords.K_TRIM).sql('(').visit(Keywords.K_CAST).sql('(').visit(Keywords.K_CAST).sql('(').castMode(RenderContext.CastMode.NEVER).visit(Cast.this.field).castMode(castMode).sql(' ').visit(Keywords.K_AS).sql(" char(38))").sql(' ').visit(Keywords.K_AS).sql(' ').sql(Cast.this.getDataType(ctx.configuration()).getCastTypeName(ctx.configuration())).sql("))");
                return;
            }
            if (Cast.this.field.getDataType().isString() && (SQLDataType.FLOAT.equals(type) || SQLDataType.DOUBLE.equals(type) || SQLDataType.REAL.equals(type))) {
                ctx.visit(Keywords.K_CAST).sql('(').visit(Keywords.K_CAST).sql('(').castMode(RenderContext.CastMode.NEVER).visit(Cast.this.field).castMode(castMode).sql(' ').visit(Keywords.K_AS).sql(' ').visit(Keywords.K_DECIMAL).sql(") ").visit(Keywords.K_AS).sql(' ').sql(Cast.this.getDataType(ctx.configuration()).getCastTypeName(ctx.configuration())).sql(')');
                return;
            }
            if (Cast.this.field.getDataType().isNumeric() && SQLDataType.BOOLEAN.equals(type)) {
                ctx.visit(this.asDecodeNumberToBoolean());
                return;
            }
            if (Cast.this.field.getDataType().isString() && SQLDataType.BOOLEAN.equals(type)) {
                ctx.visit(this.asDecodeVarcharToBoolean());
                return;
            }
            super.accept(ctx);
        }
    }
}

