/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jooq.Clause;
import org.jooq.Condition;
import org.jooq.Context;
import org.jooq.Keyword;
import org.jooq.Operator;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.NoCondition;

final class CombinedCondition
extends AbstractCondition {
    private static final long serialVersionUID = -7373293246207052549L;
    private static final Clause[] CLAUSES_AND = new Clause[]{Clause.CONDITION, Clause.CONDITION_AND};
    private static final Clause[] CLAUSES_OR = new Clause[]{Clause.CONDITION, Clause.CONDITION_OR};
    final Operator operator;
    final List<Condition> conditions;

    static Condition of(Operator operator, Condition left, Condition right) {
        if (left instanceof NoCondition) {
            return right;
        }
        if (right instanceof NoCondition) {
            return left;
        }
        return new CombinedCondition(operator, left, right);
    }

    static Condition of(Operator operator, Collection<? extends Condition> conditions) {
        CombinedCondition result = null;
        Condition first = null;
        for (Condition condition : conditions) {
            if (condition instanceof NoCondition) continue;
            if (first == null) {
                first = condition;
                continue;
            }
            if (result == null) {
                result = new CombinedCondition(operator, conditions.size());
                result.add(operator, first).add(operator, condition);
                continue;
            }
            super.add(operator, condition);
        }
        if (result != null) {
            return result;
        }
        if (first != null) {
            return first;
        }
        if (!conditions.isEmpty()) {
            return DSL.noCondition();
        }
        if (operator == Operator.AND) {
            return DSL.trueCondition();
        }
        return DSL.falseCondition();
    }

    private CombinedCondition(Operator operator, int size) {
        if (operator == null) {
            throw new IllegalArgumentException("The argument 'operator' must not be null");
        }
        this.operator = operator;
        this.conditions = new ArrayList<Condition>(size);
    }

    private CombinedCondition(Operator operator, Condition left, Condition right) {
        this(operator, 2);
        this.add(operator, left);
        this.add(operator, right);
    }

    private final CombinedCondition add(Operator op, Condition condition) {
        if (condition instanceof CombinedCondition) {
            CombinedCondition combinedCondition = (CombinedCondition)condition;
            if (combinedCondition.operator == op) {
                this.conditions.addAll(combinedCondition.conditions);
            } else {
                this.conditions.add(condition);
            }
        } else {
            if (condition == null) {
                throw new IllegalArgumentException("The argument 'conditions' must not contain null");
            }
            this.conditions.add(condition);
        }
        return this;
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return this.operator == Operator.AND ? CLAUSES_AND : CLAUSES_OR;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.conditions.isEmpty()) {
            if (this.operator == Operator.AND) {
                ctx.visit(DSL.trueCondition());
            } else {
                ctx.visit(DSL.falseCondition());
            }
        } else if (this.conditions.size() == 1) {
            ctx.visit(this.conditions.get(0));
        } else {
            ctx.sql('(').formatIndentStart().formatNewLine();
            Keyword op = this.operator == Operator.AND ? Keywords.K_AND : Keywords.K_OR;
            Keyword separator = null;
            for (int i = 0; i < this.conditions.size(); ++i) {
                if (i > 0) {
                    ctx.formatSeparator();
                }
                if (separator != null) {
                    ctx.visit(separator).sql(' ');
                }
                ctx.visit(this.conditions.get(i));
                separator = op;
            }
            ctx.formatIndentEnd().formatNewLine().sql(')');
        }
    }
}

