/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;

final class DateDiff<T>
extends AbstractField<Integer> {
    private static final long serialVersionUID = -4813228000332771961L;
    private final Field<T> date1;
    private final Field<T> date2;

    DateDiff(Field<T> date1, Field<T> date2) {
        super(Names.N_DATEDIFF, SQLDataType.INTEGER);
        this.date1 = date1;
        this.date2 = date2;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MARIADB: 
            case MYSQL: {
                ctx.visit(Keywords.F_DATEDIFF).sql('(').visit(this.date1).sql(", ").visit(this.date2).sql(')');
                break;
            }
            case DERBY: {
                ctx.sql("{fn ").visit(Keywords.F_TIMESTAMPDIFF).sql('(').visit(DSL.keyword("sql_tsi_day")).sql(", ").visit(this.date2).sql(", ").visit(this.date1).sql(") }");
                break;
            }
            case FIREBIRD: {
                ctx.visit(Keywords.F_DATEDIFF).sql('(').visit(Keywords.K_DAY).sql(", ").visit(this.date2).sql(", ").visit(this.date1).sql(')');
                break;
            }
            case H2: 
            case HSQLDB: {
                ctx.visit(Keywords.F_DATEDIFF).sql("('day', ").visit(this.date2).sql(", ").visit(this.date1).sql(')');
                break;
            }
            case SQLITE: {
                ctx.sql('(').visit(Keywords.F_STRFTIME).sql("('%s', ").visit(this.date1).sql(") - ").visit(Keywords.F_STRFTIME).sql("('%s', ").visit(this.date2).sql(")) / 86400");
                break;
            }
            case CUBRID: 
            case POSTGRES: {
                ctx.sql('(').visit(this.date1).sql(" - ").visit(this.date2).sql(')');
                break;
            }
            default: {
                ctx.visit(Tools.castIfNeeded(this.date1.sub(this.date2), Integer.class));
            }
        }
    }
}

