/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jooq.AggregateFunction;
import org.jooq.ArrayAggOrderByStep;
import org.jooq.CaseConditionStep;
import org.jooq.Condition;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.OrderedAggregateFunction;
import org.jooq.Param;
import org.jooq.QueryPart;
import org.jooq.SQL;
import org.jooq.SQLDialect;
import org.jooq.WindowBeforeOverStep;
import org.jooq.WindowDefinition;
import org.jooq.WindowExcludeStep;
import org.jooq.WindowFinalStep;
import org.jooq.WindowFromFirstLastStep;
import org.jooq.WindowIgnoreNullsStep;
import org.jooq.WindowOrderByStep;
import org.jooq.WindowOverStep;
import org.jooq.WindowPartitionByStep;
import org.jooq.WindowRowsAndStep;
import org.jooq.WindowRowsStep;
import org.jooq.WindowSpecification;
import org.jooq.impl.AbstractField;
import org.jooq.impl.ConditionProviderImpl;
import org.jooq.impl.CustomField;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.SelectQueryImpl;
import org.jooq.impl.SortFieldList;
import org.jooq.impl.Term;
import org.jooq.impl.Tools;
import org.jooq.impl.WindowDefinitionImpl;
import org.jooq.impl.WindowSpecificationImpl;

class Function<T>
extends AbstractField<T>
implements OrderedAggregateFunction<T>,
ArrayAggOrderByStep<T>,
AggregateFunction<T>,
WindowFromFirstLastStep<T>,
WindowPartitionByStep<T>,
WindowRowsStep<T>,
WindowRowsAndStep<T>,
WindowExcludeStep<T> {
    private static final long serialVersionUID = 347252741712134044L;
    private static final Set<SQLDialect> SUPPORT_ARRAY_AGG = SQLDialect.supportedBy(SQLDialect.HSQLDB, SQLDialect.POSTGRES);
    private static final Set<SQLDialect> SUPPORT_GROUP_CONCAT = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    private static final Set<SQLDialect> SUPPORT_STRING_AGG = SQLDialect.supportedBy(SQLDialect.POSTGRES);
    private static final Set<SQLDialect> SUPPORT_NO_PARENS_WINDOW_REFERENCE = SQLDialect.supportedBy(SQLDialect.MYSQL, SQLDialect.POSTGRES);
    private static final Set<SQLDialect> SUPPORT_FILTER = SQLDialect.supportedBy(SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.POSTGRES, SQLDialect.SQLITE);
    private static final Set<SQLDialect> SUPPORT_DISTINCT_RVE = SQLDialect.supportedBy(SQLDialect.H2, SQLDialect.POSTGRES);
    static final Field<Integer> ASTERISK = DSL.field("*", Integer.class);
    private final Name name;
    private final Term term;
    private final QueryPartList<Field<?>> arguments;
    private final boolean distinct;
    private SortFieldList withinGroupOrderBy;
    private SortFieldList keepDenseRankOrderBy;
    private Condition filter;
    private WindowSpecificationImpl windowSpecification;
    private WindowDefinitionImpl windowDefinition;
    private Name windowName;
    private boolean first;
    private Boolean ignoreNulls;
    private Boolean fromLast;

    Function(String name, DataType<T> type, Field<?> ... arguments) {
        this(name, false, type, arguments);
    }

    Function(Term term, DataType<T> type, Field<?> ... arguments) {
        this(term, false, type, arguments);
    }

    Function(Name name, DataType<T> type, Field<?> ... arguments) {
        this(name, false, type, arguments);
    }

    Function(String name, boolean distinct, DataType<T> type, Field<?> ... arguments) {
        super(DSL.name(name), type);
        this.term = null;
        this.name = null;
        this.distinct = distinct;
        this.arguments = new QueryPartList((QueryPart[])arguments);
    }

    Function(Term term, boolean distinct, DataType<T> type, Field<?> ... arguments) {
        super(term.toName(), type);
        this.term = term;
        this.name = null;
        this.distinct = distinct;
        this.arguments = new QueryPartList((QueryPart[])arguments);
    }

    Function(Name name, boolean distinct, DataType<T> type, Field<?> ... arguments) {
        super(name, type);
        this.term = null;
        this.name = name;
        this.distinct = distinct;
        this.arguments = new QueryPartList((QueryPart[])arguments);
    }

    @Override
    public void accept(Context<?> ctx) {
        if (this.term == Term.ARRAY_AGG && SUPPORT_ARRAY_AGG.contains((Object)ctx.family())) {
            this.toSQLGroupConcat(ctx);
            this.toSQLFilterClause(ctx);
            this.toSQLOverClause(ctx);
        } else if (this.term == Term.LIST_AGG && SUPPORT_GROUP_CONCAT.contains((Object)ctx.family())) {
            this.toSQLGroupConcat(ctx);
        } else if (this.term == Term.LIST_AGG && SUPPORT_STRING_AGG.contains((Object)ctx.family())) {
            this.toSQLStringAgg(ctx);
            this.toSQLFilterClause(ctx);
            this.toSQLOverClause(ctx);
        } else if (this.term == Term.MODE && (ctx.family() == SQLDialect.H2 || ctx.family() == SQLDialect.POSTGRES)) {
            ctx.visit(DSL.mode().withinGroupOrderBy(DSL.field("{0}", new QueryPart[]{this.arguments.get(0)})));
        } else if (this.term == Term.MEDIAN && ctx.family() == SQLDialect.POSTGRES) {
            Field[] fields = new Field[this.arguments.size()];
            for (int i = 0; i < fields.length; ++i) {
                fields[i] = DSL.field("{0}", new QueryPart[]{this.arguments.get(i)});
            }
            ctx.visit(DSL.percentileCont(new BigDecimal("0.5")).withinGroupOrderBy(fields));
        } else if (this.term == Term.PRODUCT) {
            final Field<Integer> f = DSL.field("{0}", ((Field)this.arguments.get(0)).getDataType(), new QueryPart[]{this.arguments.get(0)});
            final CaseConditionStep<Integer> negatives = DSL.when(f.lt(DSL.zero()), DSL.inline(-1));
            CustomField<BigDecimal> negativesSum = new CustomField<BigDecimal>("sum", SQLDataType.NUMERIC){

                @Override
                public void accept(Context<?> c) {
                    c.visit(Function.this.distinct ? DSL.sumDistinct(negatives) : DSL.sum(negatives));
                    Function.this.toSQLFilterClause(c);
                    Function.this.toSQLOverClause(c);
                }
            };
            CustomField<BigDecimal> zerosSum = new CustomField<BigDecimal>("sum", SQLDataType.NUMERIC){

                @Override
                public void accept(Context<?> c) {
                    c.visit(DSL.sum(DSL.choose(f).when((Field<Integer>)DSL.zero(), DSL.one())));
                    Function.this.toSQLFilterClause(c);
                    Function.this.toSQLOverClause(c);
                }
            };
            CustomField<BigDecimal> logarithmsSum = new CustomField<BigDecimal>("sum", SQLDataType.NUMERIC){

                @Override
                public void accept(Context<?> c) {
                    Field<Integer> abs = DSL.abs(DSL.nullif(f, DSL.zero()));
                    Field<BigDecimal> ln = DSL.ln(abs);
                    c.visit(Function.this.distinct ? DSL.sumDistinct(ln) : DSL.sum(ln));
                    Function.this.toSQLFilterClause(c);
                    Function.this.toSQLOverClause(c);
                }
            };
            ctx.visit(DSL.when(zerosSum.gt(DSL.inline(BigDecimal.ZERO)), DSL.zero()).when(negativesSum.mod(DSL.inline(2)).lt(DSL.inline(BigDecimal.ZERO)), DSL.inline(-1)).otherwise(DSL.one()).mul(DSL.exp((Field<? extends Number>)logarithmsSum)));
        } else {
            this.toSQLArguments(ctx);
            this.toSQLKeepDenseRankOrderByClause(ctx);
            this.toSQLWithinGroupClause(ctx);
            this.toSQLFilterClause(ctx);
            this.toSQLOverClause(ctx);
        }
    }

    final void toSQLStringAgg(Context<?> ctx) {
        this.toSQLFunctionName(ctx);
        ctx.sql('(');
        if (this.distinct) {
            ctx.visit(Keywords.K_DISTINCT).sql(' ');
        }
        ctx.visit(Tools.castIfNeeded((Field)this.arguments.get(0), String.class));
        if (this.arguments.size() > 1) {
            ctx.sql(", ").visit((QueryPart)this.arguments.get(1));
        } else {
            ctx.sql(", ''");
        }
        if (!Tools.isEmpty(this.withinGroupOrderBy)) {
            ctx.sql(' ').visit(Keywords.K_ORDER_BY).sql(' ').visit(this.withinGroupOrderBy);
        }
        ctx.sql(')');
    }

    final void toSQLGroupConcat(Context<?> ctx) {
        this.toSQLFunctionName(ctx);
        ctx.sql('(');
        this.toSQLArguments1(ctx, new QueryPartList(Arrays.asList((Field)this.arguments.get(0))));
        if (!Tools.isEmpty(this.withinGroupOrderBy)) {
            ctx.sql(' ').visit(Keywords.K_ORDER_BY).sql(' ').visit(this.withinGroupOrderBy);
        }
        if (this.arguments.size() > 1) {
            if (ctx.family() == SQLDialect.SQLITE) {
                ctx.sql(", ").visit((QueryPart)this.arguments.get(1));
            } else {
                ctx.sql(' ').visit(Keywords.K_SEPARATOR).sql(' ').visit((QueryPart)this.arguments.get(1));
            }
        }
        ctx.sql(')');
    }

    final void toSQLFilterClause(Context<?> ctx) {
        if (this.filter != null && SUPPORT_FILTER.contains((Object)ctx.dialect())) {
            ctx.sql(' ').visit(Keywords.K_FILTER).sql(" (").visit(Keywords.K_WHERE).sql(' ').visit(this.filter).sql(')');
        }
    }

    final void toSQLOverClause(Context<?> ctx) {
        QueryPart window = this.window(ctx);
        if (window == null) {
            return;
        }
        if (this.term == Term.ROW_NUMBER && ctx.family() == SQLDialect.HSQLDB) {
            return;
        }
        Boolean ranking = false;
        Boolean previousRanking = null;
        if (this.term != null) {
            switch (this.term) {
                case CUME_DIST: 
                case DENSE_RANK: 
                case FIRST_VALUE: 
                case LAG: 
                case LEAD: 
                case LAST_VALUE: 
                case NTH_VALUE: 
                case NTILE: 
                case PERCENT_RANK: 
                case RANK: {
                    ranking = true;
                }
            }
        }
        ctx.sql(' ').visit(Keywords.K_OVER).sql(' ');
        previousRanking = (Boolean)ctx.data((Object)Tools.BooleanDataKey.DATA_RANKING_FUNCTION, ranking);
        ctx.visit(window);
        if (Boolean.TRUE.equals(previousRanking)) {
            ctx.data((Object)Tools.BooleanDataKey.DATA_RANKING_FUNCTION, previousRanking);
        } else {
            ctx.data().remove((Object)Tools.BooleanDataKey.DATA_RANKING_FUNCTION);
        }
    }

    final QueryPart window(Context<?> ctx) {
        if (this.windowSpecification != null) {
            return DSL.sql("({0})", this.windowSpecification);
        }
        if (this.windowDefinition != null) {
            if (SUPPORT_NO_PARENS_WINDOW_REFERENCE.contains((Object)ctx.family())) {
                return this.windowDefinition;
            }
            return DSL.sql("({0})", this.windowDefinition);
        }
        if (this.windowName != null) {
            if (ctx.dialect().supports(SelectQueryImpl.SUPPORT_WINDOW_CLAUSE)) {
                return this.windowName;
            }
            QueryPartList windows = (QueryPartList)ctx.data((Object)Tools.DataKey.DATA_WINDOW_DEFINITIONS);
            if (windows != null) {
                for (WindowDefinition window : windows) {
                    if (!((WindowDefinitionImpl)window).getName().equals(this.windowName)) continue;
                    return DSL.sql("({0})", window);
                }
            } else {
                return this.windowName;
            }
        }
        return null;
    }

    final void toSQLKeepDenseRankOrderByClause(Context<?> ctx) {
        if (!Tools.isEmpty(this.keepDenseRankOrderBy)) {
            ctx.sql(' ').visit(Keywords.K_KEEP).sql(" (").visit(Keywords.K_DENSE_RANK).sql(' ').visit(this.first ? Keywords.K_FIRST : Keywords.K_LAST).sql(' ').visit(Keywords.K_ORDER_BY).sql(' ').visit(this.keepDenseRankOrderBy).sql(')');
        }
    }

    final void toSQLWithinGroupClause(Context<?> ctx) {
        if (this.withinGroupOrderBy != null) {
            ctx.sql(' ').visit(Keywords.K_WITHIN_GROUP).sql(" (").visit(Keywords.K_ORDER_BY).sql(' ');
            if (this.withinGroupOrderBy.isEmpty()) {
                ctx.visit(Keywords.K_NULL);
            } else {
                ctx.visit(this.withinGroupOrderBy);
            }
            ctx.sql(')');
        }
    }

    final void toSQLArguments(Context<?> ctx) {
        this.toSQLFunctionName(ctx);
        ctx.sql('(');
        this.toSQLArguments0(ctx);
        ctx.sql(')');
        this.toSQLArguments2(ctx);
    }

    final void toSQLArguments0(Context<?> ctx) {
        this.toSQLArguments1(ctx, this.arguments);
    }

    final void toSQLArguments1(Context<?> ctx, QueryPartList<Field<?>> args) {
        if (this.distinct) {
            ctx.visit(Keywords.K_DISTINCT).sql(' ');
            if (args.size() > 1 && SUPPORT_DISTINCT_RVE.contains((Object)ctx.family())) {
                ctx.sql('(');
            }
        }
        if (!args.isEmpty()) {
            if (this.filter == null || SUPPORT_FILTER.contains((Object)ctx.dialect())) {
                ctx.visit(args);
            } else {
                QueryPartList<CaseConditionStep<Param<Integer>>> expressions = new QueryPartList<CaseConditionStep<Param<Integer>>>();
                for (Field<?> argument : args) {
                    expressions.add(DSL.when(this.filter, argument == ASTERISK ? DSL.one() : argument));
                }
                ctx.visit(expressions);
            }
        }
        if (this.distinct && args.size() > 1 && SUPPORT_DISTINCT_RVE.contains((Object)ctx.family())) {
            ctx.sql(')');
        }
    }

    final void toSQLArguments2(Context<?> ctx) {
        if (Boolean.TRUE.equals(this.fromLast)) {
            ctx.sql(' ').visit(Keywords.K_FROM).sql(' ').visit(Keywords.K_LAST);
        } else if (Boolean.FALSE.equals(this.fromLast)) {
            ctx.sql(' ').visit(Keywords.K_FROM).sql(' ').visit(Keywords.K_FIRST);
        }
        if (Boolean.TRUE.equals(this.ignoreNulls)) {
            ctx.sql(' ').visit(Keywords.K_IGNORE_NULLS);
        } else if (Boolean.FALSE.equals(this.ignoreNulls)) {
            ctx.sql(' ').visit(Keywords.K_RESPECT_NULLS);
        }
    }

    final void toSQLFunctionName(Context<?> ctx) {
        if (this.name != null) {
            ctx.visit(this.name);
        } else if (this.term != null) {
            ctx.sql(this.term.translate(ctx.dialect()));
        } else {
            ctx.sql(this.getName());
        }
    }

    final QueryPartList<Field<?>> getArguments() {
        return this.arguments;
    }

    @Override
    public final AggregateFunction<T> withinGroupOrderBy(OrderField<?> ... fields) {
        return this.withinGroupOrderBy(Arrays.asList(fields));
    }

    @Override
    public final AggregateFunction<T> withinGroupOrderBy(Collection<? extends OrderField<?>> fields) {
        if (this.withinGroupOrderBy == null) {
            this.withinGroupOrderBy = new SortFieldList();
        }
        this.withinGroupOrderBy.addAll(Tools.sortFields(fields));
        return this;
    }

    @Override
    public final WindowOverStep<T> ignoreNulls() {
        this.ignoreNulls = true;
        return this;
    }

    @Override
    public final WindowOverStep<T> respectNulls() {
        this.ignoreNulls = false;
        return this;
    }

    @Override
    public final WindowIgnoreNullsStep<T> fromFirst() {
        this.fromLast = false;
        return this;
    }

    @Override
    public final WindowIgnoreNullsStep<T> fromLast() {
        this.fromLast = true;
        return this;
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Condition c) {
        this.filter = c;
        return this;
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Condition ... conditions) {
        return this.filterWhere(Arrays.asList(conditions));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Collection<? extends Condition> conditions) {
        ConditionProviderImpl c = new ConditionProviderImpl();
        c.addConditions(conditions);
        return this.filterWhere((Condition)c);
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Field<Boolean> field) {
        return this.filterWhere(DSL.condition(field));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Boolean field) {
        return this.filterWhere(DSL.condition(field));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(SQL sql) {
        return this.filterWhere(DSL.condition(sql));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(String sql) {
        return this.filterWhere(DSL.condition(sql));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(String sql, Object ... bindings) {
        return this.filterWhere(DSL.condition(sql, bindings));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(String sql, QueryPart ... parts) {
        return this.filterWhere(DSL.condition(sql, parts));
    }

    @Override
    public final WindowPartitionByStep<T> over() {
        this.windowSpecification = new WindowSpecificationImpl();
        return this;
    }

    @Override
    public final WindowFinalStep<T> over(WindowSpecification specification) {
        this.windowSpecification = specification instanceof WindowSpecificationImpl ? (WindowSpecificationImpl)specification : new WindowSpecificationImpl((WindowDefinitionImpl)specification);
        return this;
    }

    @Override
    public final WindowFinalStep<T> over(WindowDefinition definition) {
        this.windowDefinition = (WindowDefinitionImpl)definition;
        return this;
    }

    @Override
    public final WindowFinalStep<T> over(String n) {
        return this.over(DSL.name(n));
    }

    @Override
    public final WindowFinalStep<T> over(Name n) {
        this.windowName = n;
        return this;
    }

    @Override
    public final WindowOrderByStep<T> partitionBy(Field<?> ... fields) {
        this.windowSpecification.partitionBy((Field[])fields);
        return this;
    }

    @Override
    public final WindowOrderByStep<T> partitionBy(Collection<? extends Field<?>> fields) {
        this.windowSpecification.partitionBy((Collection)fields);
        return this;
    }

    @Override
    @Deprecated
    public final WindowOrderByStep<T> partitionByOne() {
        this.windowSpecification.partitionByOne();
        return this;
    }

    @Override
    public final Function<T> orderBy(OrderField<?> ... fields) {
        if (this.windowSpecification != null) {
            this.windowSpecification.orderBy((OrderField[])fields);
        } else {
            this.withinGroupOrderBy((OrderField[])fields);
        }
        return this;
    }

    @Override
    public final Function<T> orderBy(Collection<? extends OrderField<?>> fields) {
        if (this.windowSpecification != null) {
            this.windowSpecification.orderBy((Collection)fields);
        } else {
            this.withinGroupOrderBy((Collection)fields);
        }
        return this;
    }

    @Override
    public final WindowExcludeStep<T> rowsUnboundedPreceding() {
        this.windowSpecification.rowsUnboundedPreceding();
        return this;
    }

    @Override
    public final WindowExcludeStep<T> rowsPreceding(int number) {
        this.windowSpecification.rowsPreceding(number);
        return this;
    }

    @Override
    public final WindowExcludeStep<T> rowsCurrentRow() {
        this.windowSpecification.rowsCurrentRow();
        return this;
    }

    @Override
    public final WindowExcludeStep<T> rowsUnboundedFollowing() {
        this.windowSpecification.rowsUnboundedFollowing();
        return this;
    }

    @Override
    public final WindowExcludeStep<T> rowsFollowing(int number) {
        this.windowSpecification.rowsFollowing(number);
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> rowsBetweenUnboundedPreceding() {
        this.windowSpecification.rowsBetweenUnboundedPreceding();
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> rowsBetweenPreceding(int number) {
        this.windowSpecification.rowsBetweenPreceding(number);
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> rowsBetweenCurrentRow() {
        this.windowSpecification.rowsBetweenCurrentRow();
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> rowsBetweenUnboundedFollowing() {
        this.windowSpecification.rowsBetweenUnboundedFollowing();
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> rowsBetweenFollowing(int number) {
        this.windowSpecification.rowsBetweenFollowing(number);
        return this;
    }

    @Override
    public final WindowExcludeStep<T> rangeUnboundedPreceding() {
        this.windowSpecification.rangeUnboundedPreceding();
        return this;
    }

    @Override
    public final WindowExcludeStep<T> rangePreceding(int number) {
        this.windowSpecification.rangePreceding(number);
        return this;
    }

    @Override
    public final WindowExcludeStep<T> rangeCurrentRow() {
        this.windowSpecification.rangeCurrentRow();
        return this;
    }

    @Override
    public final WindowExcludeStep<T> rangeUnboundedFollowing() {
        this.windowSpecification.rangeUnboundedFollowing();
        return this;
    }

    @Override
    public final WindowExcludeStep<T> rangeFollowing(int number) {
        this.windowSpecification.rangeFollowing(number);
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> rangeBetweenUnboundedPreceding() {
        this.windowSpecification.rangeBetweenUnboundedPreceding();
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> rangeBetweenPreceding(int number) {
        this.windowSpecification.rangeBetweenPreceding(number);
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> rangeBetweenCurrentRow() {
        this.windowSpecification.rangeBetweenCurrentRow();
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> rangeBetweenUnboundedFollowing() {
        this.windowSpecification.rangeBetweenUnboundedFollowing();
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> rangeBetweenFollowing(int number) {
        this.windowSpecification.rangeBetweenFollowing(number);
        return this;
    }

    @Override
    public final WindowExcludeStep<T> groupsUnboundedPreceding() {
        this.windowSpecification.groupsUnboundedPreceding();
        return this;
    }

    @Override
    public final WindowExcludeStep<T> groupsPreceding(int number) {
        this.windowSpecification.groupsPreceding(number);
        return this;
    }

    @Override
    public final WindowExcludeStep<T> groupsCurrentRow() {
        this.windowSpecification.groupsCurrentRow();
        return this;
    }

    @Override
    public final WindowExcludeStep<T> groupsUnboundedFollowing() {
        this.windowSpecification.groupsUnboundedFollowing();
        return this;
    }

    @Override
    public final WindowExcludeStep<T> groupsFollowing(int number) {
        this.windowSpecification.groupsFollowing(number);
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> groupsBetweenUnboundedPreceding() {
        this.windowSpecification.groupsBetweenUnboundedPreceding();
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> groupsBetweenPreceding(int number) {
        this.windowSpecification.groupsBetweenPreceding(number);
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> groupsBetweenCurrentRow() {
        this.windowSpecification.groupsBetweenCurrentRow();
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> groupsBetweenUnboundedFollowing() {
        this.windowSpecification.groupsBetweenUnboundedFollowing();
        return this;
    }

    @Override
    public final WindowRowsAndStep<T> groupsBetweenFollowing(int number) {
        this.windowSpecification.groupsBetweenFollowing(number);
        return this;
    }

    @Override
    public final WindowExcludeStep<T> andUnboundedPreceding() {
        this.windowSpecification.andUnboundedPreceding();
        return this;
    }

    @Override
    public final WindowExcludeStep<T> andPreceding(int number) {
        this.windowSpecification.andPreceding(number);
        return this;
    }

    @Override
    public final WindowExcludeStep<T> andCurrentRow() {
        this.windowSpecification.andCurrentRow();
        return this;
    }

    @Override
    public final WindowExcludeStep<T> andUnboundedFollowing() {
        this.windowSpecification.andUnboundedFollowing();
        return this;
    }

    @Override
    public final WindowExcludeStep<T> andFollowing(int number) {
        this.windowSpecification.andFollowing(number);
        return this;
    }

    @Override
    public final WindowFinalStep<T> excludeCurrentRow() {
        this.windowSpecification.excludeCurrentRow();
        return this;
    }

    @Override
    public final WindowFinalStep<T> excludeGroup() {
        this.windowSpecification.excludeGroup();
        return this;
    }

    @Override
    public final WindowFinalStep<T> excludeTies() {
        this.windowSpecification.excludeTies();
        return this;
    }

    @Override
    public final WindowFinalStep<T> excludeNoOthers() {
        this.windowSpecification.excludeNoOthers();
        return this;
    }
}

