/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.BindContext;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.RenderContext;
import org.jooq.UDTRecord;
import org.jooq.conf.ParamType;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.AbstractParam;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class UDTConstant<R extends UDTRecord<R>>
extends AbstractParam<R> {
    private static final long serialVersionUID = 6807729087019209084L;

    UDTConstant(R value) {
        super(value, value.getUDT().getDataType());
    }

    @Override
    public void accept(Context<?> ctx) {
        if (ctx instanceof RenderContext) {
            this.toSQL0((RenderContext)ctx);
        } else {
            this.bind0((BindContext)ctx);
        }
    }

    final void toSQL0(RenderContext ctx) {
        ParamType paramType = ctx.paramType();
        if (this.isInline()) {
            ctx.paramType(ParamType.INLINED);
        }
        switch (ctx.family()) {
            case POSTGRES: {
                this.toSQLInline(ctx);
                break;
            }
            default: {
                this.toSQLInline(ctx);
            }
        }
        if (this.isInline()) {
            ctx.paramType(paramType);
        }
    }

    private final void toSQLInline(RenderContext ctx) {
        switch (ctx.family()) {
            case POSTGRES: {
                ctx.visit(Keywords.K_ROW);
                break;
            }
            default: {
                ctx.visit(((UDTRecord)this.value).getUDT());
            }
        }
        ctx.sql('(');
        String separator = "";
        for (Field<?> field : ((UDTRecord)this.value).fields()) {
            ctx.sql(separator);
            ctx.visit(DSL.val(((UDTRecord)this.value).get(field), field));
            separator = ", ";
        }
        ctx.sql(')');
    }

    @Deprecated
    private final String getInlineConstructor(RenderContext ctx) {
        switch (ctx.family()) {
            case POSTGRES: {
                return "ROW";
            }
        }
        return Tools.getMappedUDTName(ctx.configuration(), (UDTRecord)this.value);
    }

    final void bind0(BindContext ctx) {
        switch (ctx.family()) {
            case POSTGRES: {
                for (Field<?> field : ((UDTRecord)this.value).fields()) {
                    ctx.visit(DSL.val(((UDTRecord)this.value).get(field)));
                }
                break;
            }
            default: {
                throw new SQLDialectNotSupportedException("UDTs not supported in dialect " + (Object)((Object)ctx.dialect()));
            }
        }
    }
}

