/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.CreateSchemaFinalStep;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.impl.AbstractRowCountQuery;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class CreateSchemaImpl
extends AbstractRowCountQuery
implements CreateSchemaFinalStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.CREATE_SCHEMA};
    private static final Set<SQLDialect> NO_SUPPORT_IF_NOT_EXISTS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private final Schema schema;
    private final boolean ifNotExists;

    CreateSchemaImpl(Configuration configuration, Schema schema, boolean ifNotExists) {
        super(configuration);
        this.schema = schema;
        this.ifNotExists = ifNotExists;
    }

    final Schema $schema() {
        return this.schema;
    }

    final boolean $ifNotExists() {
        return this.ifNotExists;
    }

    private final boolean supportsIfNotExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_NOT_EXISTS.contains((Object)ctx.family());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifNotExists && !this.supportsIfNotExists(ctx)) {
            Tools.beginTryCatch(ctx, DDLStatementType.CREATE_SCHEMA);
            this.accept0(ctx);
            Tools.endTryCatch(ctx, DDLStatementType.CREATE_SCHEMA);
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        this.accept1(ctx);
    }

    private final void accept1(Context<?> ctx) {
        ctx.start(Clause.CREATE_SCHEMA_NAME).visit(Keywords.K_CREATE);
        ctx.sql(' ').visit(Keywords.K_SCHEMA);
        if (this.ifNotExists && this.supportsIfNotExists(ctx)) {
            ctx.sql(' ').visit(Keywords.K_IF_NOT_EXISTS);
        }
        ctx.sql(' ').visit(this.schema).end(Clause.CREATE_SCHEMA_NAME);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

