/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Meta;
import org.jooq.Name;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.conf.ParseSearchSchema;
import org.jooq.conf.ParseUnsupportedSyntax;
import org.jooq.conf.ParseWithMetaLookups;
import org.jooq.conf.Settings;
import org.jooq.conf.SettingsTools;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.FieldProxy;
import org.jooq.impl.ParserException;
import org.jooq.impl.ScopeStack;

final class ParserContext {
    private static final boolean PRO_EDITION = false;
    final DSLContext dsl;
    final Locale locale;
    final Meta meta;
    final char[] sql;
    private final ParseWithMetaLookups metaLookups;
    private boolean metaLookupsForceIgnore;
    private int position = 0;
    private boolean ignoreHints = true;
    private final Object[] bindings;
    private int bindIndex = 0;
    private String delimiter = ";";
    private final ScopeStack<String, Table<?>> tableScope = new ScopeStack(null);
    private final ScopeStack<String, FieldProxy<?>> lookupFields = new ScopeStack(null);
    private boolean scopeClear = false;

    ParserContext(DSLContext dsl, Meta meta, ParseWithMetaLookups metaLookups, String sqlString, Object[] bindings) {
        this.dsl = dsl;
        this.locale = SettingsTools.parseLocale(dsl.settings());
        this.meta = meta;
        this.metaLookups = metaLookups;
        this.sql = sqlString.toCharArray();
        this.bindings = bindings;
    }

    Configuration configuration() {
        return this.dsl.configuration();
    }

    Settings settings() {
        return this.configuration().settings();
    }

    SQLDialect dialect() {
        SQLDialect result = this.settings().getParseDialect();
        if (result == null) {
            result = SQLDialect.DEFAULT;
        }
        return result;
    }

    SQLDialect family() {
        return this.dialect().family();
    }

    boolean metaLookupsForceIgnore() {
        return this.metaLookupsForceIgnore;
    }

    ParserContext metaLookupsForceIgnore(boolean m) {
        this.metaLookupsForceIgnore = m;
        return this;
    }

    boolean requireProEdition() {
        throw this.exception("Feature only supported in pro edition");
    }

    boolean requireUnsupportedSyntax() {
        if (this.dsl.configuration().settings().getParseUnsupportedSyntax() == ParseUnsupportedSyntax.FAIL) {
            throw this.exception("Syntax not supported");
        }
        return true;
    }

    String substring(int startPosition, int endPosition) {
        return new String(this.sql, startPosition, endPosition - startPosition);
    }

    ParserException internalError() {
        return this.exception("Internal Error");
    }

    ParserException expected(String object) {
        return this.init(new ParserException(this.mark(), object + " expected"));
    }

    ParserException expected(String ... objects) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < objects.length; ++i) {
            if (i == 0) {
                sb.append(objects[i]);
                continue;
            }
            if (i == objects.length - 1) {
                sb.append(", or ").append(objects[i]);
                continue;
            }
            sb.append(", ").append(objects[i]);
        }
        return this.init(new ParserException(this.mark(), sb.toString() + " expected"));
    }

    ParserException notImplemented(String feature) {
        return this.init(new ParserException(this.mark(), feature + " not yet implemented"));
    }

    ParserException unsupportedClause() {
        return this.init(new ParserException(this.mark(), "Unsupported clause"));
    }

    ParserException exception(String message) {
        return this.init(new ParserException(this.mark(), message));
    }

    ParserException init(ParserException e) {
        int[] line = this.line();
        return e.position(this.position).line(line[0]).column(line[1]);
    }

    Object nextBinding() {
        if (this.bindIndex < this.bindings.length) {
            return this.bindings[this.bindIndex++];
        }
        if (this.bindings.length == 0) {
            return null;
        }
        throw this.exception("No binding provided for bind index " + (this.bindIndex + 1));
    }

    int[] line() {
        int line = 1;
        int column = 1;
        for (int i = 0; i < this.position; ++i) {
            if (this.sql[i] == '\r') {
                ++line;
                column = 1;
                if (i + 1 >= this.sql.length || this.sql[i + 1] != '\n') continue;
                ++i;
                continue;
            }
            if (this.sql[i] == '\n') {
                ++line;
                column = 1;
                continue;
            }
            ++column;
        }
        return new int[]{line, column};
    }

    char character() {
        return this.character(this.position);
    }

    char character(int pos) {
        return pos >= 0 && pos < this.sql.length ? this.sql[pos] : (char)' ';
    }

    char characterNext() {
        return this.character(this.position + 1);
    }

    int position() {
        return this.position;
    }

    void position(int newPosition) {
        this.position = newPosition;
    }

    void positionInc() {
        this.positionInc(1);
    }

    void positionInc(int inc) {
        this.position(this.position + inc);
    }

    String delimiter() {
        return this.delimiter;
    }

    void delimiter(String newDelimiter) {
        this.delimiter = newDelimiter;
    }

    boolean ignoreHints() {
        return this.ignoreHints;
    }

    void ignoreHints(boolean newIgnoreHints) {
        this.ignoreHints = newIgnoreHints;
    }

    boolean isWhitespace() {
        return Character.isWhitespace(this.character());
    }

    boolean isWhitespace(int pos) {
        return Character.isWhitespace(this.character(pos));
    }

    boolean isIdentifierPart() {
        return this.isIdentifierPart(this.character());
    }

    boolean isIdentifierPart(int pos) {
        return this.isIdentifierPart(this.character(pos));
    }

    boolean isIdentifierPart(char character) {
        return Character.isJavaIdentifierPart(character) || (character == '@' || character == '#') && character != this.delimiter.charAt(0);
    }

    boolean hasMore() {
        return this.position < this.sql.length;
    }

    boolean done() {
        return this.position >= this.sql.length && (this.bindings.length == 0 || this.bindings.length == this.bindIndex);
    }

    boolean done(String message) {
        if (this.done()) {
            return true;
        }
        throw this.exception(message);
    }

    String mark() {
        int[] line = this.line();
        return "[" + line[0] + ":" + line[1] + "] " + (this.position > 50 ? "..." : "") + this.substring(Math.max(0, this.position - 50), this.position) + "[*]" + this.substring(this.position, Math.min(this.sql.length, this.position + 80)) + (this.sql.length > this.position + 80 ? "..." : "");
    }

    void scope(Table<?> table) {
        this.tableScope.set(table.getName(), table);
    }

    void scopeStart() {
        this.tableScope.scopeStart();
        this.lookupFields.scopeStart();
        this.lookupFields.setAll(null);
    }

    void scopeEnd() {
        ArrayList retain = new ArrayList();
        for (FieldProxy<?> fieldProxy : this.lookupFields) {
            Field<?> f1 = null;
            for (Table<?> t : this.tableScope) {
                Field<?> f2 = t.field(fieldProxy.getName());
                if (f2 == null) continue;
                if (f1 != null) {
                    this.position(fieldProxy.position);
                    throw this.exception("Ambiguous field identifier");
                }
                f1 = f2;
            }
            if (f1 != null) {
                fieldProxy.delegate = (AbstractField)f1;
                fieldProxy.sql = null;
                continue;
            }
            retain.add(fieldProxy);
        }
        this.lookupFields.scopeEnd();
        this.tableScope.scopeEnd();
        for (FieldProxy<Object> fieldProxy : retain) {
            if (this.lookupFields.get(fieldProxy.getName()) != null) continue;
            if (this.lookupFields.inScope()) {
                this.lookupFields.set(fieldProxy.getName(), fieldProxy);
                continue;
            }
            this.unknownField(fieldProxy);
        }
    }

    void scopeClear() {
        this.scopeClear = true;
    }

    void scopeResolve() {
        if (!this.lookupFields.isEmpty()) {
            this.unknownField(this.lookupFields.iterator().next());
        }
    }

    void unknownField(FieldProxy<?> field) {
        if (!this.scopeClear && !this.metaLookupsForceIgnore && this.metaLookups == ParseWithMetaLookups.THROW_ON_FAILURE) {
            this.position(field.position);
            throw this.exception("Unknown field identifier");
        }
    }

    Table<?> lookupTable(Name name) {
        if (this.meta != null) {
            List<Table<?>> tables = this.meta.getTables(name);
            if (!tables.isEmpty()) {
                for (Table<?> table : tables) {
                    if (table.getQualifiedName().qualified() != name.qualified()) continue;
                    return tables.get(0);
                }
            }
            if (!name.qualified()) {
                for (ParseSearchSchema schema : this.settings().getParseSearchPath()) {
                    tables = this.meta.getTables(DSL.name(schema.getCatalog(), schema.getSchema()).append(name));
                    if (tables.size() != 1) continue;
                    return tables.get(0);
                }
            }
        }
        if (!this.metaLookupsForceIgnore && this.metaLookups == ParseWithMetaLookups.THROW_ON_FAILURE) {
            throw this.exception("Unknown table identifier");
        }
        return DSL.table(name);
    }

    Field<?> lookupField(Name name) {
        Field<?> field;
        List<Table<?>> tables;
        if (this.meta != null && (tables = this.meta.getTables(name.qualifier())).size() == 1 && (field = tables.get(0).field(name)) != null) {
            return field;
        }
        if (this.metaLookups == ParseWithMetaLookups.OFF) {
            return DSL.field(name);
        }
        FieldProxy<Object> field2 = this.lookupFields.get(name.last());
        if (field2 == null) {
            field2 = new FieldProxy((AbstractField)DSL.field(name), this.sql, this.position);
            this.lookupFields.set(name.last(), field2);
        }
        return field2;
    }

    public String toString() {
        return this.mark();
    }
}

