/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jooq.Context;
import org.jooq.QueryPart;
import org.jooq.Statement;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.Tools;

class QueryPartList<T extends QueryPart>
extends AbstractQueryPart
implements List<T> {
    private static final long serialVersionUID = -2936922742534009564L;
    private final List<T> wrappedList = new ArrayList<T>();
    private final boolean qualify;

    QueryPartList() {
        this(true);
    }

    QueryPartList(Collection<? extends T> wrappedList) {
        this(wrappedList, true);
    }

    QueryPartList(T[] wrappedList) {
        this((QueryPart[])wrappedList, true);
    }

    QueryPartList(boolean qualify) {
        this((Collection)null, qualify);
    }

    QueryPartList(Collection<? extends T> wrappedList, boolean qualify) {
        this.qualify = qualify;
        if (wrappedList != null && !wrappedList.isEmpty()) {
            this.addAll((Collection<? extends T>)wrappedList);
        }
    }

    QueryPartList(T[] wrappedList, boolean qualify) {
        this(Arrays.asList(wrappedList), qualify);
    }

    @Override
    public void accept(Context<?> ctx) {
        boolean previous = ctx.qualify();
        if (!this.qualify) {
            ctx.qualify(this.qualify);
        }
        if (this.isEmpty()) {
            this.toSQLEmptyList(ctx);
        } else {
            boolean indent;
            String separator = "";
            boolean bl = indent = this.size() > 1 && !Boolean.TRUE.equals(ctx.data((Object)Tools.BooleanDataKey.DATA_LIST_ALREADY_INDENTED));
            if (indent) {
                ctx.formatIndentStart();
            }
            for (int i = 0; i < this.size(); ++i) {
                ctx.sql(separator);
                if (i > 0 || indent) {
                    ctx.formatNewLine();
                }
                Object part = this.get(i);
                ctx.visit((QueryPart)part);
                if (part instanceof Statement) continue;
                separator = ", ";
            }
            if (indent) {
                ctx.formatIndentEnd().formatNewLine();
            }
        }
        ctx.qualify(previous);
    }

    protected void toSQLEmptyList(Context<?> context) {
    }

    @Override
    public final int size() {
        return this.wrappedList.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.wrappedList.isEmpty();
    }

    @Override
    public final boolean contains(Object o) {
        return this.wrappedList.contains(o);
    }

    @Override
    public final Iterator<T> iterator() {
        return this.wrappedList.iterator();
    }

    @Override
    public final Object[] toArray() {
        return this.wrappedList.toArray();
    }

    @Override
    public final <E> E[] toArray(E[] a) {
        return this.wrappedList.toArray(a);
    }

    @Override
    public final boolean add(T e) {
        if (e != null) {
            return this.wrappedList.add(e);
        }
        return false;
    }

    @Override
    public final boolean remove(Object o) {
        return this.wrappedList.remove(o);
    }

    @Override
    public final boolean containsAll(Collection<?> c) {
        return this.wrappedList.containsAll(c);
    }

    @Override
    public final boolean addAll(Collection<? extends T> c) {
        return this.wrappedList.addAll(this.removeNulls(c));
    }

    @Override
    public final boolean addAll(int index, Collection<? extends T> c) {
        return this.wrappedList.addAll(index, this.removeNulls(c));
    }

    private final Collection<? extends T> removeNulls(Collection<? extends T> c) {
        boolean containsNulls;
        try {
            containsNulls = c.contains(null);
        }
        catch (NullPointerException ignore) {
            containsNulls = false;
        }
        if (containsNulls) {
            ArrayList<T> list = new ArrayList<T>(c);
            Iterator it = list.iterator();
            while (it.hasNext()) {
                if (it.next() != null) continue;
                it.remove();
            }
            return list;
        }
        return c;
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        return this.wrappedList.removeAll(c);
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        return this.wrappedList.retainAll(c);
    }

    @Override
    public final void clear() {
        this.wrappedList.clear();
    }

    @Override
    public final T get(int index) {
        return (T)((QueryPart)this.wrappedList.get(index));
    }

    @Override
    public final T set(int index, T element) {
        if (element != null) {
            return (T)((QueryPart)this.wrappedList.set(index, element));
        }
        return null;
    }

    @Override
    public final void add(int index, T element) {
        if (element != null) {
            this.wrappedList.add(index, element);
        }
    }

    @Override
    public final T remove(int index) {
        return (T)((QueryPart)this.wrappedList.remove(index));
    }

    @Override
    public final int indexOf(Object o) {
        return this.wrappedList.indexOf(o);
    }

    @Override
    public final int lastIndexOf(Object o) {
        return this.wrappedList.lastIndexOf(o);
    }

    @Override
    public final ListIterator<T> listIterator() {
        return this.wrappedList.listIterator();
    }

    @Override
    public final ListIterator<T> listIterator(int index) {
        return this.wrappedList.listIterator(index);
    }

    @Override
    public final List<T> subList(int fromIndex, int toIndex) {
        return this.wrappedList.subList(fromIndex, toIndex);
    }
}

