/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Clause;
import org.jooq.Comparator;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.QuantifiedSelect;
import org.jooq.QueryPartInternal;
import org.jooq.RenderContext;
import org.jooq.Row;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.TableLike;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.DSL;
import org.jooq.impl.RowCondition;

final class RowSubqueryCondition
extends AbstractCondition {
    private static final long serialVersionUID = -1806139685201770706L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.CONDITION, Clause.CONDITION_COMPARISON};
    private static final Set<SQLDialect> SUPPORT_NATIVE = SQLDialect.supportedBy(SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE);
    private final Row left;
    private final Select<?> right;
    private final QuantifiedSelect<?> rightQuantified;
    private final Comparator comparator;

    RowSubqueryCondition(Row left, Select<?> right, Comparator comparator) {
        this.left = left;
        this.right = right;
        this.rightQuantified = null;
        this.comparator = comparator;
    }

    RowSubqueryCondition(Row left, QuantifiedSelect<?> right, Comparator comparator) {
        this.left = left;
        this.right = null;
        this.rightQuantified = right;
        this.comparator = comparator;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.delegate(ctx));
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    private final QueryPartInternal delegate(Context<?> ctx) {
        RowCondition condition;
        Configuration configuration = ctx.configuration();
        RenderContext render = ctx instanceof RenderContext ? (RenderContext)ctx : null;
        SQLDialect family = configuration.family();
        if (this.rightQuantified != null) {
            return new Native();
        }
        if (SUPPORT_NATIVE.contains((Object)family)) {
            return new Native();
        }
        String table = render == null ? "t" : render.nextAlias();
        String[] names = new String[this.left.size()];
        for (int i = 0; i < this.left.size(); ++i) {
            names[i] = table + "_" + i;
        }
        Field[] fields = new Field[names.length];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = DSL.field(DSL.name(table, names[i]));
        }
        switch (this.comparator) {
            case GREATER: 
            case GREATER_OR_EQUAL: 
            case LESS: 
            case LESS_OR_EQUAL: {
                condition = new RowCondition(this.left, DSL.row(fields), this.comparator);
                break;
            }
            default: {
                condition = new RowCondition(this.left, DSL.row(fields), Comparator.EQUALS);
            }
        }
        SelectConditionStep subselect = DSL.select(new SelectFieldOrAsterisk[0]).from((TableLike<?>)this.right.asTable(table, names)).where((Condition)condition);
        switch (this.comparator) {
            case NOT_IN: 
            case NOT_EQUALS: {
                return (QueryPartInternal)((Object)DSL.notExists(subselect));
            }
        }
        return (QueryPartInternal)((Object)DSL.exists(subselect));
    }

    private class Native
    extends AbstractCondition {
        private static final long serialVersionUID = -1552476981094856727L;

        private Native() {
        }

        @Override
        public final void accept(Context<?> ctx) {
            ctx.visit(RowSubqueryCondition.this.left).sql(' ').visit(RowSubqueryCondition.this.comparator.toKeyword()).sql(' ');
            if (RowSubqueryCondition.this.rightQuantified == null) {
                boolean extraParentheses = false;
                ctx.sql(extraParentheses ? "((" : "(");
                ctx.subquery(true).formatIndentStart().formatNewLine().visit(RowSubqueryCondition.this.right).formatIndentEnd().formatNewLine().subquery(false);
                ctx.sql(extraParentheses ? "))" : ")");
            } else {
                ctx.subquery(true).visit(RowSubqueryCondition.this.rightQuantified).subquery(false);
            }
        }

        @Override
        public final Clause[] clauses(Context<?> ctx) {
            return CLAUSES;
        }
    }
}

