/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class IsNull
extends AbstractCondition {
    private static final long serialVersionUID = -747240442279619486L;
    private static final Clause[] CLAUSES_NULL = new Clause[]{Clause.CONDITION, Clause.CONDITION_IS_NULL};
    private static final Clause[] CLAUSES_NULL_NOT = new Clause[]{Clause.CONDITION, Clause.CONDITION_IS_NOT_NULL};
    private final Field<?> field;
    private final boolean isNull;

    IsNull(Field<?> field, boolean isNull) {
        this.field = field;
        this.isNull = isNull;
    }

    @Override
    final boolean isNullable() {
        return false;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.field.getDataType().isEmbeddable()) {
            if (this.isNull) {
                ctx.visit(DSL.row(Tools.embeddedFields(this.field)).isNull());
            } else {
                ctx.visit(DSL.row(Tools.embeddedFields(this.field)).isNotNull());
            }
        } else {
            ctx.visit(this.field).sql(' ').visit(this.isNull ? Keywords.K_IS_NULL : Keywords.K_IS_NOT_NULL);
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return this.isNull ? CLAUSES_NULL : CLAUSES_NULL_NOT;
    }
}

