/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.JSON;
import org.jooq.JSONEntry;
import org.jooq.JSONObjectAggNullStep;
import org.jooq.JSONObjectNullStep;
import org.jooq.impl.AbstractAggregateFunction;
import org.jooq.impl.CustomQueryPart;
import org.jooq.impl.DSL;
import org.jooq.impl.JSONNull;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;

final class JSONObjectAgg<J>
extends AbstractAggregateFunction<J>
implements JSONObjectAggNullStep<J> {
    private static final long serialVersionUID = 1772007627336725780L;
    private final JSONEntry<?> entry;
    private JSONNull.JSONNullType nullType;

    JSONObjectAgg(DataType<J> type, JSONEntry<?> entry) {
        super(false, Names.N_JSON_OBJECTAGG, type, entry.key(), entry.value());
        this.entry = entry;
    }

    @Override
    public void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: {
                this.acceptPostgres(ctx);
                break;
            }
            case MARIADB: 
            case MYSQL: {
                if (this.nullType == JSONNull.JSONNullType.ABSENT_ON_NULL) {
                    this.acceptGroupConcat(ctx);
                    break;
                }
                this.acceptStandard(ctx);
                break;
            }
            default: {
                this.acceptStandard(ctx);
            }
        }
    }

    private final void acceptPostgres(Context<?> ctx) {
        ctx.visit(this.getDataType() == SQLDataType.JSON ? Names.N_JSON_OBJECT_AGG : Names.N_JSONB_OBJECT_AGG).sql('(');
        ctx.visit(this.entry);
        ctx.sql(')');
        if (this.nullType == JSONNull.JSONNullType.ABSENT_ON_NULL) {
            JSONObjectAgg.acceptFilterClause(ctx, this.entry.value().isNotNull());
        }
        this.acceptOverClause(ctx);
    }

    private final void acceptGroupConcat(Context<?> ctx) {
        Field<Object> value;
        if (this.entry.value().getDataType().isJSON()) {
            value = this.entry.value();
        } else {
            JSONObjectNullStep<JSON> x = DSL.jsonObject(DSL.inline("x"), this.entry.value());
            switch (ctx.family()) {
                default: 
            }
            value = DSL.jsonValue(x, DSL.inline("$.x"));
            if (this.nullType == JSONNull.JSONNullType.ABSENT_ON_NULL) {
                value = DSL.when(this.entry.value().isNull(), DSL.inline((String)null)).else_(value);
            }
        }
        final Field<?> value1 = value;
        Field<String> listagg = DSL.field("{0}", String.class, new CustomQueryPart(){

            @Override
            public void accept(Context<?> c) {
                c.visit(DSL.groupConcat(DSL.concat(DSL.inline('\"'), DSL.replace(JSONObjectAgg.this.entry.key(), DSL.inline('\"'), DSL.inline("\\\"")), DSL.inline("\":"), JSONObjectAgg.this.nullType == JSONNull.JSONNullType.ABSENT_ON_NULL ? value1 : DSL.coalesce(value1, new Field[]{DSL.inline("null")}))));
                JSONObjectAgg.this.acceptOverClause(c);
            }
        });
        ctx.sql('(').visit(DSL.concat(DSL.inline('{'), listagg, DSL.inline('}'))).sql(')');
    }

    private final void acceptStandard(Context<?> ctx) {
        ctx.visit(Names.N_JSON_OBJECTAGG).sql('(').visit(this.entry);
        JSONNull jsonNull = new JSONNull(this.nullType);
        if (jsonNull.rendersContent(ctx)) {
            ctx.sql(' ').visit(jsonNull);
        }
        ctx.sql(')');
        this.acceptOverClause(ctx);
    }

    @Override
    public final JSONObjectAgg<J> nullOnNull() {
        this.nullType = JSONNull.JSONNullType.NULL_ON_NULL;
        return this;
    }

    @Override
    public final JSONObjectAgg<J> absentOnNull() {
        this.nullType = JSONNull.JSONNullType.ABSENT_ON_NULL;
        return this;
    }
}

