/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.tools.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jooq.tools.jdbc.BatchedPreparedStatement;
import org.jooq.tools.jdbc.DefaultConnection;
import org.jooq.tools.jdbc.JDBCUtils;

public class BatchedConnection
extends DefaultConnection {
    final int batchSize;
    String lastSQL;
    BatchedPreparedStatement lastStatement;
    static final Pattern P_DML = Pattern.compile("\\s*(?i:delete|insert|merge|update).*");

    public BatchedConnection(Connection delegate) {
        this(delegate, Integer.MAX_VALUE);
    }

    public BatchedConnection(Connection delegate, int batchSize) {
        super(delegate);
        this.batchSize = batchSize;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)(BatchedConnection.class == iface ? this : super.unwrap(iface));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return BatchedConnection.class == iface || super.isWrapperFor(iface);
    }

    void executeLastBatch(String sql) throws SQLException {
        if (!sql.equals(this.lastSQL)) {
            this.executeLastBatch();
        }
    }

    void executeLastBatch() throws SQLException {
        if (this.lastStatement != null) {
            if (this.lastStatement.batches > 0) {
                this.lastStatement.executeBatch();
            }
            JDBCUtils.safeClose(this.lastStatement);
        }
        this.clearLastBatch();
    }

    void clearLastBatch() {
        this.lastStatement = null;
        this.lastSQL = null;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.executeLastBatch();
        return super.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.executeLastBatch();
        return super.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.executeLastBatch();
        return super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.executeLastBatch();
        return super.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.executeLastBatch();
        return super.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.executeLastBatch();
        return super.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.executeLastBatch();
        return super.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.executeLastBatch();
        return super.prepareStatement(sql, columnNames);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.executeLastBatch();
        return super.prepareCall(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.executeLastBatch();
        return super.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.executeLastBatch();
        return super.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.executeLastBatch(sql);
        return this.lastStatement != null ? this.lastStatement : this.prepareStatement0(sql);
    }

    private PreparedStatement prepareStatement0(String sql) throws SQLException {
        PreparedStatement result = super.prepareStatement(sql);
        if (P_DML.matcher(sql).matches()) {
            this.lastSQL = sql;
            this.lastStatement = new BatchedPreparedStatement(this, result);
            return this.lastStatement;
        }
        return result;
    }

    @Override
    public void commit() throws SQLException {
        this.executeLastBatch();
        super.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.executeLastBatch();
        super.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.executeLastBatch();
        super.rollback(savepoint);
    }

    @Override
    public void close() throws SQLException {
        this.executeLastBatch();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.executeLastBatch();
        return super.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.executeLastBatch();
        return super.setSavepoint(name);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.executeLastBatch();
        super.releaseSavepoint(savepoint);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.executeLastBatch();
        super.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.executeLastBatch();
        return super.getAutoCommit();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.executeLastBatch();
        super.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.executeLastBatch();
        return super.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.executeLastBatch();
        super.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        this.executeLastBatch();
        return super.getCatalog();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.executeLastBatch();
        return super.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.executeLastBatch();
        super.clearWarnings();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.executeLastBatch();
        super.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.executeLastBatch();
        return super.getTransactionIsolation();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.executeLastBatch();
        super.setTypeMap(map);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.executeLastBatch();
        return super.getTypeMap();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.executeLastBatch();
        super.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.executeLastBatch();
        return super.getHoldability();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.executeLastBatch();
        return super.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.executeLastBatch();
        }
        catch (SQLException e) {
            throw new SQLClientInfoException(Collections.emptyMap(), (Throwable)e);
        }
        super.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.executeLastBatch();
        }
        catch (SQLException e) {
            throw new SQLClientInfoException(Collections.emptyMap(), (Throwable)e);
        }
        super.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.executeLastBatch();
        return super.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.executeLastBatch();
        return super.getClientInfo();
    }
}

