/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jooq.Catalog;
import org.jooq.Configuration;
import org.jooq.Meta;
import org.jooq.QueryPart;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.impl.AbstractMeta;
import org.jooq.impl.CatalogImpl;
import org.jooq.impl.SchemaImpl;
import org.jooq.impl.Tools;

final class CatalogMetaImpl
extends AbstractMeta {
    private static final long serialVersionUID = 7582210274970452691L;
    private final Catalog[] catalogs;

    private CatalogMetaImpl(Configuration configuration, Catalog[] catalogs) {
        super(configuration);
        this.catalogs = catalogs;
    }

    @Override
    final List<Catalog> getCatalogs0() {
        return Arrays.asList(this.catalogs);
    }

    static final Meta filterCatalogs(Configuration configuration, Catalog[] catalogs) {
        return CatalogMetaImpl.filterCatalogs0(configuration, catalogs, new HashSet<Catalog>(Arrays.asList(catalogs)));
    }

    static final Meta filterCatalogs(Configuration configuration, Set<Catalog> catalogs) {
        return CatalogMetaImpl.filterCatalogs0(configuration, catalogs.toArray(Tools.EMPTY_CATALOG), catalogs);
    }

    private static final Meta filterCatalogs0(Configuration configuration, Catalog[] array, final Set<Catalog> set) {
        return new CatalogMetaImpl(configuration, array).filterCatalogs((Meta.Predicate<? super Catalog>)new Meta.Predicate<Catalog>(){

            @Override
            public boolean test(Catalog catalog) {
                return set.contains(catalog);
            }
        });
    }

    static final Meta filterSchemas(Configuration configuration, Schema[] schemas) {
        return CatalogMetaImpl.filterSchemas(configuration, new HashSet<Schema>(Arrays.asList(schemas)));
    }

    static final Meta filterSchemas(Configuration configuration, final Set<Schema> schemas) {
        CatalogImpl defaultCatalog = new CatalogImpl(""){

            @Override
            public List<Schema> getSchemas() {
                return new ArrayList<Schema>(schemas);
            }
        };
        HashSet<Catalog> c = new HashSet<Catalog>();
        for (Schema schema : schemas) {
            c.add(schema.getCatalog() != null ? schema.getCatalog() : defaultCatalog);
        }
        return CatalogMetaImpl.filterCatalogs(configuration, c).filterSchemas((Meta.Predicate<? super Schema>)new Meta.Predicate<Schema>(){

            @Override
            public boolean test(Schema schema) {
                return schemas.contains(schema);
            }
        });
    }

    static final Meta filterTables(Configuration configuration, Table<?>[] tables) {
        return CatalogMetaImpl.filterTables(configuration, new HashSet(Arrays.asList(tables)));
    }

    static final Meta filterTables(Configuration configuration, final Set<Table<?>> tables) {
        SchemaImpl defaultSchema = new SchemaImpl(""){

            @Override
            public List<Table<?>> getTables() {
                return new ArrayList(tables);
            }
        };
        HashSet<Schema> s = new HashSet<Schema>();
        for (Table<?> table : tables) {
            s.add(table.getSchema() != null ? table.getSchema() : defaultSchema);
        }
        return CatalogMetaImpl.filterSchemas(configuration, s).filterTables(new Meta.Predicate<Table<?>>(){

            @Override
            public boolean test(Table<?> table) {
                return tables.contains(table);
            }
        }).filterSequences(CatalogMetaImpl.none()).filterDomains(CatalogMetaImpl.none());
    }

    static final <Q extends QueryPart> Meta.Predicate<Q> none() {
        return new Meta.Predicate<Q>(){

            @Override
            public boolean test(Q t) {
                return false;
            }
        };
    }
}

