/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jetbrains.annotations.NotNull;
import org.jooq.Binding;
import org.jooq.Check;
import org.jooq.Converter;
import org.jooq.DataType;
import org.jooq.Domain;
import org.jooq.EmbeddableRecord;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Identity;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Parameter;
import org.jooq.Record;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.Support;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UniqueKey;
import org.jooq.impl.CheckImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultBinding;
import org.jooq.impl.DomainImpl;
import org.jooq.impl.EmbeddableTableField;
import org.jooq.impl.Expression;
import org.jooq.impl.ExpressionOperator;
import org.jooq.impl.IdentityImpl;
import org.jooq.impl.IndexImpl;
import org.jooq.impl.Neg;
import org.jooq.impl.ParameterImpl;
import org.jooq.impl.ReferenceImpl;
import org.jooq.impl.SequenceImpl;
import org.jooq.impl.TableImpl;
import org.jooq.impl.Tools;
import org.jooq.impl.UniqueKeyImpl;

@org.jooq.Internal
public final class Internal {
    @SafeVarargs
    @NotNull
    public static final <R extends Record, E extends EmbeddableRecord<E>> TableField<R, E> createEmbeddable(Name name, Class<E> recordType, Table<R> table, TableField<R, ?> ... fields) {
        return Internal.createEmbeddable(name, recordType, false, table, fields);
    }

    @SafeVarargs
    @NotNull
    public static final <R extends Record, E extends EmbeddableRecord<E>> TableField<R, E> createEmbeddable(Name name, Class<E> recordType, boolean replacesFields, Table<R> table, TableField<R, ?> ... fields) {
        return new EmbeddableTableField<R, E>(name, recordType, replacesFields, table, fields);
    }

    @NotNull
    public static final Index createIndex(Name name, Table<?> table, OrderField<?>[] sortFields, boolean unique) {
        return new IndexImpl(name, table, sortFields, null, unique);
    }

    @NotNull
    public static final <R extends Record, T> Identity<R, T> createIdentity(Table<R> table, TableField<R, T> field) {
        return new IdentityImpl<R, T>(table, field);
    }

    @SafeVarargs
    @NotNull
    public static final <R extends Record> UniqueKey<R> createUniqueKey(Table<R> table, TableField<R, ?> ... fields) {
        return Internal.createUniqueKey(table, (Name)null, fields, true);
    }

    @SafeVarargs
    @NotNull
    public static final <R extends Record> UniqueKey<R> createUniqueKey(Table<R> table, Name name, TableField<R, ?> ... fields) {
        return Internal.createUniqueKey(table, name, fields, true);
    }

    @NotNull
    public static final <R extends Record> UniqueKey<R> createUniqueKey(Table<R> table, Name name, TableField<R, ?>[] fields, boolean enforced) {
        return new UniqueKeyImpl<R>(table, name, fields, enforced);
    }

    @NotNull
    public static final <R extends Record, ER extends EmbeddableRecord<ER>> UniqueKey<R> createUniqueKey(Table<R> table, Name name, TableField<R, ER> embeddableField, boolean enforced) {
        return Internal.createUniqueKey(table, name, Internal.fields(embeddableField), enforced);
    }

    @Deprecated
    @SafeVarargs
    @NotNull
    public static final <R extends Record, U extends Record> ForeignKey<R, U> createForeignKey(UniqueKey<U> key, Table<R> table, TableField<R, ?> ... fields) {
        return Internal.createForeignKey(table, (Name)null, fields, key, key.getFieldsArray(), true);
    }

    @NotNull
    public static final <R extends Record, U extends Record> ForeignKey<R, U> createForeignKey(Table<R> table, Name name, TableField<R, ?>[] fkFields, UniqueKey<U> uk, TableField<U, ?>[] ukFields, boolean enforced) {
        ReferenceImpl<R, Object> result = new ReferenceImpl<R, Object>(table, name, fkFields, uk, ukFields == null ? uk.getFieldsArray() : ukFields, enforced);
        if (uk instanceof UniqueKeyImpl) {
            ((UniqueKeyImpl)uk).references.add(result);
        }
        return result;
    }

    @NotNull
    public static final <R extends Record, U extends Record, ER extends EmbeddableRecord<ER>> ForeignKey<R, U> createForeignKey(Table<R> table, Name name, TableField<R, ER> fkEmbeddableField, UniqueKey<U> uk, TableField<U, ER> ukEmbeddableField, boolean enforced) {
        return Internal.createForeignKey(table, name, Internal.fields(fkEmbeddableField), uk, Internal.fields(ukEmbeddableField), enforced);
    }

    @NotNull
    public static final <T extends Number> Sequence<T> createSequence(String name, Schema schema, DataType<T> type) {
        return new SequenceImpl<T>(name, schema, type, false);
    }

    @NotNull
    public static final <T extends Number> Sequence<T> createSequence(String name, Schema schema, DataType<T> type, Number startWith, Number incrementBy, Number minvalue, Number maxvalue, boolean cycle, Number cache) {
        return new SequenceImpl<T>(DSL.name(name), schema, type, false, startWith != null ? Tools.field((Object)startWith, type) : null, incrementBy != null ? Tools.field((Object)incrementBy, type) : null, minvalue != null ? Tools.field((Object)minvalue, type) : null, maxvalue != null ? Tools.field((Object)maxvalue, type) : null, cycle, cache != null ? Tools.field((Object)cache, type) : null);
    }

    @NotNull
    public static final <R extends Record> Check<R> createCheck(Table<R> table, Name name, String condition) {
        return Internal.createCheck(table, name, condition, true);
    }

    @NotNull
    public static final <R extends Record> Check<R> createCheck(Table<R> table, Name name, String condition, boolean enforced) {
        return new CheckImpl<R>(table, name, DSL.condition(condition), enforced);
    }

    @NotNull
    public static final <T> Domain<T> createDomain(Schema schema, Name name, DataType<T> type, Check<?> ... checks) {
        return new DomainImpl<T>(schema, name, type, checks);
    }

    @NotNull
    public static final Name createPathAlias(Table<?> child, ForeignKey<?, ?> path) {
        Name name = DSL.name(path.getName());
        if (child instanceof TableImpl) {
            Table<?> ancestor = ((TableImpl)child).child;
            name = ancestor != null ? Internal.createPathAlias(ancestor, ((TableImpl)child).childPath).append(name) : child.getQualifiedName().append(name);
        }
        return DSL.name("alias_" + Tools.hash(name));
    }

    @NotNull
    public static final <T> Parameter<T> createParameter(String name, DataType<T> type, boolean isDefaulted, boolean isUnnamed) {
        return Internal.createParameter(name, type, isDefaulted, isUnnamed, null, null);
    }

    @NotNull
    public static final <T, U> Parameter<U> createParameter(String name, DataType<T> type, boolean isDefaulted, boolean isUnnamed, Converter<T, U> converter) {
        return Internal.createParameter(name, type, isDefaulted, isUnnamed, converter, null);
    }

    @NotNull
    public static final <T, U> Parameter<U> createParameter(String name, DataType<T> type, boolean isDefaulted, boolean isUnnamed, Binding<T, U> binding) {
        return Internal.createParameter(name, type, isDefaulted, isUnnamed, null, binding);
    }

    @NotNull
    public static final <T, X, U> Parameter<U> createParameter(String name, DataType<T> type, boolean isDefaulted, boolean isUnnamed, Converter<X, U> converter, Binding<T, X> binding) {
        Binding<T, U> actualBinding = DefaultBinding.newBinding(converter, type, binding);
        DataType<Object> actualType = converter == null && binding == null ? type : type.asConvertedDataType(actualBinding);
        return new ParameterImpl<T>(name, actualType, actualBinding, isDefaulted, isUnnamed);
    }

    private Internal() {
    }

    @Deprecated
    @NotNull
    public static final Index createIndex(String name, Table<?> table, OrderField<?>[] sortFields, boolean unique) {
        return Internal.createIndex(DSL.name(name), table, sortFields, unique);
    }

    @Deprecated
    @SafeVarargs
    @NotNull
    public static final <R extends Record> UniqueKey<R> createUniqueKey(Table<R> table, String name, TableField<R, ?> ... fields) {
        return Internal.createUniqueKey(table, name, fields, true);
    }

    @Deprecated
    @NotNull
    public static final <R extends Record> UniqueKey<R> createUniqueKey(Table<R> table, String name, TableField<R, ?>[] fields, boolean enforced) {
        return Internal.createUniqueKey(table, DSL.name(name), fields, enforced);
    }

    @Deprecated
    @SafeVarargs
    @NotNull
    public static final <R extends Record, U extends Record> ForeignKey<R, U> createForeignKey(UniqueKey<U> key, Table<R> table, String name, TableField<R, ?> ... fields) {
        return Internal.createForeignKey(key, table, name, fields, true);
    }

    @Deprecated
    @NotNull
    public static final <R extends Record, U extends Record> ForeignKey<R, U> createForeignKey(UniqueKey<U> key, Table<R> table, String name, TableField<R, ?>[] fields, boolean enforced) {
        return Internal.createForeignKey(table, DSL.name(name), fields, key, key.getFieldsArray(), enforced);
    }

    @NotNull
    public static final <R extends Record, ER extends EmbeddableRecord<ER>> TableField<R, ?>[] fields(TableField<R, ER> embeddableField) {
        return ((EmbeddableTableField)embeddableField).fields;
    }

    @Support
    static final <T> Field<T> ineg(Field<T> field) {
        return new Neg<T>(field, true, ExpressionOperator.SUBTRACT);
    }

    @Support
    static final <T> Field<T> iadd(Field<T> lhs, Field<?> rhs) {
        return new Expression<T>(ExpressionOperator.ADD, true, lhs, DSL.nullSafe(rhs, lhs.getDataType()));
    }

    @Support
    static final <T> Field<T> isub(Field<T> lhs, Field<?> rhs) {
        return new Expression<T>(ExpressionOperator.SUBTRACT, true, lhs, DSL.nullSafe(rhs, lhs.getDataType()));
    }

    @Support
    static final <T> Field<T> imul(Field<T> lhs, Field<?> rhs) {
        return new Expression<T>(ExpressionOperator.MULTIPLY, true, lhs, DSL.nullSafe(rhs, lhs.getDataType()));
    }

    @Support
    static final <T> Field<T> idiv(Field<T> lhs, Field<?> rhs) {
        return new Expression<T>(ExpressionOperator.DIVIDE, true, lhs, DSL.nullSafe(rhs, lhs.getDataType()));
    }
}

