/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.List;
import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Row;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UniqueKey;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.Alias;
import org.jooq.impl.Fields;
import org.jooq.impl.TableFieldImpl;

final class TableAlias<R extends Record>
extends AbstractTable<R> {
    private static final long serialVersionUID = -8417114874567698325L;
    final Alias<Table<R>> alias;
    final Fields<R> aliasedFields;

    TableAlias(Table<R> table, Name alias) {
        this(table, alias, null, false);
    }

    TableAlias(Table<R> table, Name alias, boolean wrapInParentheses) {
        this(table, alias, null, wrapInParentheses);
    }

    TableAlias(Table<R> table, Name alias, Name[] fieldAliases) {
        this(table, alias, fieldAliases, false);
    }

    TableAlias(Table<R> table, Name alias, Name[] fieldAliases, boolean wrapInParentheses) {
        super(table.getOptions(), alias, table.getSchema());
        this.alias = new Alias<TableAlias>((TableAlias)table, this, alias, fieldAliases, wrapInParentheses);
        this.aliasedFields = this.init(fieldAliases);
    }

    private final Fields<R> init(Name[] fieldAliases) {
        Row row = this.alias.wrapped().fieldsRow();
        int size = row.size();
        ArrayList result = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            Field<?> field = row.field(i);
            Name name = fieldAliases != null && fieldAliases.length > i ? fieldAliases[i] : field.getUnqualifiedName();
            result.add(new TableFieldImpl(name, field.getDataType(), this, field.getCommentPart(), field.getBinding()));
        }
        return new Fields(result);
    }

    Table<R> getAliasedTable() {
        if (this.alias != null) {
            return this.alias.wrapped();
        }
        return null;
    }

    @Override
    public final UniqueKey<R> getPrimaryKey() {
        return this.alias.wrapped().getPrimaryKey();
    }

    @Override
    public final List<UniqueKey<R>> getKeys() {
        return this.alias.wrapped().getKeys();
    }

    @Override
    public final List<ForeignKey<R, ?>> getReferences() {
        return this.alias.wrapped().getReferences();
    }

    @Override
    public final TableField<R, ?> getRecordVersion() {
        return this.alias.wrapped().getRecordVersion();
    }

    @Override
    public final TableField<R, ?> getRecordTimestamp() {
        return this.alias.wrapped().getRecordTimestamp();
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.alias);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    @Override
    public final Table<R> as(Name as) {
        return this.alias.wrapped().as(as);
    }

    @Override
    public final Table<R> as(Name as, Name ... fieldAliases) {
        return this.alias.wrapped().as(as, fieldAliases);
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }

    @Override
    final Fields<R> fields0() {
        return this.aliasedFields;
    }

    @Override
    public Class<? extends R> getRecordType() {
        return this.alias.wrapped().getRecordType();
    }
}

