/*
 * Decompiled with CFR 0.152.
 */
package org.jooq;

import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Check;
import org.jooq.Condition;
import org.jooq.DataType;
import org.jooq.DivideByOnStep;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Identity;
import org.jooq.Index;
import org.jooq.JoinType;
import org.jooq.Name;
import org.jooq.PlainSQL;
import org.jooq.Qualified;
import org.jooq.QualifiedAsterisk;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.RecordType;
import org.jooq.RowId;
import org.jooq.SQL;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.Support;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOnStep;
import org.jooq.TableOptionalOnStep;
import org.jooq.TableOptions;
import org.jooq.TablePartitionByStep;
import org.jooq.UniqueKey;

public interface Table<R extends Record>
extends TableLike<R>,
Qualified {
    @NotNull
    public TableOptions.TableType getType();

    @NotNull
    public TableOptions getOptions();

    @NotNull
    public RecordType<R> recordType();

    @NotNull
    public Class<? extends R> getRecordType();

    @NotNull
    public DataType<R> getDataType();

    @NotNull
    public R newRecord();

    @Nullable
    public Identity<R, ?> getIdentity();

    @Nullable
    public UniqueKey<R> getPrimaryKey();

    @Nullable
    public TableField<R, ?> getRecordVersion();

    @Nullable
    public TableField<R, ?> getRecordTimestamp();

    @NotNull
    public List<Index> getIndexes();

    @NotNull
    public List<UniqueKey<R>> getKeys();

    @NotNull
    public <O extends Record> List<ForeignKey<O, R>> getReferencesFrom(Table<O> var1);

    @NotNull
    public List<ForeignKey<R, ?>> getReferences();

    @NotNull
    public <O extends Record> List<ForeignKey<R, O>> getReferencesTo(Table<O> var1);

    @NotNull
    public List<Check<R>> getChecks();

    @Support
    @NotNull
    public QualifiedAsterisk asterisk();

    @Support(value={SQLDialect.H2, SQLDialect.POSTGRES, SQLDialect.SQLITE})
    @NotNull
    public Field<RowId> rowid();

    @Support
    @NotNull
    public Table<R> as(String var1);

    @Support
    @NotNull
    public Table<R> as(String var1, String ... var2);

    @Deprecated
    @Support
    @NotNull
    public Table<R> as(String var1, Function<? super Field<?>, ? extends String> var2);

    @Deprecated
    @Support
    @NotNull
    public Table<R> as(String var1, BiFunction<? super Field<?>, ? super Integer, ? extends String> var2);

    @Support
    @NotNull
    public Table<R> as(Name var1);

    @Support
    @NotNull
    public Table<R> as(Name var1, Name ... var2);

    @Deprecated
    @Support
    @NotNull
    public Table<R> as(Name var1, Function<? super Field<?>, ? extends Name> var2);

    @Deprecated
    @Support
    @NotNull
    public Table<R> as(Name var1, BiFunction<? super Field<?>, ? super Integer, ? extends Name> var2);

    @Support
    @NotNull
    public Table<R> as(Table<?> var1);

    @Support
    @NotNull
    public Table<R> as(Table<?> var1, Field<?> ... var2);

    @Deprecated
    @Support
    @NotNull
    public Table<R> as(Table<?> var1, Function<? super Field<?>, ? extends Field<?>> var2);

    @Deprecated
    @Support
    @NotNull
    public Table<R> as(Table<?> var1, BiFunction<? super Field<?>, ? super Integer, ? extends Field<?>> var2);

    @Support
    @NotNull
    public Table<R> where(Condition var1);

    @Support
    @NotNull
    public Table<R> where(Condition ... var1);

    @Support
    @NotNull
    public Table<R> where(Collection<? extends Condition> var1);

    @Support
    @NotNull
    public Table<R> where(Field<Boolean> var1);

    @Support
    @PlainSQL
    @NotNull
    public Table<R> where(SQL var1);

    @Support
    @PlainSQL
    @NotNull
    public Table<R> where(String var1);

    @Support
    @PlainSQL
    @NotNull
    public Table<R> where(String var1, Object ... var2);

    @Support
    @PlainSQL
    @NotNull
    public Table<R> where(String var1, QueryPart ... var2);

    @Support
    @NotNull
    public Table<R> whereExists(Select<?> var1);

    @Support
    @NotNull
    public Table<R> whereNotExists(Select<?> var1);

    @Support
    @NotNull
    public TableOptionalOnStep<Record> join(TableLike<?> var1, JoinType var2);

    @Support
    @NotNull
    public TableOnStep<Record> join(TableLike<?> var1);

    @Support
    @PlainSQL
    @NotNull
    public TableOnStep<Record> join(SQL var1);

    @Support
    @PlainSQL
    @NotNull
    public TableOnStep<Record> join(String var1);

    @Support
    @PlainSQL
    @NotNull
    public TableOnStep<Record> join(String var1, Object ... var2);

    @Support
    @PlainSQL
    @NotNull
    public TableOnStep<Record> join(String var1, QueryPart ... var2);

    @Support
    @PlainSQL
    @NotNull
    public TableOnStep<Record> join(Name var1);

    @Support
    @NotNull
    public TableOnStep<Record> innerJoin(TableLike<?> var1);

    @Support
    @PlainSQL
    @NotNull
    public TableOnStep<Record> innerJoin(SQL var1);

    @Support
    @PlainSQL
    @NotNull
    public TableOnStep<Record> innerJoin(String var1);

    @Support
    @PlainSQL
    @NotNull
    public TableOnStep<Record> innerJoin(String var1, Object ... var2);

    @Support
    @PlainSQL
    @NotNull
    public TableOnStep<Record> innerJoin(String var1, QueryPart ... var2);

    @Support
    @NotNull
    public TableOnStep<Record> innerJoin(Name var1);

    @Support
    @NotNull
    public TablePartitionByStep<Record> leftJoin(TableLike<?> var1);

    @Support
    @PlainSQL
    @NotNull
    public TablePartitionByStep<Record> leftJoin(SQL var1);

    @Support
    @PlainSQL
    @NotNull
    public TablePartitionByStep<Record> leftJoin(String var1);

    @Support
    @PlainSQL
    @NotNull
    public TablePartitionByStep<Record> leftJoin(String var1, Object ... var2);

    @Support
    @PlainSQL
    @NotNull
    public TablePartitionByStep<Record> leftJoin(String var1, QueryPart ... var2);

    @Support
    @NotNull
    public TablePartitionByStep<Record> leftJoin(Name var1);

    @Support
    @NotNull
    public TablePartitionByStep<Record> leftOuterJoin(TableLike<?> var1);

    @Support
    @PlainSQL
    @NotNull
    public TablePartitionByStep<Record> leftOuterJoin(SQL var1);

    @Support
    @PlainSQL
    @NotNull
    public TablePartitionByStep<Record> leftOuterJoin(String var1);

    @Support
    @PlainSQL
    @NotNull
    public TablePartitionByStep<Record> leftOuterJoin(String var1, Object ... var2);

    @Support
    @PlainSQL
    @NotNull
    public TablePartitionByStep<Record> leftOuterJoin(String var1, QueryPart ... var2);

    @Support
    @NotNull
    public TablePartitionByStep<Record> leftOuterJoin(Name var1);

    @Support(value={SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES})
    @NotNull
    public TablePartitionByStep<Record> rightJoin(TableLike<?> var1);

    @Support(value={SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public TablePartitionByStep<Record> rightJoin(SQL var1);

    @Support(value={SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public TablePartitionByStep<Record> rightJoin(String var1);

    @Support(value={SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public TablePartitionByStep<Record> rightJoin(String var1, Object ... var2);

    @Support(value={SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public TablePartitionByStep<Record> rightJoin(String var1, QueryPart ... var2);

    @Support(value={SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES})
    @NotNull
    public TablePartitionByStep<Record> rightJoin(Name var1);

    @Support(value={SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES})
    @NotNull
    public TablePartitionByStep<Record> rightOuterJoin(TableLike<?> var1);

    @Support(value={SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public TablePartitionByStep<Record> rightOuterJoin(SQL var1);

    @Support(value={SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public TablePartitionByStep<Record> rightOuterJoin(String var1);

    @Support(value={SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public TablePartitionByStep<Record> rightOuterJoin(String var1, Object ... var2);

    @Support(value={SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public TablePartitionByStep<Record> rightOuterJoin(String var1, QueryPart ... var2);

    @Support(value={SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES})
    @NotNull
    public TablePartitionByStep<Record> rightOuterJoin(Name var1);

    @Support(value={SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.POSTGRES})
    @NotNull
    public TableOnStep<Record> fullJoin(TableLike<?> var1);

    @Support(value={SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public TableOnStep<Record> fullJoin(SQL var1);

    @Support(value={SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public TableOnStep<Record> fullJoin(String var1);

    @Support(value={SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public TableOnStep<Record> fullJoin(String var1, Object ... var2);

    @Support(value={SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public TableOnStep<Record> fullJoin(String var1, QueryPart ... var2);

    @Support(value={SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.POSTGRES})
    @NotNull
    public TableOnStep<Record> fullJoin(Name var1);

    @Support(value={SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.POSTGRES})
    @NotNull
    public TableOnStep<Record> fullOuterJoin(TableLike<?> var1);

    @Support(value={SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public TableOnStep<Record> fullOuterJoin(SQL var1);

    @Support(value={SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public TableOnStep<Record> fullOuterJoin(String var1);

    @Support(value={SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public TableOnStep<Record> fullOuterJoin(String var1, Object ... var2);

    @Support(value={SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public TableOnStep<Record> fullOuterJoin(String var1, QueryPart ... var2);

    @Support(value={SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.POSTGRES})
    @NotNull
    public TableOnStep<Record> fullOuterJoin(Name var1);

    @Support
    @NotNull
    public Table<Record> crossJoin(TableLike<?> var1);

    @Support
    @PlainSQL
    @NotNull
    public Table<Record> crossJoin(SQL var1);

    @Support
    @PlainSQL
    @NotNull
    public Table<Record> crossJoin(String var1);

    @Support
    @PlainSQL
    @NotNull
    public Table<Record> crossJoin(String var1, Object ... var2);

    @Support
    @PlainSQL
    @NotNull
    public Table<Record> crossJoin(String var1, QueryPart ... var2);

    @Support
    @NotNull
    public Table<Record> crossJoin(Name var1);

    @Support
    @NotNull
    public Table<Record> naturalJoin(TableLike<?> var1);

    @Support
    @PlainSQL
    @NotNull
    public Table<Record> naturalJoin(SQL var1);

    @Support
    @PlainSQL
    @NotNull
    public Table<Record> naturalJoin(String var1);

    @Support
    @PlainSQL
    @NotNull
    public Table<Record> naturalJoin(String var1, Object ... var2);

    @Support
    @NotNull
    public Table<Record> naturalJoin(Name var1);

    @Support
    @PlainSQL
    @NotNull
    public Table<Record> naturalJoin(String var1, QueryPart ... var2);

    @Support
    @NotNull
    public Table<Record> naturalLeftOuterJoin(TableLike<?> var1);

    @Support
    @PlainSQL
    @NotNull
    public Table<Record> naturalLeftOuterJoin(SQL var1);

    @Support
    @PlainSQL
    @NotNull
    public Table<Record> naturalLeftOuterJoin(String var1);

    @Support
    @PlainSQL
    @NotNull
    public Table<Record> naturalLeftOuterJoin(String var1, Object ... var2);

    @Support
    @PlainSQL
    @NotNull
    public Table<Record> naturalLeftOuterJoin(String var1, QueryPart ... var2);

    @Support
    @PlainSQL
    @NotNull
    public Table<Record> naturalLeftOuterJoin(Name var1);

    @Support(value={SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES})
    @NotNull
    public Table<Record> naturalRightOuterJoin(TableLike<?> var1);

    @Support(value={SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public Table<Record> naturalRightOuterJoin(SQL var1);

    @Support(value={SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public Table<Record> naturalRightOuterJoin(String var1);

    @Support(value={SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public Table<Record> naturalRightOuterJoin(String var1, Object ... var2);

    @Support(value={SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public Table<Record> naturalRightOuterJoin(String var1, QueryPart ... var2);

    @Support(value={SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES})
    @NotNull
    public Table<Record> naturalRightOuterJoin(Name var1);

    @Support(value={SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.POSTGRES})
    @NotNull
    public Table<Record> naturalFullOuterJoin(TableLike<?> var1);

    @Support(value={SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public Table<Record> naturalFullOuterJoin(SQL var1);

    @Support(value={SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public Table<Record> naturalFullOuterJoin(String var1);

    @Support(value={SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public Table<Record> naturalFullOuterJoin(String var1, Object ... var2);

    @Support(value={SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public Table<Record> naturalFullOuterJoin(String var1, QueryPart ... var2);

    @Support(value={SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.POSTGRES})
    @NotNull
    public Table<Record> naturalFullOuterJoin(Name var1);

    @Support(value={SQLDialect.POSTGRES})
    @NotNull
    public Table<Record> crossApply(TableLike<?> var1);

    @Support(value={SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public Table<Record> crossApply(SQL var1);

    @Support(value={SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public Table<Record> crossApply(String var1);

    @Support(value={SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public Table<Record> crossApply(String var1, Object ... var2);

    @Support(value={SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public Table<Record> crossApply(String var1, QueryPart ... var2);

    @Support(value={SQLDialect.POSTGRES})
    @NotNull
    public Table<Record> crossApply(Name var1);

    @Support(value={SQLDialect.POSTGRES})
    @NotNull
    public Table<Record> outerApply(TableLike<?> var1);

    @Support(value={SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public Table<Record> outerApply(SQL var1);

    @Support(value={SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public Table<Record> outerApply(String var1);

    @Support(value={SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public Table<Record> outerApply(String var1, Object ... var2);

    @Support(value={SQLDialect.POSTGRES})
    @PlainSQL
    @NotNull
    public Table<Record> outerApply(String var1, QueryPart ... var2);

    @Support(value={SQLDialect.POSTGRES})
    @NotNull
    public Table<Record> outerApply(Name var1);

    @Support(value={SQLDialect.MARIADB, SQLDialect.MYSQL})
    @NotNull
    public TableOnStep<Record> straightJoin(TableLike<?> var1);

    @Support(value={SQLDialect.MARIADB, SQLDialect.MYSQL})
    @PlainSQL
    @NotNull
    public TableOnStep<Record> straightJoin(SQL var1);

    @Support(value={SQLDialect.MARIADB, SQLDialect.MYSQL})
    @PlainSQL
    @NotNull
    public TableOnStep<Record> straightJoin(String var1);

    @Support(value={SQLDialect.MARIADB, SQLDialect.MYSQL})
    @PlainSQL
    @NotNull
    public TableOnStep<Record> straightJoin(String var1, Object ... var2);

    @Support(value={SQLDialect.MARIADB, SQLDialect.MYSQL})
    @PlainSQL
    @NotNull
    public TableOnStep<Record> straightJoin(String var1, QueryPart ... var2);

    @Support(value={SQLDialect.MARIADB, SQLDialect.MYSQL})
    @PlainSQL
    @NotNull
    public TableOnStep<Record> straightJoin(Name var1);

    @Support
    @NotNull
    public Condition eq(Table<R> var1);

    @Support
    @NotNull
    public Condition equal(Table<R> var1);

    @Override
    public boolean equals(Object var1);

    @Support
    @NotNull
    public Condition ne(Table<R> var1);

    @Support
    @NotNull
    public Condition notEqual(Table<R> var1);

    @Support(value={SQLDialect.MARIADB, SQLDialect.MYSQL})
    @NotNull
    public Table<R> useIndex(String ... var1);

    @Support(value={SQLDialect.MARIADB, SQLDialect.MYSQL})
    @NotNull
    public Table<R> useIndexForJoin(String ... var1);

    @Support(value={SQLDialect.MARIADB, SQLDialect.MYSQL})
    @NotNull
    public Table<R> useIndexForOrderBy(String ... var1);

    @Support(value={SQLDialect.MARIADB, SQLDialect.MYSQL})
    @NotNull
    public Table<R> useIndexForGroupBy(String ... var1);

    @Support(value={SQLDialect.MARIADB, SQLDialect.MYSQL})
    @NotNull
    public Table<R> ignoreIndex(String ... var1);

    @Support(value={SQLDialect.MARIADB, SQLDialect.MYSQL})
    @NotNull
    public Table<R> ignoreIndexForJoin(String ... var1);

    @Support(value={SQLDialect.MARIADB, SQLDialect.MYSQL})
    @NotNull
    public Table<R> ignoreIndexForOrderBy(String ... var1);

    @Support(value={SQLDialect.MARIADB, SQLDialect.MYSQL})
    @NotNull
    public Table<R> ignoreIndexForGroupBy(String ... var1);

    @Support(value={SQLDialect.MARIADB, SQLDialect.MYSQL})
    @NotNull
    public Table<R> forceIndex(String ... var1);

    @Support(value={SQLDialect.MARIADB, SQLDialect.MYSQL})
    @NotNull
    public Table<R> forceIndexForJoin(String ... var1);

    @Support(value={SQLDialect.MARIADB, SQLDialect.MYSQL})
    @NotNull
    public Table<R> forceIndexForOrderBy(String ... var1);

    @Support(value={SQLDialect.MARIADB, SQLDialect.MYSQL})
    @NotNull
    public Table<R> forceIndexForGroupBy(String ... var1);

    @Support
    @NotNull
    public DivideByOnStep divideBy(Table<?> var1);

    @Support
    @NotNull
    public TableOnStep<R> leftSemiJoin(TableLike<?> var1);

    @Support
    @NotNull
    public TableOnStep<R> leftAntiJoin(TableLike<?> var1);

    @NotNull
    public R from(Record var1);
}

