/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jooq.AggregateFunction;
import org.jooq.ArrayAggOrderByStep;
import org.jooq.CaseConditionStep;
import org.jooq.Condition;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.OrderedAggregateFunction;
import org.jooq.Param;
import org.jooq.QueryPart;
import org.jooq.SQL;
import org.jooq.SQLDialect;
import org.jooq.WindowBeforeOverStep;
import org.jooq.impl.AbstractWindowFunction;
import org.jooq.impl.ConditionProviderImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.QueryPartCollectionView;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.SortFieldList;
import org.jooq.impl.Tools;

abstract class AbstractAggregateFunction<T>
extends AbstractWindowFunction<T>
implements AggregateFunction<T>,
OrderedAggregateFunction<T>,
ArrayAggOrderByStep<T> {
    private static final long serialVersionUID = -8613744948308064895L;
    private static final Set<SQLDialect> SUPPORT_FILTER = SQLDialect.supportedBy(SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.POSTGRES, SQLDialect.SQLITE);
    private static final Set<SQLDialect> SUPPORT_DISTINCT_RVE = SQLDialect.supportedBy(SQLDialect.H2, SQLDialect.POSTGRES);
    static final Field<Integer> ASTERISK = DSL.field("*", Integer.class);
    final QueryPartList<Field<?>> arguments;
    final boolean distinct;
    Condition filter;
    SortFieldList withinGroupOrderBy;
    SortFieldList keepDenseRankOrderBy;
    boolean first;

    AbstractAggregateFunction(boolean distinct, Name name, DataType<T> type, Field<?> ... arguments) {
        super(name, type);
        this.distinct = distinct;
        this.arguments = new QueryPartList((QueryPart[])arguments);
    }

    final void acceptArguments(Context<?> ctx) {
        ctx.visit(this.getQualifiedName());
        ctx.sql('(');
        this.acceptArguments0(ctx);
        ctx.sql(')');
    }

    final void acceptArguments0(Context<?> ctx) {
        this.acceptArguments1(ctx, this.arguments);
    }

    final void acceptArguments1(Context<?> ctx, QueryPartCollectionView<Field<?>> args) {
        if (this.distinct) {
            ctx.visit(Keywords.K_DISTINCT).sql(' ');
            if (args.size() > 1 && SUPPORT_DISTINCT_RVE.contains((Object)ctx.dialect())) {
                ctx.sql('(');
            }
        }
        if (!args.isEmpty()) {
            if (this.filter == null || SUPPORT_FILTER.contains((Object)ctx.dialect())) {
                ctx.visit(args);
            } else {
                QueryPartList<CaseConditionStep<Param<Integer>>> expressions = new QueryPartList<CaseConditionStep<Param<Integer>>>();
                for (Field<?> argument : args) {
                    expressions.add(DSL.when(this.filter, argument == ASTERISK ? DSL.one() : argument));
                }
                ctx.visit(expressions);
            }
        }
        if (this.distinct && args.size() > 1 && SUPPORT_DISTINCT_RVE.contains((Object)ctx.dialect())) {
            ctx.sql(')');
        }
    }

    final void acceptFilterClause(Context<?> ctx) {
        AbstractAggregateFunction.acceptFilterClause(ctx, this.filter);
    }

    static final void acceptFilterClause(Context<?> ctx, Condition filter) {
        if (filter != null && SUPPORT_FILTER.contains((Object)ctx.dialect())) {
            ctx.sql(' ').visit(Keywords.K_FILTER).sql(" (").visit(Keywords.K_WHERE).sql(' ').visit(filter).sql(')');
        }
    }

    final void acceptOrderBy(Context<?> ctx) {
        if (!Tools.isEmpty(this.withinGroupOrderBy)) {
            ctx.sql(' ').visit(Keywords.K_ORDER_BY).sql(' ').visit(this.withinGroupOrderBy);
        }
    }

    final QueryPartList<Field<?>> getArguments() {
        return this.arguments;
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Condition c) {
        this.filter = c;
        return this;
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Condition ... conditions) {
        return this.filterWhere(Arrays.asList(conditions));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Collection<? extends Condition> conditions) {
        ConditionProviderImpl c = new ConditionProviderImpl();
        c.addConditions(conditions);
        return this.filterWhere((Condition)c);
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Field<Boolean> field) {
        return this.filterWhere(DSL.condition(field));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Boolean field) {
        return this.filterWhere(DSL.condition(field));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(SQL sql) {
        return this.filterWhere(DSL.condition(sql));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(String sql) {
        return this.filterWhere(DSL.condition(sql));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(String sql, Object ... bindings) {
        return this.filterWhere(DSL.condition(sql, bindings));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(String sql, QueryPart ... parts) {
        return this.filterWhere(DSL.condition(sql, parts));
    }

    @Override
    public final AggregateFunction<T> withinGroupOrderBy(OrderField<?> ... fields) {
        return this.withinGroupOrderBy(Arrays.asList(fields));
    }

    @Override
    public final AggregateFunction<T> withinGroupOrderBy(Collection<? extends OrderField<?>> fields) {
        if (this.withinGroupOrderBy == null) {
            this.withinGroupOrderBy = new SortFieldList();
        }
        this.withinGroupOrderBy.addAll(Tools.sortFields(fields));
        return this;
    }

    @Override
    public AbstractAggregateFunction<T> orderBy(OrderField<?> ... fields) {
        if (this.windowSpecification != null) {
            super.orderBy((OrderField[])fields);
        } else {
            this.withinGroupOrderBy((OrderField[])fields);
        }
        return this;
    }

    @Override
    public AbstractAggregateFunction<T> orderBy(Collection<? extends OrderField<?>> fields) {
        if (this.windowSpecification != null) {
            this.windowSpecification.orderBy((Collection)fields);
        } else {
            this.withinGroupOrderBy((Collection)fields);
        }
        return this;
    }
}

