/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;

public class RouteHealthCheck
extends AbstractHealthCheck {
    private final Route route;

    public RouteHealthCheck(Route route) {
        super("camel", "route:" + route.getId());
        this.route = route;
    }

    public boolean isLiveness() {
        return false;
    }

    @Override
    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        if (this.route.getId() != null) {
            CamelContext context = this.route.getCamelContext();
            ServiceStatus status = context.getRouteController().getRouteStatus(this.route.getId());
            builder.detail("route.id", (Object)this.route.getId());
            builder.detail("route.status", (Object)status.name());
            builder.detail("route.context.name", (Object)context.getName());
            if (this.route.getRouteController() != null || this.route.isAutoStartup().booleanValue()) {
                if (status.isStarted()) {
                    builder.up();
                } else if (status.isStopped()) {
                    builder.down();
                    builder.message(String.format("Route %s has status %s", this.route.getId(), status.name()));
                }
            } else if (this.route.isAutoStartup().booleanValue()) {
                builder.up();
            } else if (this.route.getRouteController() == null) {
                if (this.route.getLastError() != null && this.route.getLastError().isUnhealthy()) {
                    builder.down();
                } else {
                    builder.unknown();
                }
            }
        }
    }
}

