/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.main.BaseMainSupport;
import org.apache.camel.main.DefaultMainShutdownStrategy;
import org.apache.camel.main.MainDurationEventNotifier;
import org.apache.camel.main.MainLifecycleStrategy;
import org.apache.camel.main.MainListener;
import org.apache.camel.main.MainShutdownStrategy;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MainSupport
extends BaseMainSupport {
    protected static final Logger LOG = LoggerFactory.getLogger(MainSupport.class);
    protected static final int UNINITIALIZED_EXIT_CODE = Integer.MIN_VALUE;
    protected static final int DEFAULT_EXIT_CODE = 0;
    protected final AtomicInteger exitCode = new AtomicInteger(Integer.MIN_VALUE);
    protected MainShutdownStrategy shutdownStrategy = new DefaultMainShutdownStrategy(this);
    protected volatile ProducerTemplate camelTemplate;

    protected MainSupport(Class<?> ... configurationClasses) {
        this();
        this.configure().addConfigurationClass(configurationClasses);
    }

    protected MainSupport() {
    }

    public void run() throws Exception {
        if (this.shutdownStrategy.isRunAllowed()) {
            this.init();
            this.internalBeforeStart();
            this.beforeStart();
            this.start();
            try {
                this.afterStart();
                this.waitUntilCompleted();
                this.internalBeforeStop();
                this.beforeStop();
                this.stop();
                this.afterStop();
            }
            catch (Exception e) {
                LOG.error("Failed: {}", (Object)e, (Object)e);
            }
        }
    }

    protected void beforeStart() throws Exception {
        for (MainListener listener : this.listeners) {
            listener.beforeStart(this);
        }
    }

    protected void afterStart() throws Exception {
        for (MainListener listener : this.listeners) {
            listener.afterStart(this);
        }
    }

    private void internalBeforeStart() {
    }

    protected void beforeStop() throws Exception {
        for (MainListener listener : this.listeners) {
            listener.beforeStop(this);
        }
    }

    protected void afterStop() throws Exception {
        for (MainListener listener : this.listeners) {
            listener.afterStop(this);
        }
    }

    private void internalBeforeStop() {
        try {
            if (this.camelTemplate != null) {
                ServiceHelper.stopService((Object)this.camelTemplate);
                this.camelTemplate = null;
            }
        }
        catch (Exception e) {
            LOG.debug("Error stopping camelTemplate due " + e.getMessage() + ". This exception is ignored.", (Throwable)e);
        }
    }

    public void completed() {
        this.shutdownStrategy.shutdown();
        this.exitCode.compareAndSet(Integer.MIN_VALUE, 0);
    }

    public Runnable getCompleteTask() {
        return this::completed;
    }

    @Deprecated
    public int getDuration() {
        return this.mainConfigurationProperties.getDurationMaxSeconds();
    }

    @Deprecated
    public void setDuration(int duration) {
        this.mainConfigurationProperties.setDurationMaxSeconds(duration);
    }

    @Deprecated
    public int getDurationIdle() {
        return this.mainConfigurationProperties.getDurationMaxIdleSeconds();
    }

    @Deprecated
    public void setDurationIdle(int durationIdle) {
        this.mainConfigurationProperties.setDurationMaxIdleSeconds(durationIdle);
    }

    @Deprecated
    public int getDurationMaxMessages() {
        return this.mainConfigurationProperties.getDurationMaxMessages();
    }

    @Deprecated
    public void setDurationMaxMessages(int durationMaxMessages) {
        this.mainConfigurationProperties.setDurationMaxMessages(durationMaxMessages);
    }

    @Deprecated
    public void setDurationHitExitCode(int durationHitExitCode) {
        this.mainConfigurationProperties.setDurationHitExitCode(durationHitExitCode);
    }

    @Deprecated
    public int getDurationHitExitCode() {
        return this.mainConfigurationProperties.getDurationHitExitCode();
    }

    public int getExitCode() {
        return this.exitCode.get();
    }

    public boolean isTrace() {
        return this.mainConfigurationProperties.isTracing();
    }

    public void enableTrace() {
        this.mainConfigurationProperties.setTracing(true);
    }

    public MainShutdownStrategy getShutdownStrategy() {
        return this.shutdownStrategy;
    }

    public void setShutdownStrategy(MainShutdownStrategy shutdownStrategy) {
        this.shutdownStrategy = shutdownStrategy;
    }

    protected void doStop() throws Exception {
        this.completed();
    }

    protected void doStart() throws Exception {
    }

    @Override
    protected void configureLifecycle(CamelContext camelContext) throws Exception {
        if (this.mainConfigurationProperties.getDurationMaxMessages() > 0 || this.mainConfigurationProperties.getDurationMaxIdleSeconds() > 0) {
            MainDurationEventNotifier notifier = new MainDurationEventNotifier(camelContext, this.mainConfigurationProperties.getDurationMaxMessages(), this.mainConfigurationProperties.getDurationMaxIdleSeconds(), this.shutdownStrategy, true);
            ServiceHelper.startService((Object)((Object)notifier));
            camelContext.getManagementStrategy().addEventNotifier((EventNotifier)notifier);
        }
        camelContext.addLifecycleStrategy((LifecycleStrategy)new MainLifecycleStrategy(this.shutdownStrategy));
    }

    protected void waitUntilCompleted() {
        while (this.shutdownStrategy.isRunAllowed()) {
            try {
                int idle = this.mainConfigurationProperties.getDurationMaxIdleSeconds();
                int max = this.mainConfigurationProperties.getDurationMaxMessages();
                long sec = this.mainConfigurationProperties.getDurationMaxSeconds();
                if (sec > 0L) {
                    LOG.info("Waiting for: {} seconds", (Object)sec);
                    this.shutdownStrategy.await(sec, TimeUnit.SECONDS);
                    this.exitCode.compareAndSet(Integer.MIN_VALUE, this.mainConfigurationProperties.getDurationHitExitCode());
                    this.shutdownStrategy.shutdown();
                    continue;
                }
                if (idle > 0 || max > 0) {
                    if (idle > 0 && max > 0) {
                        LOG.info("Waiting to be idle for: {} seconds or until: {} messages has been processed", (Object)idle, (Object)max);
                    } else if (idle > 0) {
                        LOG.info("Waiting to be idle for: {} seconds", (Object)idle);
                    } else {
                        LOG.info("Waiting until: {} messages has been processed", (Object)max);
                    }
                    this.exitCode.compareAndSet(Integer.MIN_VALUE, this.mainConfigurationProperties.getDurationHitExitCode());
                    this.shutdownStrategy.await();
                    this.shutdownStrategy.shutdown();
                    continue;
                }
                this.shutdownStrategy.await();
            }
            catch (InterruptedException e) {
                this.shutdownStrategy.shutdown();
                Thread.currentThread().interrupt();
            }
        }
    }

    protected abstract ProducerTemplate findOrCreateCamelTemplate();

    protected abstract CamelContext createCamelContext();

    public ProducerTemplate getCamelTemplate() throws Exception {
        if (this.camelTemplate == null) {
            this.camelTemplate = this.findOrCreateCamelTemplate();
        }
        return this.camelTemplate;
    }

    protected void initCamelContext() throws Exception {
        this.camelContext = this.createCamelContext();
        if (this.camelContext == null) {
            throw new IllegalStateException("Created CamelContext is null");
        }
        this.postProcessCamelContext(this.camelContext);
    }
}

