/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.schibsted.spt.data.jslt.JsltException;
import com.schibsted.spt.data.jslt.impl.AbstractOperator;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.NodeUtils;

public abstract class ComparisonOperator
extends AbstractOperator {
    public ComparisonOperator(ExpressionNode left, ExpressionNode right, String operator, Location location) {
        super(left, right, operator, location);
    }

    @Override
    public abstract JsonNode perform(JsonNode var1, JsonNode var2);

    public double compare(JsonNode v1, JsonNode v2) {
        if (v1.isNumber() && v2.isNumber()) {
            double n1 = NodeUtils.number(v1, this.location).doubleValue();
            double n2 = NodeUtils.number(v2, this.location).doubleValue();
            return n1 - n2;
        }
        if (v1.isTextual() && v2.isTextual()) {
            String s1 = v1.asText();
            String s2 = v2.asText();
            return s1.compareTo(s2);
        }
        if (v1.isNull() || v2.isNull()) {
            if (v1.isNull() && v2.isNull()) {
                return 0.0;
            }
            if (v1.isNull()) {
                return -1.0;
            }
            return 1.0;
        }
        throw new JsltException("Can't compare " + v1 + " and " + v2, this.location);
    }
}

