/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.function.Supplier;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,transformation")
@XmlRootElement(name="pollEnrich")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PollEnrichDefinition
extends ExpressionNode {
    @XmlAttribute
    @Metadata(javaType="java.lang.Long", defaultValue="-1")
    private String timeout;
    @XmlAttribute(name="strategyRef")
    private String aggregationStrategyRef;
    @XmlAttribute(name="strategyMethodName")
    private String aggregationStrategyMethodName;
    @XmlAttribute(name="strategyMethodAllowNull")
    @Metadata(javaType="java.lang.Boolean")
    private String aggregationStrategyMethodAllowNull;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String aggregateOnException;
    @XmlTransient
    private AggregationStrategy aggregationStrategy;
    @XmlAttribute
    @Metadata(javaType="java.lang.Integer")
    private String cacheSize;
    @XmlAttribute
    @Metadata(javaType="java.lang.Integer")
    private String ignoreInvalidEndpoint;

    public PollEnrichDefinition() {
    }

    public PollEnrichDefinition(AggregationStrategy aggregationStrategy, long timeout) {
        this.aggregationStrategy = aggregationStrategy;
        this.timeout = Long.toString(timeout);
    }

    public String toString() {
        return "PollEnrich[" + this.getExpression() + "]";
    }

    public String getShortName() {
        return "pollEnrich";
    }

    @Override
    public String getLabel() {
        return "pollEnrich[" + this.getExpression() + "]";
    }

    public PollEnrichDefinition timeout(long timeout) {
        this.setTimeout(Long.toString(timeout));
        return this;
    }

    public PollEnrichDefinition aggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public PollEnrichDefinition aggregationStrategy(Supplier<AggregationStrategy> aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy.get());
        return this;
    }

    public PollEnrichDefinition aggregationStrategyRef(String aggregationStrategyRef) {
        this.setAggregationStrategyRef(aggregationStrategyRef);
        return this;
    }

    public PollEnrichDefinition aggregationStrategyMethodName(String aggregationStrategyMethodName) {
        this.setAggregationStrategyMethodName(aggregationStrategyMethodName);
        return this;
    }

    public PollEnrichDefinition aggregationStrategyMethodAllowNull(boolean aggregationStrategyMethodAllowNull) {
        this.setAggregationStrategyMethodAllowNull(Boolean.toString(aggregationStrategyMethodAllowNull));
        return this;
    }

    public PollEnrichDefinition aggregateOnException(boolean aggregateOnException) {
        this.setAggregateOnException(Boolean.toString(aggregateOnException));
        return this;
    }

    public PollEnrichDefinition cacheSize(int cacheSize) {
        this.setCacheSize(Integer.toString(cacheSize));
        return this;
    }

    public PollEnrichDefinition cacheSize(String cacheSize) {
        this.setCacheSize(cacheSize);
        return this;
    }

    public PollEnrichDefinition ignoreInvalidEndpoint() {
        this.setIgnoreInvalidEndpoint(Boolean.toString(true));
        return this;
    }

    @Override
    public void setExpression(ExpressionDefinition expression) {
        super.setExpression(expression);
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getAggregationStrategyRef() {
        return this.aggregationStrategyRef;
    }

    public void setAggregationStrategyRef(String aggregationStrategyRef) {
        this.aggregationStrategyRef = aggregationStrategyRef;
    }

    public String getAggregationStrategyMethodName() {
        return this.aggregationStrategyMethodName;
    }

    public void setAggregationStrategyMethodName(String aggregationStrategyMethodName) {
        this.aggregationStrategyMethodName = aggregationStrategyMethodName;
    }

    public String getAggregationStrategyMethodAllowNull() {
        return this.aggregationStrategyMethodAllowNull;
    }

    public void setAggregationStrategyMethodAllowNull(String aggregationStrategyMethodAllowNull) {
        this.aggregationStrategyMethodAllowNull = aggregationStrategyMethodAllowNull;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public String getAggregateOnException() {
        return this.aggregateOnException;
    }

    public void setAggregateOnException(String aggregateOnException) {
        this.aggregateOnException = aggregateOnException;
    }

    public String getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(String cacheSize) {
        this.cacheSize = cacheSize;
    }

    public String getIgnoreInvalidEndpoint() {
        return this.ignoreInvalidEndpoint;
    }

    public void setIgnoreInvalidEndpoint(String ignoreInvalidEndpoint) {
        this.ignoreInvalidEndpoint = ignoreInvalidEndpoint;
    }
}

