/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.schibsted.spt.data.jslt.Expression;
import com.schibsted.spt.data.jslt.Function;
import com.schibsted.spt.data.jslt.impl.DotExpression;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.FunctionDeclaration;
import com.schibsted.spt.data.jslt.impl.JstlFile;
import com.schibsted.spt.data.jslt.impl.LetExpression;
import com.schibsted.spt.data.jslt.impl.NodeUtils;
import com.schibsted.spt.data.jslt.impl.OptimizeUtils;
import com.schibsted.spt.data.jslt.impl.PreparationContext;
import com.schibsted.spt.data.jslt.impl.Scope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ExpressionImpl
implements Expression {
    private LetExpression[] lets;
    private Map<String, Function> functions;
    private ExpressionNode actual;
    private int stackFrameSize;
    private JstlFile[] fileModules;
    private Map<String, Integer> parameterSlots;

    public ExpressionImpl(LetExpression[] lets, Map<String, Function> functions, ExpressionNode actual) {
        this.lets = lets;
        this.functions = functions;
        this.actual = actual;
        DotExpression root = new DotExpression(null);
        if (actual != null) {
            actual.computeMatchContexts(root);
        }
        for (int ix = 0; ix < lets.length; ++ix) {
            lets[ix].computeMatchContexts(root);
        }
    }

    public Function getFunction(String name) {
        return this.functions.get(name);
    }

    public boolean hasBody() {
        return this.actual != null;
    }

    @Override
    public JsonNode apply(Map<String, JsonNode> variables, JsonNode input) {
        Scope scope = Scope.makeScope(variables, this.stackFrameSize, this.parameterSlots);
        return this.apply(scope, input);
    }

    @Override
    public JsonNode apply(JsonNode input) {
        return this.apply(Scope.getRoot(this.stackFrameSize), input);
    }

    public JsonNode apply(Scope scope, JsonNode input) {
        if (input == null) {
            input = NullNode.instance;
        }
        if (this.fileModules != null) {
            for (int ix = 0; ix < this.fileModules.length; ++ix) {
                this.fileModules[ix].evaluateLetsOnly(scope, input);
            }
        }
        NodeUtils.evalLets(scope, input, this.lets);
        return this.actual.apply(scope, input);
    }

    public void dump() {
        for (int ix = 0; ix < this.lets.length; ++ix) {
            this.lets[ix].dump(0);
        }
        this.actual.dump(0);
    }

    public void prepare(PreparationContext ctx) {
        ctx.scope.enterScope();
        for (int ix = 0; ix < this.lets.length; ++ix) {
            this.lets[ix].register(ctx.scope);
        }
        for (ExpressionNode child : this.getChildren()) {
            child.prepare(ctx);
        }
        this.stackFrameSize = ctx.scope.getStackFrameSize();
        this.parameterSlots = ctx.scope.getParameterSlots();
        ctx.scope.leaveScope();
    }

    public void evaluateLetsOnly(Scope scope, JsonNode input) {
        NodeUtils.evalLets(scope, input, this.lets);
    }

    public void optimize() {
        this.lets = OptimizeUtils.optimizeLets(this.lets);
        for (Function f : this.functions.values()) {
            if (!(f instanceof FunctionDeclaration)) continue;
            ((FunctionDeclaration)f).optimize();
        }
        if (this.actual != null) {
            this.actual = this.actual.optimize();
        }
    }

    public List<ExpressionNode> getChildren() {
        ArrayList<ExpressionNode> children = new ArrayList<ExpressionNode>();
        children.addAll(Arrays.asList(this.lets));
        for (Function f : this.functions.values()) {
            if (!(f instanceof FunctionDeclaration)) continue;
            children.add((FunctionDeclaration)f);
        }
        if (this.actual != null) {
            children.add(this.actual);
        }
        return children;
    }

    public String toString() {
        return this.actual.toString();
    }

    public int getStackFrameSize() {
        return this.stackFrameSize;
    }

    public void setGlobalModules(List<JstlFile> fileModules) {
        this.fileModules = new JstlFile[fileModules.size()];
        this.fileModules = fileModules.toArray(this.fileModules);
    }
}

