/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.schibsted.spt.data.jslt.filters.JsonFilter;
import com.schibsted.spt.data.jslt.impl.AbstractNode;
import com.schibsted.spt.data.jslt.impl.DotExpression;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.LetExpression;
import com.schibsted.spt.data.jslt.impl.LiteralExpression;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.MatcherExpression;
import com.schibsted.spt.data.jslt.impl.NodeUtils;
import com.schibsted.spt.data.jslt.impl.OptimizerScope;
import com.schibsted.spt.data.jslt.impl.PairExpression;
import com.schibsted.spt.data.jslt.impl.PreparationContext;
import com.schibsted.spt.data.jslt.impl.Scope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ObjectExpression
extends AbstractNode {
    private LetExpression[] lets;
    private PairExpression[] children;
    private DotExpression contextQuery;
    private MatcherExpression matcher;
    private Set<String> keys;
    private JsonFilter filter;

    public ObjectExpression(LetExpression[] lets, PairExpression[] children, MatcherExpression matcher, Location location, JsonFilter filter) {
        super(location);
        this.lets = lets;
        this.children = children;
        this.matcher = matcher;
        this.filter = filter;
        this.keys = new HashSet<String>();
        for (int ix = 0; ix < children.length; ++ix) {
            this.keys.add(children[ix].getKey());
        }
        if (matcher != null) {
            for (String minus : matcher.getMinuses()) {
                this.keys.add(minus);
            }
        }
    }

    @Override
    public JsonNode apply(Scope scope, JsonNode input) {
        NodeUtils.evalLets(scope, input, this.lets);
        ObjectNode object = NodeUtils.mapper.createObjectNode();
        for (int ix = 0; ix < this.children.length; ++ix) {
            JsonNode value = this.children[ix].apply(scope, input);
            if (!this.filter.filter(value)) continue;
            object.put(this.children[ix].getKey(), value);
        }
        if (this.matcher != null) {
            this.evaluateMatcher(scope, input, object);
        }
        return object;
    }

    private void evaluateMatcher(Scope scope, JsonNode input, ObjectNode object) {
        JsonNode context = this.contextQuery.apply(scope, input);
        if (context.isNull() && !context.isObject()) {
            return;
        }
        Iterator it = context.fields();
        while (it.hasNext()) {
            Map.Entry pair = (Map.Entry)it.next();
            if (this.keys.contains(pair.getKey())) continue;
            JsonNode value = this.matcher.apply(scope, (JsonNode)pair.getValue());
            object.put((String)pair.getKey(), value);
        }
    }

    @Override
    public void computeMatchContexts(DotExpression parent) {
        int ix;
        if (this.matcher != null) {
            this.contextQuery = parent;
            this.contextQuery.checkOk(this.location);
        }
        for (ix = 0; ix < this.lets.length; ++ix) {
            this.lets[ix].computeMatchContexts(parent);
        }
        for (ix = 0; ix < this.children.length; ++ix) {
            this.children[ix].computeMatchContexts(parent);
        }
    }

    @Override
    public ExpressionNode optimize() {
        for (int ix = 0; ix < this.lets.length; ++ix) {
            this.lets[ix].optimize();
        }
        if (this.matcher != null) {
            this.matcher.optimize();
        }
        boolean allLiterals = this.matcher == null;
        for (int ix = 0; ix < this.children.length; ++ix) {
            this.children[ix] = (PairExpression)this.children[ix].optimize();
            allLiterals = allLiterals && this.children[ix].isLiteral();
        }
        if (!allLiterals) {
            return this;
        }
        JsonNode object = this.apply(new OptimizerScope(), (JsonNode)NullNode.instance);
        return new LiteralExpression(object, this.location);
    }

    @Override
    public void prepare(PreparationContext ctx) {
        ctx.scope.enterScope();
        for (int ix = 0; ix < this.lets.length; ++ix) {
            this.lets[ix].register(ctx.scope);
        }
        for (ExpressionNode child : this.getChildren()) {
            child.prepare(ctx);
        }
        ctx.scope.leaveScope();
    }

    @Override
    public List<ExpressionNode> getChildren() {
        ArrayList<ExpressionNode> children = new ArrayList<ExpressionNode>();
        children.addAll(Arrays.asList(this.lets));
        children.addAll(Arrays.asList(this.children));
        if (this.matcher != null) {
            children.add(this.matcher);
        }
        return children;
    }

    @Override
    public void dump(int level) {
        int ix;
        System.out.println(NodeUtils.indent(level) + '{');
        for (ix = 0; ix < this.lets.length; ++ix) {
            this.lets[ix].dump(level + 1);
        }
        for (ix = 0; ix < this.children.length; ++ix) {
            this.children[ix].dump(level + 1);
        }
        System.out.println(NodeUtils.indent(level) + '}');
    }
}

