/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.schibsted.spt.data.jslt.impl.AbstractNode;
import com.schibsted.spt.data.jslt.impl.DotExpression;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.LiteralExpression;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.NodeUtils;
import com.schibsted.spt.data.jslt.impl.Scope;
import java.util.Collections;
import java.util.List;

public class PairExpression
extends AbstractNode {
    private String key;
    private ExpressionNode expr;

    public PairExpression(String key, ExpressionNode expr, Location location) {
        super(location);
        this.key = key;
        this.expr = expr;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public JsonNode apply(Scope scope, JsonNode input) {
        return this.expr.apply(scope, input);
    }

    @Override
    public void computeMatchContexts(DotExpression parent) {
        this.expr.computeMatchContexts(new DotExpression(this.key, parent, this.location));
    }

    public boolean isLiteral() {
        return this.expr instanceof LiteralExpression;
    }

    @Override
    public ExpressionNode optimize() {
        this.expr = this.expr.optimize();
        return this;
    }

    @Override
    public List<ExpressionNode> getChildren() {
        return Collections.singletonList(this.expr);
    }

    @Override
    public void dump(int level) {
        System.out.println(NodeUtils.indent(level) + '\"' + this.key + '\"' + " :");
        this.expr.dump(level + 1);
    }
}

