/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.NodeUtils;
import com.schibsted.spt.data.jslt.impl.NumericOperator;

public class PlusOperator
extends NumericOperator {
    public PlusOperator(ExpressionNode left, ExpressionNode right, Location location) {
        super(left, right, "+", location);
    }

    @Override
    public JsonNode perform(JsonNode v1, JsonNode v2) {
        if (v1.isTextual() || v2.isTextual()) {
            return new TextNode(NodeUtils.toString(v1, false) + NodeUtils.toString(v2, false));
        }
        if (v1.isArray() && v2.isArray()) {
            return this.concatenateArrays(v1, v2);
        }
        if (v1.isObject() && v2.isObject()) {
            return this.unionObjects(v1, v2);
        }
        if ((v1.isObject() || v1.isArray()) && v2.isNull()) {
            return v1;
        }
        if (v1.isNull() && (v2.isObject() || v2.isArray())) {
            return v2;
        }
        return super.perform(v1, v2);
    }

    @Override
    protected double perform(double v1, double v2) {
        return v1 + v2;
    }

    @Override
    protected long perform(long v1, long v2) {
        return v1 + v2;
    }

    private ArrayNode concatenateArrays(JsonNode v1, JsonNode v2) {
        ArrayNode result = NodeUtils.mapper.createArrayNode();
        result.addAll((ArrayNode)v1);
        result.addAll((ArrayNode)v2);
        return result;
    }

    private ObjectNode unionObjects(JsonNode v1, JsonNode v2) {
        ObjectNode result = NodeUtils.mapper.createObjectNode();
        result.putAll((ObjectNode)v2);
        result.putAll((ObjectNode)v1);
        return result;
    }
}

