/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jslt;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.schibsted.spt.data.jslt.Expression;
import com.schibsted.spt.data.jslt.Function;
import com.schibsted.spt.data.jslt.JsltException;
import com.schibsted.spt.data.jslt.Parser;
import com.schibsted.spt.data.jslt.filters.JsonFilter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.ValidationException;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.component.jslt.JsltComponent;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.1.0", scheme="jslt", title="JSLT", syntax="jslt:resourceUri", producerOnly=true, category={Category.TRANSFORMATION})
public class JsltEndpoint
extends ResourceEndpoint {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private Expression transform;
    @UriParam(defaultValue="false")
    private boolean allowTemplateFromHeader;
    @UriParam(defaultValue="false", label="common")
    private boolean prettyPrint;

    public JsltEndpoint() {
    }

    public JsltEndpoint(String uri, JsltComponent component, String resourceUri) {
        super(uri, (Component)component, resourceUri);
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    protected String createEndpointUri() {
        return "jslt:" + this.getResourceUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Expression getTransform(Message msg) throws Exception {
        if (this.transform == null) {
            if (this.log.isDebugEnabled()) {
                String path = this.getResourceUri();
                this.log.debug("Jslt content read from resource {} with resourceUri: {} for endpoint {}", new Object[]{this.getResourceUri(), path, this.getEndpointUri()});
            }
            String jsltStringFromHeader = this.allowTemplateFromHeader ? (String)msg.getHeader("CamelJsltString", String.class) : null;
            Collection<Function> functions = ((JsltComponent)this.getComponent()).getFunctions();
            JsonFilter objectFilter = ((JsltComponent)this.getComponent()).getObjectFilter();
            InputStream stream = null;
            try {
                Parser parser;
                if (jsltStringFromHeader != null) {
                    parser = new Parser((Reader)new StringReader(jsltStringFromHeader)).withSource("<inline>");
                } else {
                    stream = JsltEndpoint.class.getClassLoader().getResourceAsStream(this.getResourceUri());
                    if (stream == null) {
                        throw new JsltException("Cannot load resource '" + this.getResourceUri() + "': not found");
                    }
                    InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                    parser = new Parser((Reader)reader).withSource(this.getResourceUri());
                }
                if (functions != null) {
                    parser = parser.withFunctions(functions);
                }
                if (objectFilter != null) {
                    parser = parser.withObjectFilter(objectFilter);
                }
                this.transform = parser.compile();
            }
            catch (Throwable throwable) {
                IOHelper.close(stream);
                throw throwable;
            }
            IOHelper.close((Closeable)stream);
        }
        return this.transform;
    }

    public JsltEndpoint findOrCreateEndpoint(String uri, String newResourceUri) {
        String newUri = uri.replace(this.getResourceUri(), newResourceUri);
        this.log.debug("Getting endpoint with URI: {}", (Object)newUri);
        return (JsltEndpoint)this.getCamelContext().getEndpoint(newUri, JsltEndpoint.class);
    }

    protected void onExchange(Exchange exchange) throws Exception {
        JsonNode input;
        String path = this.getResourceUri();
        ObjectHelper.notNull((Object)path, (String)"resourceUri");
        String newResourceUri = null;
        if (this.allowTemplateFromHeader) {
            newResourceUri = (String)exchange.getIn().getHeader("CamelJsltResourceUri", String.class);
        }
        if (newResourceUri != null) {
            exchange.getIn().removeHeader("CamelJsltResourceUri");
            this.log.debug("{} set to {} creating new endpoint to handle exchange", (Object)"CamelJsltResourceUri", (Object)newResourceUri);
            JsltEndpoint newEndpoint = this.findOrCreateEndpoint(this.getEndpointUri(), newResourceUri);
            newEndpoint.onExchange(exchange);
            return;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        if (exchange.getIn().getBody() instanceof String) {
            input = objectMapper.readTree((String)exchange.getIn().getBody(String.class));
        } else if (exchange.getIn().getBody() instanceof InputStream) {
            input = objectMapper.readTree((InputStream)exchange.getIn().getBody(InputStream.class));
        } else {
            this.log.debug("Body content is not String neither InputStream.");
            throw new ValidationException(exchange, "Allowed body types are String or InputStream.");
        }
        Map<String, JsonNode> variables = this.extractVariables(exchange);
        JsonNode output = this.getTransform(exchange.getMessage()).apply(variables, input);
        Message out = exchange.getMessage();
        out.setBody((Object)(this.isPrettyPrint() ? output.toPrettyString() : output.toString()));
        out.setHeaders(exchange.getIn().getHeaders());
    }

    private Map<String, JsonNode> extractVariables(Exchange exchange) {
        Map variableMap = ExchangeHelper.createVariableMap((Exchange)exchange, (boolean)this.isAllowContextMapAll());
        HashMap<String, JsonNode> serializedVariableMap = new HashMap<String, JsonNode>();
        if (variableMap.containsKey("headers")) {
            serializedVariableMap.put("headers", (JsonNode)this.serializeMapToJsonNode((Map)variableMap.get("headers")));
        }
        if (variableMap.containsKey("exchange")) {
            Exchange ex = (Exchange)variableMap.get("exchange");
            ObjectNode exchangeNode = OBJECT_MAPPER.createObjectNode();
            if (ex.getProperties() != null) {
                exchangeNode.set("properties", (JsonNode)this.serializeMapToJsonNode(ex.getProperties()));
            }
            serializedVariableMap.put("exchange", (JsonNode)exchangeNode);
        }
        return serializedVariableMap;
    }

    private ObjectNode serializeMapToJsonNode(Map<String, Object> map) {
        ObjectNode mapNode = OBJECT_MAPPER.createObjectNode();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            try {
                mapNode.set(entry.getKey(), OBJECT_MAPPER.valueToTree(entry.getValue()));
            }
            catch (IllegalArgumentException e) {
                this.log.debug("Value could not be converted to JsonNode", (Throwable)e);
            }
        }
        return mapNode;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public boolean isAllowTemplateFromHeader() {
        return this.allowTemplateFromHeader;
    }

    public void setAllowTemplateFromHeader(boolean allowTemplateFromHeader) {
        this.allowTemplateFromHeader = allowTemplateFromHeader;
    }
}

