/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.schibsted.spt.data.jslt.JsltException;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.NumericOperator;

public class MultiplyOperator
extends NumericOperator {
    public MultiplyOperator(ExpressionNode left, ExpressionNode right, Location location) {
        super(left, right, "*", location);
    }

    @Override
    public JsonNode perform(JsonNode v1, JsonNode v2) {
        if (v1.isTextual() || v2.isTextual()) {
            int num;
            String str;
            if (v1.isTextual() && !v2.isTextual()) {
                str = v1.asText();
                num = v2.intValue();
            } else if (v2.isTextual()) {
                str = v2.asText();
                num = v1.intValue();
            } else {
                throw new JsltException("Can't multiply two strings!");
            }
            StringBuilder buf = new StringBuilder();
            while (num > 0) {
                buf.append(str);
                --num;
            }
            return new TextNode(buf.toString());
        }
        return super.perform(v1, v2);
    }

    @Override
    protected double perform(double v1, double v2) {
        return v1 * v2;
    }

    @Override
    protected long perform(long v1, long v2) {
        return v1 * v2;
    }
}

