/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.VariableLengthFieldDescription;
import java.io.UnsupportedEncodingException;

class DDMRecordCache {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final int BACKWARD = 1;
    static final int FORWARD = 0;
    int currentDirection_ = 0;
    private int currentPosition_;
    private boolean containsFirstRecord_;
    private boolean containsLastRecord_;
    private boolean isEmpty_;
    private Record[] records_ = new Record[0];
    private int size_;

    DDMRecordCache() {
        this.setIsEmpty();
    }

    DDMRecordCache(Record[] recordArray, int n, boolean bl, boolean bl2) {
        this.refresh(recordArray, n, bl, bl2);
    }

    void add(Record record, boolean bl) {
        Record[] recordArray = new Record[this.records_.length + 1];
        if (bl) {
            System.arraycopy(this.records_, 0, recordArray, 0, this.records_.length);
            recordArray[this.records_.length] = record;
        } else {
            System.arraycopy(this.records_, 0, recordArray, 1, this.records_.length);
            recordArray[0] = record;
            ++this.currentPosition_;
        }
        this.records_ = recordArray;
        this.size_ = this.records_.length;
        this.isEmpty_ = false;
    }

    boolean compareKeys(Object[] objectArray, Object[] objectArray2) {
        if (objectArray.length > objectArray2.length) {
            return false;
        }
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        RecordFormat recordFormat = this.records_[0].getRecordFormat();
        block0: for (int i = 0; i < objectArray.length && bl; ++i) {
            if (objectArray[i] instanceof byte[] && objectArray2[i] instanceof byte[]) {
                if (((byte[])objectArray[i]).length != ((byte[])objectArray2[i]).length) {
                    bl = false;
                    continue;
                }
                for (int j = 0; j < ((byte[])objectArray[i]).length; ++j) {
                    if (((byte[])objectArray[i])[j] == ((byte[])objectArray2[i])[j]) continue;
                    bl = false;
                    continue block0;
                }
                continue;
            }
            if (recordFormat.getKeyFieldDescription(i) instanceof VariableLengthFieldDescription) {
                if (((String)objectArray[i]).equals("") && ((String)objectArray2[i]).equals("")) continue;
                n = ((String)objectArray[i]).length() - 1;
                while (((String)objectArray[i]).charAt(n) == ' ') {
                    --n;
                }
                n2 = ((String)objectArray2[i]).length() - 1;
                while (((String)objectArray2[i]).charAt(n2) == ' ') {
                    --n2;
                }
                if (((String)objectArray[i]).substring(0, n + 1).equals(((String)objectArray2[i]).substring(0, n2 + 1))) continue;
                bl = false;
                continue;
            }
            if (objectArray[i].equals(objectArray2[i])) continue;
            bl = false;
        }
        return bl;
    }

    boolean containsFirstRecord() {
        return this.containsFirstRecord_;
    }

    boolean containsLastRecord() {
        return this.containsLastRecord_;
    }

    void dump() {
        System.out.println("Dumping cache:");
        for (int i = 0; i < this.records_.length; ++i) {
            System.out.println(this.records_[i]);
        }
    }

    int findRecord(int n) {
        for (int i = 0; i < this.size_; ++i) {
            if (this.records_[i].getRecordNumber() != n) continue;
            return i;
        }
        return -1;
    }

    int findRecordLong(long l) {
        for (int i = 0; i < this.size_; ++i) {
            if (this.records_[i].getRecordNumberLong() != l) continue;
            return i;
        }
        return -1;
    }

    int findRecord(Object[] objectArray, boolean bl) throws UnsupportedEncodingException {
        if (objectArray.length > this.records_[0].getKeyFields().length) {
            return -1;
        }
        if (bl) {
            for (int i = this.currentPosition_ + 1; i < this.size_; ++i) {
                boolean bl2 = this.compareKeys(objectArray, this.records_[i].getKeyFields());
                if (!bl2) continue;
                return i;
            }
        } else {
            for (int i = this.currentPosition_ - 1; i > -1; --i) {
                boolean bl3 = this.compareKeys(objectArray, this.records_[i].getKeyFields());
                if (!bl3) continue;
                return i;
            }
        }
        return -1;
    }

    Record getCurrent() {
        return this.currentPosition_ > -1 && this.currentPosition_ < this.size_ ? this.records_[this.currentPosition_] : null;
    }

    Record getFirst() {
        if (this.isEmpty_) {
            return null;
        }
        this.currentPosition_ = 0;
        return this.records_[this.currentPosition_];
    }

    Record getLast() {
        if (this.isEmpty_) {
            return null;
        }
        this.currentPosition_ = this.size_ - 1;
        return this.records_[this.currentPosition_];
    }

    Record getNext() {
        if (this.isEmpty_) {
            return null;
        }
        return this.currentPosition_ < this.size_ - 1 ? this.records_[++this.currentPosition_] : null;
    }

    Record getPrevious() {
        if (this.isEmpty_) {
            return null;
        }
        return this.currentPosition_ != 0 ? this.records_[--this.currentPosition_] : null;
    }

    Record getRecord(int n) {
        if (this.isEmpty_) {
            return null;
        }
        int n2 = this.findRecord(n);
        if (n2 != -1) {
            this.currentPosition_ = n2;
            return this.records_[n2];
        }
        return null;
    }

    Record getNextEqualRecord(Object[] objectArray) throws UnsupportedEncodingException {
        if (this.isEmpty_) {
            return null;
        }
        int n = this.findRecord(objectArray, true);
        if (n != -1) {
            this.currentPosition_ = n;
            return this.records_[n];
        }
        return null;
    }

    Record getPreviousEqualRecord(Object[] objectArray) throws UnsupportedEncodingException {
        if (this.isEmpty_) {
            return null;
        }
        int n = this.findRecord(objectArray, false);
        if (n != -1) {
            this.currentPosition_ = n;
            return this.records_[n];
        }
        return null;
    }

    boolean isAfterLast() {
        return this.isEmpty_ ? false : this.currentPosition_ == this.size_;
    }

    boolean isBeforeFirst() {
        return this.isEmpty_ ? false : this.currentPosition_ == -1;
    }

    boolean isBeginningOfCache() {
        return this.currentPosition_ <= 0;
    }

    boolean isEmpty() {
        return this.isEmpty_;
    }

    boolean isEndOfCache() {
        return this.currentPosition_ >= this.size_ - 1;
    }

    void refresh(Record[] recordArray, int n, boolean bl, boolean bl2) {
        int n2;
        this.currentDirection_ = n;
        if (recordArray == null || recordArray.length == 0) {
            this.isEmpty_ = true;
            this.containsFirstRecord_ = false;
            this.containsLastRecord_ = false;
            this.currentPosition_ = -1;
            this.size_ = 0;
        } else {
            if (n == 0) {
                this.records_ = recordArray;
            } else {
                this.records_ = new Record[recordArray.length];
                n2 = recordArray.length - 1;
                int n3 = 0;
                while (n2 >= 0) {
                    this.records_[n3] = recordArray[n2];
                    --n2;
                    ++n3;
                }
            }
            this.containsFirstRecord_ = bl;
            this.containsLastRecord_ = bl2;
            this.currentPosition_ = n == 0 ? 0 : recordArray.length - 1;
            this.size_ = this.records_.length;
            this.isEmpty_ = false;
        }
        if (Trace.isTraceOn()) {
            Trace.log(3, "Record cache refreshed:");
            for (n2 = 0; n2 < this.records_.length; ++n2) {
                Trace.log(3, this.records_[n2].toString());
            }
        }
    }

    void setIsEmpty() {
        this.isEmpty_ = true;
        this.containsFirstRecord_ = false;
        this.containsLastRecord_ = false;
        this.currentPosition_ = -1;
        this.size_ = 0;
    }

    boolean setPosition(int n) {
        if (this.isEmpty_) {
            return false;
        }
        int n2 = this.findRecord(n);
        if (n2 > -1) {
            this.currentPosition_ = n2;
        }
        return n2 > -1;
    }

    boolean setPositionLong(long l) {
        if (this.isEmpty_) {
            return false;
        }
        int n = this.findRecordLong(l);
        if (n > -1) {
            this.currentPosition_ = n;
        }
        return n > -1;
    }

    boolean setPosition(Object[] objectArray) throws UnsupportedEncodingException {
        if (this.isEmpty_) {
            return false;
        }
        int n = this.findRecord(objectArray, true);
        if (n > -1) {
            this.currentPosition_ = n;
        }
        return n > -1;
    }

    void setPositionAfterLast() {
        if (!this.isEmpty_) {
            this.currentPosition_ = this.size_;
        }
    }

    void setPositionBeforeFirst() {
        if (!this.isEmpty_) {
            this.currentPosition_ = -1;
        }
    }

    void setPositionFirst() {
        if (!this.isEmpty_) {
            this.currentPosition_ = 0;
        }
    }

    void setPositionLast() {
        if (!this.isEmpty_) {
            this.currentPosition_ = this.size_ - 1;
        }
    }

    void setPositionNext() {
        if (!this.isEmpty_ && this.currentPosition_ < this.size_) {
            ++this.currentPosition_;
        }
    }

    void setPositionPrevious() {
        if (!this.isEmpty_ && this.currentPosition_ > -1) {
            --this.currentPosition_;
        }
    }
}

