/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.ToolboxLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Trace
implements Runnable {
    private static final String CLASSNAME = "com.ibm.as400.access.Trace";
    private static final int DEFAULT_MONITOR_PORT = 55555;
    static boolean traceOn_;
    static boolean traceInfo_;
    static boolean traceWarning_;
    static boolean traceError_;
    static boolean traceDiagnostic_;
    static boolean traceDatastream_;
    static boolean traceConversion_;
    static boolean traceProxy_;
    static boolean traceThread_;
    static boolean traceJDBC_;
    static boolean tracePCML_;
    static boolean showChars_;
    private static int mostRecentTracingChange_;
    private static final int TURNED_TRACE_ON = 1;
    private static final int TURNED_TRACE_OFF = 2;
    private static boolean aTraceCategoryHasBeenActivated_;
    private static String fileName_;
    private static PrintWriter destination_;
    private static boolean userSpecifiedDestination_;
    private static Hashtable printWriterHash_;
    private static Hashtable fileNameHash_;
    private static SimpleDateFormat timeStampFormatter_;
    public static final int DATASTREAM = 0;
    public static final int DIAGNOSTIC = 1;
    public static final int ERROR = 2;
    public static final int INFORMATION = 3;
    public static final int WARNING = 4;
    public static final int CONVERSION = 5;
    public static final int PROXY = 6;
    public static final int PCML = 7;
    public static final int JDBC = 8;
    public static final String LOGGER_NAME = "com.ibm.as400.access";
    private static ToolboxLogger logger_;
    private static boolean firstCallToFindLogger_;
    private static boolean JDK14_OR_HIGHER;
    private static PrintWriter globalPw;
    private static final String[] HEX_BYTE_ARRAY;
    private static final String[] ASCII_BYTE_ARRAY;
    private static final String[] EBCDIC_BYTE_ARRAY;

    private Trace() {
    }

    public static String getFileName() {
        return fileName_;
    }

    public static String getFileName(Object object) {
        if (object == null) {
            throw new NullPointerException("component");
        }
        return (String)fileNameHash_.get(object);
    }

    public static PrintWriter getPrintWriter() {
        return destination_;
    }

    public static PrintWriter getPrintWriter(Object object) {
        if (object == null) {
            throw new NullPointerException("component");
        }
        return (PrintWriter)printWriterHash_.get(object);
    }

    public static final boolean isTraceAllOn() {
        return traceConversion_ && traceDatastream_ && traceDiagnostic_ && traceError_ && traceInfo_ && traceProxy_ && traceWarning_ && traceThread_ && traceJDBC_ && tracePCML_;
    }

    public static final boolean isTraceConversionOn() {
        return traceConversion_;
    }

    public static final boolean isTraceDatastreamOn() {
        return traceDatastream_;
    }

    public static final boolean isTraceDiagnosticOn() {
        return traceDiagnostic_;
    }

    public static final boolean isTraceErrorOn() {
        return traceError_;
    }

    public static final boolean isTraceInformationOn() {
        return traceInfo_;
    }

    public static final boolean isTraceJDBCOn() {
        return traceJDBC_;
    }

    public static final boolean isTraceOn() {
        return traceOn_;
    }

    public static final boolean isTraceOn(int n) {
        switch (n) {
            case 0: {
                return traceDatastream_;
            }
            case 1: {
                return traceDiagnostic_;
            }
            case 2: {
                return traceError_;
            }
            case 3: {
                return traceInfo_;
            }
            case 4: {
                return traceWarning_;
            }
            case 5: {
                return traceConversion_;
            }
            case 6: {
                return traceProxy_;
            }
            case 7: {
                return tracePCML_;
            }
            case 8: {
                return traceJDBC_;
            }
        }
        return false;
    }

    public static final boolean isTracePCMLOn() {
        return tracePCML_;
    }

    public static final boolean isTraceProxyOn() {
        return traceProxy_;
    }

    public static final boolean isTraceThreadOn() {
        return traceThread_;
    }

    public static final boolean isTraceWarningOn() {
        return traceWarning_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadTraceProperties() {
        Object object;
        block11: {
            String string;
            String string2;
            String string3 = SystemProperties.getProperty("com.ibm.as400.access.Trace.categories");
            if (string3 != null) {
                Trace.setTraceCategories(string3);
                if (traceOn_) {
                    Trace.log(4, "Incorrect tracing property name specified: com.ibm.as400.access.Trace.categories");
                }
            }
            String string4 = SystemProperties.getProperty("com.ibm.as400.access.Trace.category");
            if (string3 == null || string4 != null) {
                Trace.setTraceCategories(string4);
            }
            if ((string2 = SystemProperties.getProperty("com.ibm.as400.access.Trace.showChars")) != null && string2.equalsIgnoreCase("true")) {
                showChars_ = true;
            }
            if ((string = SystemProperties.getProperty("com.ibm.as400.access.Trace.file")) != null) {
                try {
                    Trace.setFileName(string);
                    object = destination_;
                    synchronized (object) {
                        destination_.println("Toolbox for Java - JDBC 3.0 Open Source Software, JTOpen 10.3 codebase 5770-SS1 V7R4M0.00 built=20200228 @AB4");
                        destination_.println(Trace.getJvmInfo());
                        destination_.println();
                        Trace.logLoadPath(CLASSNAME, Trace.activeTraceCategory());
                    }
                }
                catch (IOException iOException) {
                    if (!Trace.isTraceOn()) break block11;
                    String string5 = "Trace file not valid: " + string;
                    System.err.println(string5);
                    iOException.printStackTrace(System.err);
                    Trace.log(4, string5, (Throwable)iOException);
                }
            }
        }
        if ((object = SystemProperties.getProperty("com.ibm.as400.access.Trace.enabled")) != null) {
            boolean bl;
            traceOn_ = bl = Boolean.valueOf((String)object).booleanValue();
        }
        Trace.startTraceMonitorIfNeeded();
        Trace.logLoadPath(CLASSNAME);
    }

    static final void logLoadPath(String string) {
        Trace.logLoadPath(string, -1);
    }

    static final void logLoadPath(String string, int n) {
        if ((n > -1 || traceDiagnostic_) && string != null) {
            Object object;
            String string2 = null;
            try {
                String string3;
                URL uRL;
                object = Class.forName(string).getClassLoader();
                if (object != null && (uRL = ((ClassLoader)object).getResource(string3 = string.replace('.', '/') + ".class")) != null) {
                    string2 = uRL.getPath();
                }
            }
            catch (Throwable throwable) {
                String string4 = "Unable to determine load path for class " + string;
                Trace.logData(null, 2, string4, throwable);
            }
            object = "Class " + string + " was loaded from " + string2;
            if (n > -1) {
                Trace.logData(null, n, (String)object, null);
            } else {
                Trace.logData(null, 1, (String)object, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logTimeStamp(Object object, PrintWriter printWriter) {
        if (object != null && object.toString() != null) {
            printWriter.print("[" + object.toString() + "]  ");
        }
        if (traceThread_) {
            printWriter.print(Thread.currentThread().toString());
            printWriter.print("  ");
        }
        SimpleDateFormat simpleDateFormat = timeStampFormatter_;
        synchronized (simpleDateFormat) {
            printWriter.print(timeStampFormatter_.format(new Date()));
        }
        printWriter.print("  ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logTimeStamp(Object object, StringBuffer stringBuffer) {
        if (object != null && object.toString() != null) {
            stringBuffer.append("[" + object.toString() + "]  ");
        }
        if (traceThread_) {
            stringBuffer.append(Thread.currentThread().toString());
            stringBuffer.append("  ");
        }
        SimpleDateFormat simpleDateFormat = timeStampFormatter_;
        synchronized (simpleDateFormat) {
            stringBuffer.append(timeStampFormatter_.format(new Date()));
        }
        stringBuffer.append("  ");
    }

    private static void logSource(Object object, StringBuffer stringBuffer) {
        if (object == null) {
            return;
        }
        stringBuffer.append('[');
        String string = object.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        stringBuffer.append(string);
        stringBuffer.append('@');
        stringBuffer.append(object.hashCode());
        stringBuffer.append("] ");
    }

    private static void logSource(Object object, PrintWriter printWriter) {
        if (object == null) {
            return;
        }
        printWriter.print('[');
        String string = object.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        printWriter.print(string);
        printWriter.print('@');
        printWriter.print(object.hashCode());
        printWriter.print("] ");
    }

    private static final void logData(Object object, int n, String string, Throwable throwable) {
        Trace.logData(object, n, null, string, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void logData(Object object, int n, Object object2, String string, Throwable throwable) {
        if (traceOn_ && Trace.traceCategory(n) || Trace.findLogger() && logger_.isLoggable(n)) {
            if (string == null) {
                string = "(null)";
            }
            if (logger_ == null || userSpecifiedDestination_) {
                PrintWriter printWriter = destination_;
                synchronized (printWriter) {
                    if (object != null && Trace.getFileName(object) != null) {
                        Trace.logTimeStamp(object, destination_);
                        Trace.logSource(object2, destination_);
                        destination_.println(string);
                    } else if (object == null) {
                        Trace.logTimeStamp(null, destination_);
                        Trace.logSource(object2, destination_);
                        destination_.println(string);
                    }
                    if (throwable != null) {
                        throwable.printStackTrace(destination_);
                    } else if (n == 2) {
                        new Throwable().printStackTrace(destination_);
                    }
                }
                if (object != null) {
                    printWriter = (PrintWriter)printWriterHash_.get(object);
                    if (printWriter == null) {
                        if (globalPw == null) {
                            globalPw = new PrintWriter(System.out, true);
                        }
                        printWriter = globalPw;
                        printWriterHash_.put(object, printWriter);
                    }
                    PrintWriter printWriter2 = printWriter;
                    synchronized (printWriter2) {
                        Trace.logTimeStamp(object, printWriter);
                        Trace.logSource(object2, printWriter);
                        printWriter.println(string);
                        if (throwable != null) {
                            throwable.printStackTrace(printWriter);
                        } else if (n == 2) {
                            new Throwable().printStackTrace(printWriter);
                        }
                    }
                }
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                Trace.logTimeStamp(object, stringBuffer);
                Trace.logSource(object2, stringBuffer);
                stringBuffer.append(string);
                if (throwable != null) {
                    logger_.log(n, stringBuffer.toString(), throwable);
                } else if (n == 2) {
                    logger_.log(n, stringBuffer.toString(), new Throwable());
                } else {
                    logger_.log(n, stringBuffer.toString());
                }
            }
        }
    }

    public static final void log(int n, String string) {
        Trace.logData(null, n, null, string, null);
    }

    public static final void log(int n, Object object, String string) {
        Trace.logData(null, n, object, string, null);
    }

    public static final void log(Object object, int n, String string) {
        Trace.logData(object, n, null, string, null);
    }

    public static final void log(Object object, int n, Object object2, String string) {
        Trace.logData(object, n, object2, string, null);
    }

    public static final void log(int n, String string, Throwable throwable) {
        Trace.logData(null, n, null, string, throwable);
    }

    public static final void log(int n, Object object, String string, Throwable throwable) {
        Trace.logData(null, n, object, string, throwable);
    }

    public static final void log(Object object, int n, String string, Throwable throwable) {
        Trace.logData(object, n, null, string, throwable);
    }

    public static final void log(int n, Throwable throwable) {
        if (throwable.getLocalizedMessage() == null) {
            Trace.log(n, "Exception does not contain a message.", throwable);
        } else {
            Trace.log(n, throwable.getLocalizedMessage(), throwable);
        }
    }

    public static final void log(Object object, int n, Throwable throwable) {
        if (throwable.getLocalizedMessage() == null) {
            Trace.log(object, n, "Exception does not contain a message.", throwable);
        } else {
            Trace.log(object, n, throwable.getLocalizedMessage(), throwable);
        }
    }

    public static final void log(int n, String string, int n2) {
        if (string == null) {
            string = "(null)";
        }
        Trace.log(n, string + "  " + n2);
    }

    public static final void log(int n, Object object, String string, int n2) {
        if (string == null) {
            string = "(null)";
        }
        Trace.log(n, object, string + "  " + n2);
    }

    public static final void log(int n, String string, String string2) {
        if (string == null) {
            string = "(null)";
        }
        Trace.log(n, string + "  " + (string2 == null ? "(null)" : string2));
    }

    public static final void log(Object object, int n, String string, int n2) {
        if (string == null) {
            string = "(null)";
        }
        Trace.log(object, n, string + "  " + n2);
    }

    static final void logSSL(int n, int n2, int n3, int n4) {
        Trace.log(2, "An SSLException occurred, turn on DIAGNOSITC tracing to see the details.");
        Trace.log(n, "SSL Category: " + n2);
        Trace.log(n, "SSL Error: " + n3);
        Trace.log(n, "SSL Int1: " + n4);
    }

    public static final void log(int n, String string, boolean bl) {
        if (string == null) {
            string = "(null)";
        }
        Trace.log(n, string + "  " + bl);
    }

    public static final void log(int n, Object object, String string, boolean bl) {
        if (string == null) {
            string = "(null)";
        }
        Trace.log(n, object, string + "  " + bl);
    }

    public static final void log(Object object, int n, String string, boolean bl) {
        if (string == null) {
            string = "(null)";
        }
        Trace.log(object, n, string + "  " + bl);
    }

    public static final void log(int n, String string, byte[] byArray) {
        if (byArray == null) {
            if (string == null) {
                string = "(null)";
            }
            Trace.log(n, string + "  " + "(null)");
        } else {
            Trace.log(n, string, byArray, 0, byArray.length);
        }
    }

    public static final void log(int n, Object object, String string, byte[] byArray) {
        if (byArray == null) {
            if (string == null) {
                string = "(null)";
            }
            Trace.log(n, object, string + "  " + "(null)");
        } else {
            Trace.log(n, object, string, byArray, 0, byArray.length);
        }
    }

    public static final void log(Object object, int n, String string, byte[] byArray) {
        if (byArray == null) {
            if (string == null) {
                string = "(null)";
            }
            Trace.log(object, n, string + "  " + "(null)");
        } else {
            Trace.log(object, n, string, byArray, 0, byArray.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void log(int n, String string, byte[] byArray, int n2, int n3) {
        if (traceOn_ && Trace.traceCategory(n) || Trace.findLogger() && logger_.isLoggable(n)) {
            if (logger_ == null || userSpecifiedDestination_) {
                PrintWriter printWriter = destination_;
                synchronized (printWriter) {
                    Trace.logTimeStamp(null, destination_);
                    if (string != null) {
                        destination_.println(string);
                    }
                    Trace.printByteArray(destination_, byArray, n2, n3);
                    if (n == 2) {
                        new Throwable().printStackTrace(destination_);
                    }
                }
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                Trace.logTimeStamp(null, stringBuffer);
                Trace.printByteArray(stringBuffer, byArray, n2, n3);
                if (n == 2) {
                    logger_.log(n, stringBuffer.toString(), new Throwable());
                } else {
                    logger_.log(n, stringBuffer.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void log(int n, Object object, String string, byte[] byArray, int n2, int n3) {
        if (traceOn_ && Trace.traceCategory(n) || Trace.findLogger() && logger_.isLoggable(n)) {
            if (logger_ == null || userSpecifiedDestination_) {
                PrintWriter printWriter = destination_;
                synchronized (printWriter) {
                    Trace.logTimeStamp(null, destination_);
                    Trace.logSource(object, destination_);
                    if (string != null) {
                        destination_.println(string);
                    }
                    Trace.printByteArray(destination_, byArray, n2, n3);
                    if (n == 2) {
                        new Throwable().printStackTrace(destination_);
                    }
                }
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                Trace.logTimeStamp(null, stringBuffer);
                Trace.logSource(object, stringBuffer);
                Trace.printByteArray(stringBuffer, byArray, n2, n3);
                if (n == 2) {
                    logger_.log(n, stringBuffer.toString(), new Throwable());
                } else {
                    logger_.log(n, stringBuffer.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void log(Object object, int n, String string, byte[] byArray, int n2, int n3) {
        if (string == null) {
            string = "(null)";
        }
        if (object == null) {
            throw new NullPointerException("component");
        }
        if (traceOn_ && Trace.traceCategory(n) || Trace.findLogger() && logger_.isLoggable(n)) {
            if (logger_ == null || userSpecifiedDestination_) {
                PrintWriter printWriter = (PrintWriter)printWriterHash_.get(object);
                if (printWriter == null) {
                    if (globalPw == null) {
                        globalPw = new PrintWriter(System.out, true);
                    }
                    printWriter = globalPw;
                    printWriterHash_.put(object, printWriter);
                }
                PrintWriter printWriter2 = printWriter;
                synchronized (printWriter2) {
                    Trace.logTimeStamp(object, printWriter);
                    printWriter.println(string);
                    Trace.printByteArray(printWriter, byArray, n2, n3);
                    if (n == 2) {
                        new Throwable().printStackTrace(printWriter);
                    }
                }
            }
            Trace.log(n, string, byArray, n2, n3);
        }
    }

    static void printByteArray(PrintWriter printWriter, byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        if (showChars_) {
            stringBuffer = new StringBuffer();
            stringBuffer2 = new StringBuffer();
        }
        if (byArray == null) {
            printWriter.println("(null)");
            return;
        }
        int n3 = 0;
        while (n3 < n2) {
            printWriter.print(Trace.toHexString(byArray[n]));
            printWriter.print(" ");
            if (stringBuffer != null && stringBuffer2 != null) {
                stringBuffer.append(Trace.toEbcdicString(byArray[n]));
                stringBuffer2.append(Trace.toAsciiString(byArray[n]));
            }
            if ((n3 & 0xF) == 15) {
                if (stringBuffer != null && stringBuffer2 != null) {
                    printWriter.print(" | ");
                    printWriter.print(stringBuffer.toString());
                    printWriter.print(" | ");
                    printWriter.print(stringBuffer2.toString());
                    printWriter.print(" |");
                    stringBuffer.setLength(0);
                    stringBuffer2.setLength(0);
                }
                printWriter.println();
            }
            ++n3;
            ++n;
        }
        if ((n2 - 1 & 0xF) != 15) {
            if (stringBuffer != null && stringBuffer2 != null) {
                int n4;
                for (n4 = n3 = n2 % 16; n4 < 16; ++n4) {
                    printWriter.print("   ");
                }
                printWriter.print(" | ");
                printWriter.print(stringBuffer.toString());
                for (n4 = n3; n4 < 16; ++n4) {
                    printWriter.print(" ");
                }
                printWriter.print(" | ");
                printWriter.print(stringBuffer2.toString());
                for (n4 = n3; n4 < 16; ++n4) {
                    printWriter.print(" ");
                }
                printWriter.print(" |");
                stringBuffer.setLength(0);
                stringBuffer2.setLength(0);
            }
            printWriter.println();
        }
    }

    static void printByteArray(StringBuffer stringBuffer, byte[] byArray) {
        Trace.printByteArray(stringBuffer, byArray, 0, byArray.length);
    }

    static void printByteArray(StringBuffer stringBuffer, byte[] byArray, int n, int n2) {
        if (byArray == null) {
            stringBuffer.append("(null)\n");
            return;
        }
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(Trace.toHexString(byArray[n]));
            stringBuffer.append(" ");
            if ((n3 & 0xF) == 15) {
                stringBuffer.append("\n");
            }
            ++n3;
            ++n;
        }
        if ((n2 - 1 & 0xF) != 15) {
            stringBuffer.append("\n");
        }
    }

    public static final String toHexString(byte by) {
        return HEX_BYTE_ARRAY[0xFF & by];
    }

    public static final String toAsciiString(byte by) {
        return ASCII_BYTE_ARRAY[0xFF & by];
    }

    public static final String toEbcdicString(byte by) {
        return EBCDIC_BYTE_ARRAY[0xFF & by];
    }

    public static final String toHexString(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("bytes");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(HEX_BYTE_ARRAY[0xFF & byArray[i]]);
        }
        return stringBuffer.toString();
    }

    public static void setTraceAllOn(boolean bl) {
        traceConversion_ = bl;
        traceDatastream_ = bl;
        traceDiagnostic_ = bl;
        traceError_ = bl;
        traceInfo_ = bl;
        traceJDBC_ = bl;
        tracePCML_ = bl;
        traceProxy_ = bl;
        traceThread_ = bl;
        traceWarning_ = bl;
        if (bl) {
            aTraceCategoryHasBeenActivated_ = true;
        }
        if (Trace.findLogger()) {
            logger_.setLevel();
        }
    }

    public static void setTraceConversionOn(boolean bl) {
        if (traceConversion_ != bl) {
            traceConversion_ = bl;
            if (bl) {
                aTraceCategoryHasBeenActivated_ = true;
            }
            if (Trace.findLogger()) {
                logger_.setLevel();
            }
        }
    }

    public static void setTraceDatastreamOn(boolean bl) {
        if (traceDatastream_ != bl) {
            traceDatastream_ = bl;
            if (bl) {
                aTraceCategoryHasBeenActivated_ = true;
            }
            if (Trace.findLogger()) {
                logger_.setLevel();
            }
        }
    }

    public static void setTraceDiagnosticOn(boolean bl) {
        if (traceDiagnostic_ != bl) {
            traceDiagnostic_ = bl;
            if (bl) {
                aTraceCategoryHasBeenActivated_ = true;
            }
            if (Trace.findLogger()) {
                logger_.setLevel();
            }
        }
    }

    public static void setTraceErrorOn(boolean bl) {
        if (traceError_ != bl) {
            traceError_ = bl;
            if (bl) {
                aTraceCategoryHasBeenActivated_ = true;
            }
            if (Trace.findLogger()) {
                logger_.setLevel();
            }
        }
    }

    public static synchronized void setFileName(String string) throws IOException {
        destination_.flush();
        if (fileName_ != null) {
            destination_.close();
        }
        if (string != null) {
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string, file.exists());
            destination_ = new PrintWriter(fileOutputStream, true);
            userSpecifiedDestination_ = true;
            fileName_ = string;
        } else {
            fileName_ = null;
            destination_ = new PrintWriter(System.out, true);
            userSpecifiedDestination_ = false;
        }
    }

    public static synchronized void setFileName(Object object, String string) throws IOException {
        String string2;
        if (object == null) {
            throw new NullPointerException("component");
        }
        PrintWriter printWriter = (PrintWriter)printWriterHash_.remove(object);
        if (printWriter != null) {
            printWriter.flush();
        }
        if ((string2 = (String)fileNameHash_.remove(object)) != null && printWriter != null) {
            printWriter.close();
        }
        if (string != null) {
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string, file.exists());
            fileNameHash_.put(object, string);
            printWriter = new PrintWriter(fileOutputStream, true);
            printWriterHash_.put(object, printWriter);
        } else {
            if (globalPw == null) {
                globalPw = new PrintWriter(System.out, true);
            }
            printWriter = globalPw;
            printWriterHash_.put(object, printWriter);
        }
    }

    public static synchronized void setPrintWriter(PrintWriter printWriter) throws IOException {
        destination_.flush();
        if (fileName_ != null) {
            destination_.close();
            fileName_ = null;
        }
        if (printWriter != null) {
            destination_ = printWriter;
            userSpecifiedDestination_ = true;
        } else {
            destination_ = new PrintWriter(System.out, true);
            userSpecifiedDestination_ = false;
        }
    }

    public static synchronized void setPrintWriter(Object object, PrintWriter printWriter) throws IOException {
        String string;
        if (object == null) {
            throw new NullPointerException("component");
        }
        PrintWriter printWriter2 = (PrintWriter)printWriterHash_.remove(object);
        if (printWriter2 != null) {
            printWriter2.flush();
        }
        if ((string = (String)fileNameHash_.remove(object)) != null) {
            printWriter2.close();
        }
        if (printWriter != null) {
            printWriter2 = printWriter;
        } else {
            if (globalPw == null) {
                globalPw = new PrintWriter(System.out, true);
            }
            printWriter2 = globalPw;
        }
        printWriterHash_.put(object, printWriter2);
    }

    public static void setTraceInformationOn(boolean bl) {
        if (traceInfo_ != bl) {
            traceInfo_ = bl;
            if (bl) {
                aTraceCategoryHasBeenActivated_ = true;
            }
            if (Trace.findLogger()) {
                logger_.setLevel();
            }
        }
    }

    public static void setTraceJDBCOn(boolean bl) {
        if (traceJDBC_ != bl) {
            traceJDBC_ = bl;
            if (bl) {
                aTraceCategoryHasBeenActivated_ = true;
            }
            if (Trace.findLogger()) {
                logger_.setLevel();
            }
        }
    }

    private static final boolean findLogger() {
        if (firstCallToFindLogger_) {
            firstCallToFindLogger_ = false;
            if (logger_ == null && JDK14_OR_HIGHER && (logger_ = ToolboxLogger.getLogger()) != null && logger_.isLoggingOn()) {
                logger_.info("Toolbox for Java - JDBC 3.0  Open Source Software, JTOpen 10.3 codebase 5770-SS1 V7R4M0.00 built=20200228 @AB4");
                logger_.info(Trace.getJvmInfo());
                if (mostRecentTracingChange_ != 2) {
                    traceOn_ = true;
                }
            }
        }
        return logger_ != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTraceOn(boolean bl) {
        if (traceOn_ != bl) {
            traceOn_ = bl;
            mostRecentTracingChange_ = bl ? 1 : 2;
            Trace.findLogger();
            if (traceOn_ && (logger_ == null || userSpecifiedDestination_)) {
                PrintWriter printWriter = destination_;
                synchronized (printWriter) {
                    destination_.println("Toolbox for Java - JDBC 3.0 Open Source Software, JTOpen 10.3 codebase 5770-SS1 V7R4M0.00 built=20200228 @AB4");
                    destination_.println(Trace.getJvmInfo());
                }
            }
            if (logger_ != null && aTraceCategoryHasBeenActivated_) {
                logger_.setLevel();
                logger_.config("Toolbox for Java - Open Source Software, JTOpen 10.3 codebase 5770-SS1 V7R4M0.00 built=20200228 @AB4");
            }
        }
    }

    private static String getJvmInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("java.home=");
        stringBuffer.append(System.getProperty("java.home"));
        stringBuffer.append(" java.vm.vendor=");
        stringBuffer.append(System.getProperty("java.vm.vendor"));
        stringBuffer.append(" java.vm.info=");
        stringBuffer.append(System.getProperty("java.vm.info"));
        stringBuffer.append(" java.runtime.version=");
        stringBuffer.append(System.getProperty("java.runtime.version"));
        stringBuffer.append(" java.fullversion=");
        stringBuffer.append(System.getProperty("java.fullversion"));
        stringBuffer.append(" java.vm.version=");
        stringBuffer.append(System.getProperty("java.vm.version"));
        stringBuffer.append(" java.version=");
        stringBuffer.append(System.getProperty("java.version"));
        stringBuffer.append(" os.name=");
        stringBuffer.append(System.getProperty("os.name"));
        stringBuffer.append(" os.version=");
        stringBuffer.append(System.getProperty("os.version"));
        return stringBuffer.toString();
    }

    public static void setTracePCMLOn(boolean bl) {
        if (tracePCML_ != bl) {
            tracePCML_ = bl;
            if (bl) {
                aTraceCategoryHasBeenActivated_ = true;
            }
            if (Trace.findLogger()) {
                logger_.setLevel();
            }
        }
    }

    public static void setTraceProxyOn(boolean bl) {
        if (traceProxy_ != bl) {
            traceProxy_ = bl;
            if (bl) {
                aTraceCategoryHasBeenActivated_ = true;
            }
            if (Trace.findLogger()) {
                logger_.setLevel();
            }
        }
    }

    public static void setTraceThreadOn(boolean bl) {
        if (traceThread_ != bl) {
            traceThread_ = bl;
            if (bl) {
                aTraceCategoryHasBeenActivated_ = true;
            }
            if (Trace.findLogger()) {
                logger_.setLevel();
            }
        }
    }

    public static void setTraceWarningOn(boolean bl) {
        if (traceWarning_ != bl) {
            traceWarning_ = bl;
            if (bl) {
                aTraceCategoryHasBeenActivated_ = true;
            }
            if (Trace.findLogger()) {
                logger_.setLevel();
            }
        }
    }

    private static boolean traceCategory(int n) {
        boolean bl = false;
        switch (n) {
            case 3: {
                bl = traceInfo_;
                break;
            }
            case 4: {
                bl = traceWarning_;
                break;
            }
            case 2: {
                bl = traceError_;
                break;
            }
            case 1: {
                bl = traceDiagnostic_;
                break;
            }
            case 0: {
                bl = traceDatastream_;
                break;
            }
            case 5: {
                bl = traceConversion_;
                break;
            }
            case 6: {
                bl = traceProxy_;
                break;
            }
            case 7: {
                bl = tracePCML_;
                break;
            }
            case 8: {
                bl = traceJDBC_;
                break;
            }
            default: {
                throw new ExtendedIllegalArgumentException("category (" + Integer.toString(n) + ")", 2);
            }
        }
        return bl;
    }

    private static void startTraceMonitorIfNeeded() {
        String string = SystemProperties.getProperty("com.ibm.as400.access.Trace.monitor");
        if (string == null) {
            return;
        }
        if (Boolean.valueOf(string).equals(Boolean.TRUE)) {
            try {
                Thread thread = new Thread((Runnable)new Trace(), "Toolbox Trace Monitor");
                thread.setDaemon(true);
                thread.start();
            }
            catch (Exception exception) {
                System.err.println("Failed to start trace monitor: " + exception.getMessage());
                exception.printStackTrace(System.err);
            }
        }
    }

    private static String handleTraceStatusChange(String string) {
        int n = string.indexOf(61);
        if (n < 0) {
            String string2 = "Invalid trace command: " + string;
            System.err.println(string2);
            Trace.logData(null, 2, string2, null);
            return string2;
        }
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + 1);
        if (string4.length() == 0) {
            string4 = null;
        }
        if (string3.equals("com.ibm.as400.access.Trace.category")) {
            Trace.setTraceCategories(string4);
        } else if (string3.equals("com.ibm.as400.access.Trace.file")) {
            if (string4 == null || !string4.equals(fileName_)) {
                try {
                    Trace.setFileName(string4);
                }
                catch (IOException iOException) {
                    String string5 = "Failed to set file name to " + string4 + ": " + iOException.getMessage();
                    System.err.println(string5);
                    iOException.printStackTrace(System.err);
                    return string5;
                }
            }
        } else {
            return "Unrecognized command: " + string;
        }
        return "Command processed: " + string;
    }

    public void run() {
        int n;
        Object object;
        try {
            object = SystemProperties.getProperty("com.ibm.as400.access.Trace.monitorPort");
            n = object != null ? Integer.parseInt((String)object) : 55555;
        }
        catch (Exception exception) {
            System.err.println("Failed to get TRACE_MONITOR_PORT property: " + exception.getMessage());
            exception.printStackTrace(System.err);
            return;
        }
        try {
            object = new ServerSocket(n, 1);
            while (true) {
                Socket socket = ((ServerSocket)object).accept();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
                String string = bufferedReader.readLine();
                if (string != null) {
                    String string2 = Trace.handleTraceStatusChange(string);
                    printWriter.println(string2);
                }
                socket.close();
            }
        }
        catch (Exception exception) {
            System.err.println("Exception in trace monitor daemon: " + exception.getMessage());
            exception.printStackTrace(System.err);
            return;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 3) {
            Trace.printUsage();
        } else {
            int n = 0;
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (Exception exception) {
                System.err.println("Invalid port specified (" + stringArray[1] + ")");
                exception.printStackTrace(System.err);
                return;
            }
            try {
                for (int i = 2; i < stringArray.length; ++i) {
                    Socket socket = new Socket(stringArray[0], n);
                    PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    printWriter.println(stringArray[i]);
                    String string = bufferedReader.readLine();
                    System.out.println(string);
                    socket.close();
                }
            }
            catch (UnknownHostException unknownHostException) {
                System.err.println("Host " + stringArray[0] + " is not known.");
                unknownHostException.printStackTrace(System.err);
            }
            catch (Exception exception) {
                System.err.println("Exception contacting trace monitor: " + exception.getMessage());
                exception.printStackTrace(System.err);
            }
        }
    }

    private static void printUsage() {
        System.out.println();
        System.out.println("Usage:  java com.ibm.as400.access.Trace [systemName] [monitorPort] [traceCommands]");
        System.out.println();
        System.out.println("  This assumes that the target JVM (the JVM in which the application of interest is running) has been started with the following Java system properties set: ");
        System.out.println("     com.ibm.as400.access.Trace.monitor=true     [REQUIRED]");
        System.out.println("     com.ibm.as400.access.Trace.monitorPort=xxx  [OPTIONAL]");
        System.out.println("");
        System.out.println("  If [monitorPort] is not specified, the monitor port number is set to 55555");
        System.out.println("");
        System.out.println("  [traceCommands] is one or more of (separated by spaces):");
        System.out.println("     com.ibm.as400.access.Trace.category=[listOfCategories]");
        System.out.println("        listOfCategories is a comma-delimited list of valid Toolbox trace categories");
        System.out.println();
        System.out.println("Example invocation:  java com.ibm.as400.access.Trace mysystem 55555 com.ibm.as400.access.Trace.category=error,warning com.ibm.as400.access.Trace.file=/tmp/out.txt");
    }

    private static void setTraceCategories(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ;");
            if (!stringTokenizer.hasMoreTokens()) {
                Trace.setTraceOn(false);
            } else {
                Trace.setTraceOn(true);
            }
            Trace.setTraceAllOn(false);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equalsIgnoreCase("datastream")) {
                    Trace.setTraceDatastreamOn(true);
                    continue;
                }
                if (string2.equalsIgnoreCase("diagnostic")) {
                    Trace.setTraceDiagnosticOn(true);
                    continue;
                }
                if (string2.equalsIgnoreCase("error")) {
                    Trace.setTraceErrorOn(true);
                    continue;
                }
                if (string2.equalsIgnoreCase("information")) {
                    Trace.setTraceInformationOn(true);
                    continue;
                }
                if (string2.equalsIgnoreCase("warning")) {
                    Trace.setTraceWarningOn(true);
                    continue;
                }
                if (string2.equalsIgnoreCase("conversion")) {
                    Trace.setTraceConversionOn(true);
                    continue;
                }
                if (string2.equalsIgnoreCase("proxy")) {
                    Trace.setTraceProxyOn(true);
                    continue;
                }
                if (string2.equalsIgnoreCase("thread")) {
                    Trace.setTraceThreadOn(true);
                    continue;
                }
                if (string2.equalsIgnoreCase("jdbc")) {
                    Trace.setTraceJDBCOn(true);
                    continue;
                }
                if (string2.equalsIgnoreCase("pcml")) {
                    Trace.setTracePCMLOn(true);
                    continue;
                }
                if (string2.equalsIgnoreCase("all")) {
                    Trace.setTraceAllOn(true);
                    continue;
                }
                if (string2.equalsIgnoreCase("none")) {
                    Trace.setTraceOn(false);
                    continue;
                }
                if (!Trace.isTraceOn()) continue;
                Trace.log(4, "Trace category not valid: " + string2);
            }
        } else {
            Trace.setTraceOn(false);
        }
    }

    static int activeTraceCategory() {
        if (traceError_) {
            return 2;
        }
        if (traceWarning_) {
            return 4;
        }
        if (traceInfo_) {
            return 3;
        }
        if (traceDiagnostic_) {
            return 1;
        }
        if (traceDatastream_) {
            return 0;
        }
        if (traceConversion_) {
            return 5;
        }
        if (traceProxy_) {
            return 6;
        }
        if (traceJDBC_) {
            return 8;
        }
        if (tracePCML_) {
            return 7;
        }
        return -1;
    }

    static {
        showChars_ = false;
        aTraceCategoryHasBeenActivated_ = false;
        fileName_ = null;
        destination_ = new PrintWriter(System.out, true);
        userSpecifiedDestination_ = false;
        printWriterHash_ = new Hashtable();
        fileNameHash_ = new Hashtable();
        timeStampFormatter_ = new SimpleDateFormat("EEE MMM d HH:mm:ss:SSS z yyyy");
        logger_ = null;
        firstCallToFindLogger_ = true;
        globalPw = null;
        try {
            Class.forName("java.util.logging.LogManager");
            JDK14_OR_HIGHER = true;
        }
        catch (Throwable throwable) {
            JDK14_OR_HIGHER = false;
        }
        Trace.loadTraceProperties();
        HEX_BYTE_ARRAY = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "8A", "8B", "8C", "8D", "8E", "8F", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "9A", "9B", "9C", "9D", "9E", "9F", "A0", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "AA", "AB", "AC", "AD", "AE", "AF", "B0", "B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "B9", "BA", "BB", "BC", "BD", "BE", "BF", "C0", "C1", "C2", "C3", "C4", "C5", "C6", "C7", "C8", "C9", "CA", "CB", "CC", "CD", "CE", "CF", "D0", "D1", "D2", "D3", "D4", "D5", "D6", "D7", "D8", "D9", "DA", "DB", "DC", "DD", "DE", "DF", "E0", "E1", "E2", "E3", "E4", "E5", "E6", "E7", "E8", "E9", "EA", "EB", "EC", "ED", "EE", "EF", "F0", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "FA", "FB", "FC", "FD", "FE", "FF"};
        ASCII_BYTE_ARRAY = new String[]{".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", " ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "<", "=", ">", "?", "@", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "[", "\\", "]", "^", "_", "`", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "{", "|", "}", "~", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", "."};
        EBCDIC_BYTE_ARRAY = new String[]{".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", "[", ".", "<", "(", "+", "!", "&", ".", ".", ".", ".", ".", ".", ".", ".", ".", "]", "$", "*", ")", ";", "^", "-", "/", ".", ".", ".", ".", ".", ".", ".", ".", "|", ",", "%", "_", ">", "?", ".", ".", ".", ".", ".", ".", ".", ".", ".", "`", ":", "#", "@", "'", "=", "\"", ".", "a", "b", "c", "d", "e", "f", "g", "h", "i", ".", ".", ".", ".", ".", ".", ".", "j", "k", "l", "m", "n", "o", "p", "q", "r", ".", ".", ".", ".", ".", ".", ".", ".", "s", "t", "u", "v", "w", "x", "y", "z", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", ".", "{", "A", "B", "C", "D", "E", "F", "G", "H", "I", ".", ".", ".", ".", ".", ".", "}", "J", "K", "L", "M", "N", "O", "P", "Q", "R", ".", ".", ".", ".", ".", ".", "\\", ".", "S", "T", "U", "V", "W", "X", "Y", "Z", ".", ".", ".", ".", ".", ".", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ".", ".", ".", ".", ".", "."};
    }
}

