/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.access.Trace;
import com.ibm.as400.util.commtrace.BitBuf;
import com.ibm.as400.util.commtrace.Data;
import com.ibm.as400.util.commtrace.Dec;
import com.ibm.as400.util.commtrace.Field;
import com.ibm.as400.util.commtrace.FormatProperties;
import com.ibm.as400.util.commtrace.Formatter;
import com.ibm.as400.util.commtrace.Header;
import com.ibm.as400.util.commtrace.Hex;

public class ICMP4Header
extends Header {
    Field typefield;
    Field code;
    Field checksum;
    private static final String CLASS = "ICMP4Header";
    private static final String ECHRPLY = "Echo Reply";
    private static final String DSTURCH = "Destination Unreachable";
    private static final String SRCQCH = "Source Quench";
    private static final String RDR = "Redirect (Change a Route)";
    private static final String ECHREQ = "Echo Request";
    private static final String TIMEEXC = "Time Exceeded for a Datagram";
    private static final String PARAMPROB = "Parameter Problem on a Datagram";
    private static final String TSTMPREQ = "Timestamp Request";
    private static final String TSTMPRPLY = "Timestamp Reply";
    private static final String INFOREQ = "Information Request (Obsolete)";
    private static final String INFORPLY = "Information Reply (Obsolete)";
    private static final String ADDRREQ = "Address Mask Request";
    private static final String ADDRRPLY = "Address Mask Reply";
    private static final String ICMP = "ICMPv4 Header";
    private static final String TYPE = "Type";
    private static final String CODE = "Code";
    private static final String CHKSUM = "Checksum";

    ICMP4Header(BitBuf bitBuf) {
        super(bitBuf);
        this.typefield = new Dec(this.rawheader.slice(0, 8));
        this.code = new Hex(this.rawheader.slice(8, 8));
        this.checksum = new Hex(this.rawheader.slice(16, 16));
        this.type = 1;
    }

    public int getHeaderLen() {
        return 32;
    }

    public String toString(FormatProperties formatProperties) {
        String string = "";
        int n = Integer.parseInt(this.typefield.toString());
        if (this.rawheader.getBitSize() < this.getHeaderLen()) {
            return new Data(this.rawheader).toString();
        }
        if (formatProperties != null) {
            boolean bl = false;
            String string2 = formatProperties.getPort();
            if (string2 == null) {
                bl = true;
            }
            if (!bl) {
                if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                    Trace.log(3, "ICMP4Header.toString() Frame doesn't pass IP filter");
                }
                return "";
            }
        }
        if (n == 0) {
            string = ECHRPLY;
        } else if (n == 3) {
            string = DSTURCH;
        } else if (n == 4) {
            string = SRCQCH;
        } else if (n == 5) {
            string = RDR;
        } else if (n == 8) {
            string = ECHREQ;
        } else if (n == 11) {
            string = TIMEEXC;
        } else if (n == 12) {
            string = PARAMPROB;
        } else if (n == 13) {
            string = TSTMPREQ;
        } else if (n == 14) {
            string = TSTMPRPLY;
        } else if (n == 15) {
            string = INFOREQ;
        } else if (n == 16) {
            string = INFORPLY;
        } else if (n == 17) {
            string = ADDRREQ;
        } else if (n == 18) {
            string = ADDRRPLY;
        }
        Object[] objectArray = new Object[]{string, this.code, this.checksum};
        return Formatter.jsprintf("\t    ICMPv4 Header : Type: {0}     Code: {1}     Checksum: {2}\n", objectArray) + this.printHexHeader() + this.printnext(formatProperties) + new Data(this.rawpayload).toString();
    }

    public String getTypeField() {
        return this.typefield.toString();
    }

    public String getCode() {
        return new Dec(this.code.getData()).toString();
    }

    public String getChecksum() {
        return new Dec(this.checksum.getData()).toString();
    }
}

