/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.util.commtrace.BitBuf;
import com.ibm.as400.util.commtrace.Char;
import com.ibm.as400.util.commtrace.Dec;
import com.ibm.as400.util.commtrace.Field;
import com.ibm.as400.util.commtrace.FormatProperties;
import com.ibm.as400.util.commtrace.Formatter;
import com.ibm.as400.util.commtrace.ResourceBundleLoader_ct;
import com.ibm.as400.util.commtrace.Time;
import java.util.Date;
import java.util.GregorianCalendar;

public class Prolog {
    private BitBuf data;
    private boolean invalidData = false;
    private String IPaddr = null;
    private String IPaddr2 = null;
    private String fmtBroadcast = "Y";
    private String date = null;
    private static String ALL_ = "*ALL";
    private static String NO_ = "*NO";
    private Field ctsftrcd;
    private Field ctsfndob;
    private Field ctsfotyp;
    private Field ctsfpro;
    private Field ctsfbuff;
    private Field ctsfdatd;
    private Field ctsfstpf;
    private Field ctsfstrb;
    private Field ctsfendb;
    private Field ctsfctln;
    private Field ctsfusrd;
    private Field ctsffilt;
    private Field ctsfrctl;
    private Field ctsfrmac;
    private Field ctsfrsap;
    private Field ctsflsap;
    private Field ctsfipv6;
    private Field ctsfipv4;
    private Field ctsfipid;
    private Field ctsflmid;
    private Field ctsfsts;
    private Field ctsfsttm;
    private Field ctsfsptm;
    private Field ctsfbyts;
    private Field ctsfrecs;
    private Field ctsfmxpt;
    private Field ctsfmxdf;
    private Field ctsfchls;
    private Field ctsfbwrp;
    private Field ctsfrect;
    private Field ctsfdtyp;
    private String PTITLE;
    private String PTRACDES;
    private String PCFGOBJ;
    private String POTYPE;
    private String POTYPEH;
    private String POBJPROT;
    private String PSTRTIME;
    private String PENDTIME;
    private String PBYTECOL;
    private String PBUFSIZ;
    private String PBUFSIZH;
    private String PDATDIR;
    private String PDATDIRH;
    private String PBUFWRP;
    private String PBUFWRPH;
    private String PBYTES;
    private String PBYTESB;
    private String PBYTESBH;
    private String PBYTESE;
    private String PBYTESEH;
    private String PFORMAT;
    private String PCDNAME;
    private String PCDNAMEH;
    private String PDATTYP;
    private String PDATTYPH;
    private String PFMTTCP;
    private String PIPADDR;
    private String PIPADDRH;
    private String PIPPORT;
    private String PIPPORTH;
    private String PETHDAT;
    private String PETHDATH;
    private String PBDCAST;
    private String PFMTOH;
    private String PRMTCD;
    private String PRMTMAC;
    private String PRMTSAP;
    private String PLCLSAP;
    private String PPIPID;
    private String PRMTIP;
    private String PRMTALLH;
    private static final String ETH = "ETHERNET";
    private static final String TOKEN = "TOKENRING";
    private static final String CALC = "*CALC";

    Prolog(BitBuf bitBuf, FormatProperties formatProperties) {
        this.data = bitBuf;
        String string = formatProperties.getIPAddress();
        this.IPaddr = string == null ? ALL_ : string;
        String string2 = formatProperties.getSecondIPAddress();
        this.IPaddr2 = string2 == null ? ALL_ : string2;
        String string3 = formatProperties.getBroadcast();
        this.fmtBroadcast = string3 == null ? NO_ : string3;
        this.parseData();
    }

    private void parseData() {
        this.PTITLE = ResourceBundleLoader_ct.getText("PTITLE");
        this.PTRACDES = ResourceBundleLoader_ct.getText("PTRACDES");
        this.PCFGOBJ = ResourceBundleLoader_ct.getText("PCFGOBJ");
        this.POTYPE = ResourceBundleLoader_ct.getText("POTYPE");
        this.POTYPEH = ResourceBundleLoader_ct.getText("POTYPEH");
        this.POBJPROT = ResourceBundleLoader_ct.getText("POBJPROT");
        this.PSTRTIME = ResourceBundleLoader_ct.getText("PSTRTIME");
        this.PENDTIME = ResourceBundleLoader_ct.getText("PENDTIME");
        this.PBYTECOL = ResourceBundleLoader_ct.getText("PBYTECOL");
        this.PBUFSIZ = ResourceBundleLoader_ct.getText("PBUFSIZ");
        this.PBUFSIZH = ResourceBundleLoader_ct.getText("PBUFSIZH");
        this.PDATDIR = ResourceBundleLoader_ct.getText("PDATDIR");
        this.PDATDIRH = ResourceBundleLoader_ct.getText("PDATDIRH");
        this.PBUFWRP = ResourceBundleLoader_ct.getText("PBUFWRP");
        this.PBUFWRPH = ResourceBundleLoader_ct.getText("PBUFWRPH");
        this.PBYTES = ResourceBundleLoader_ct.getText("PBYTES");
        this.PBYTESB = ResourceBundleLoader_ct.getText("PBYTESB");
        this.PBYTESBH = ResourceBundleLoader_ct.getText("PBYTESBH");
        this.PBYTESE = ResourceBundleLoader_ct.getText("PBYTESE");
        this.PBYTESEH = ResourceBundleLoader_ct.getText("PBYTESEH");
        this.PFORMAT = ResourceBundleLoader_ct.getText("PFORMAT");
        this.PCDNAME = ResourceBundleLoader_ct.getText("PCDNAME");
        this.PCDNAMEH = ResourceBundleLoader_ct.getText("PCDNAMEH");
        this.PDATTYP = ResourceBundleLoader_ct.getText("PDATTYP");
        this.PDATTYPH = ResourceBundleLoader_ct.getText("PDATTYPH");
        this.PFMTTCP = ResourceBundleLoader_ct.getText("PFMTTCP");
        this.PIPADDR = ResourceBundleLoader_ct.getText("PIPADDR");
        this.PIPADDRH = ResourceBundleLoader_ct.getText("PIPADDRH");
        this.PIPPORT = ResourceBundleLoader_ct.getText("PIPPORT");
        this.PIPPORTH = ResourceBundleLoader_ct.getText("PIPPORTH");
        this.PETHDAT = ResourceBundleLoader_ct.getText("PETHDAT");
        this.PETHDATH = ResourceBundleLoader_ct.getText("PETHDATH");
        this.PBDCAST = ResourceBundleLoader_ct.getText("PBDCAST");
        this.PFMTOH = ResourceBundleLoader_ct.getText("PFMTOH");
        this.PRMTCD = ResourceBundleLoader_ct.getText("PRMTCD");
        this.PRMTMAC = ResourceBundleLoader_ct.getText("PRMTMAC");
        this.PRMTSAP = ResourceBundleLoader_ct.getText("PRMTSAP");
        this.PLCLSAP = ResourceBundleLoader_ct.getText("PLCLSAP");
        this.PPIPID = ResourceBundleLoader_ct.getText("PPIPID");
        this.PRMTIP = ResourceBundleLoader_ct.getText("PRMTIP");
        this.PRMTALLH = ResourceBundleLoader_ct.getText("PRMTALLH");
        this.ctsftrcd = new Char(this.data.slice(0, 160));
        this.ctsfndob = new Char(this.data.slice(160, 80));
        this.ctsfotyp = new Char(this.data.slice(240, 8));
        this.ctsfpro = new Char(this.data.slice(248, 8));
        this.ctsfbuff = new Dec(this.data.slice(480, 32));
        this.ctsfdatd = new Char(this.data.slice(512, 8));
        this.ctsfstpf = new Char(this.data.slice(520, 8));
        this.ctsfstrb = new Dec(this.data.slice(528, 16));
        this.ctsfendb = new Dec(this.data.slice(544, 16));
        this.ctsfctln = new Char(this.data.slice(560, 80));
        this.ctsfusrd = new Char(this.data.slice(640, 8));
        this.ctsffilt = new Char(this.data.slice(648, 8));
        this.ctsfrctl = new Char(this.data.slice(656, 80));
        this.ctsfrmac = new Char(this.data.slice(736, 48));
        this.ctsfrsap = new Char(this.data.slice(784, 16));
        this.ctsflsap = new Char(this.data.slice(800, 16));
        this.ctsfipv6 = new Dec(this.data.slice(832, 16));
        this.ctsfipv4 = new Dec(this.data.slice(960, 32));
        this.ctsfipid = new Dec(this.data.slice(992, 16));
        this.ctsflmid = new Char(this.data.slice(1008, 8));
        this.ctsfsts = new Char(this.data.slice(1488, 32));
        this.ctsfsttm = new Dec(this.data.slice(1520, 64));
        this.ctsfsptm = new Dec(this.data.slice(1584, 64));
        this.ctsfbyts = new Dec(this.data.slice(1664, 32));
        this.ctsfrecs = new Dec(this.data.slice(1696, 32));
        this.ctsfmxpt = new Dec(this.data.slice(1728, 16));
        this.ctsfmxdf = new Dec(this.data.slice(1744, 16));
        this.ctsfchls = new Dec(this.data.slice(1760, 16));
        this.ctsfbwrp = new Char(this.data.slice(1776, 8));
        this.ctsfrect = new Char(this.data.slice(1784, 8));
        this.ctsfdtyp = new Char(this.data.slice(1792, 8));
    }

    public int getNumRecs() {
        return Integer.parseInt(this.ctsfrecs.toString());
    }

    public String getTitle() {
        return this.PTITLE;
    }

    public String getDate() {
        return this.date;
    }

    public boolean invalidData() {
        return this.invalidData;
    }

    public int getNumBytes() {
        return Integer.parseInt(this.ctsfbyts.toString());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256000);
        String string = this.ctsfpro.toString();
        if (string.equals("E") || string.equals("C")) {
            stringBuffer.append(this.PTITLE + "\n");
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(new Date(System.currentTimeMillis()));
            this.date = gregorianCalendar.getTime().toString() + "\n";
            stringBuffer.append(this.date);
            String string2 = string.equals("C") ? ETH : TOKEN;
            Object[] objectArray = new Object[]{this.ctsftrcd, this.ctsfndob, this.ctsfotyp, string2};
            stringBuffer.append(Formatter.jsprintf(this.PTRACDES + "    {0,20,L}\n" + this.PCFGOBJ + "    {1,10,L}\n" + this.POTYPE + "    {2,13,L}" + this.POTYPEH + "\n" + this.POBJPROT + "    {3,13,L}\n", objectArray));
            stringBuffer.append(this.PSTRTIME);
            Time time = new Time(Long.parseLong(this.ctsfsttm.toString()));
            stringBuffer.append("    " + time.toString() + "\n");
            stringBuffer.append(this.PENDTIME);
            Time time2 = new Time(Long.parseLong(this.ctsfsptm.toString()));
            stringBuffer.append("    " + time2.toString() + "\n");
            String string3 = this.ctsfstrb.toString();
            String string4 = this.ctsfendb.toString();
            if (string3.equals("0") || string3.equals("100")) {
                string3 = CALC;
            }
            if (string4.equals("0")) {
                string4 = CALC;
            }
            Object[] objectArray2 = new Object[]{this.ctsfbyts, this.ctsfbuff, this.ctsfdatd, this.ctsfstpf, string3, string4, CALC, "Y", this.IPaddr, this.IPaddr2, ALL_, this.fmtBroadcast};
            stringBuffer.append(Formatter.jsprintf(this.PBYTECOL + "    {0,13,L}\n" + this.PBUFSIZ + "    {1,13,L}" + this.PBUFSIZH + "\n" + this.PDATDIR + "    {2,13,L}" + this.PDATDIRH + "\n" + this.PBUFWRP + "    {3,13,L}" + this.PBUFWRPH + "\n" + this.PBYTES + "\n" + this.PBYTESB + "    {4,13,L}" + this.PBYTESBH + "\n" + this.PBYTESE + "    {5,13,L}" + this.PBYTESEH + "\n" + this.PFORMAT + "\n" + this.PDATTYP + "    {6,13,L}" + this.PDATTYPH + "\n" + this.PFMTTCP + "    {7,13,L}" + this.PFMTOH + "\n" + this.PIPADDR + "    {8,13,L}" + this.PIPADDRH + "\n" + this.PIPADDR + "    {9,13,L}" + this.PIPADDRH + "\n" + this.PIPPORT + "    {10,13,L}" + this.PIPADDRH + "\n" + this.PBDCAST + "    {11,13,L}" + this.PFMTOH + "\n", objectArray2));
        } else {
            stringBuffer.append(ResourceBundleLoader_ct.getText("NotSupported"));
            this.invalidData = true;
        }
        return stringBuffer.toString();
    }

    public String getTraceDescription() {
        return this.ctsftrcd.toString();
    }

    public String getNDObject() {
        return this.ctsfndob.toString();
    }

    public String getObjectType() {
        return this.ctsfotyp.toString();
    }

    public String getProtocol() {
        return this.ctsfpro.toString();
    }

    public String getBuffSize() {
        return this.ctsfbuff.toString();
    }

    public String getDataDirection() {
        return this.ctsfdatd.toString();
    }

    public String getStopFull() {
        return this.ctsfstpf.toString();
    }

    public String getStartBytes() {
        return this.ctsfstrb.toString();
    }

    public String getEndingBytes() {
        return this.ctsfendb.toString();
    }

    public String getControllerName() {
        return this.ctsfctln.toString();
    }

    public String getUserData() {
        return this.ctsfusrd.toString();
    }

    public String getLANFilter() {
        return this.ctsffilt.toString();
    }

    public String getRmtContName() {
        return this.ctsfrmac.toString();
    }

    public String getRmtMacAddr() {
        return this.ctsfrmac.toString();
    }

    public String getRmtSAP() {
        return this.ctsfrsap.toString();
    }

    public String getLocalSAP() {
        return this.ctsflsap.toString();
    }

    public String getFilterIPv6() {
        return this.ctsfipv6.toString();
    }

    public String getIPv4() {
        return this.ctsfipv4.toString();
    }

    public String getIPID() {
        return this.ctsfipid.toString();
    }

    public String getLMIData() {
        return this.ctsflmid.toString();
    }

    public String getStatus() {
        return this.ctsfsts.toString();
    }

    public String getStartTime() {
        return this.ctsfsttm.toString();
    }

    public String getStopTime() {
        return this.ctsfsptm.toString();
    }

    public String getBytesCollected() {
        return this.ctsfbyts.toString();
    }

    public String getMaxFrameProtocol() {
        return this.ctsfmxpt.toString();
    }

    public String getMaxFrameUser() {
        return this.ctsfmxdf.toString();
    }

    public String getChannels() {
        return this.ctsfchls.toString();
    }

    public String getBufferWrap() {
        return this.ctsfbwrp.toString();
    }

    public String getRecTimer() {
        return this.ctsfmxpt.toString();
    }

    public String getType() {
        return this.ctsfdtyp.toString();
    }
}

