/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BaseDataQueueImpl;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.DataQueueEvent;
import com.ibm.as400.access.DataQueueListener;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ObjectEvent;
import com.ibm.as400.access.ObjectListener;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public abstract class BaseDataQueue
implements Serializable {
    private static final String CLASSNAME = "com.ibm.as400.access.BaseDataQueue";
    static final long serialVersionUID = 4L;
    private AS400 system_ = null;
    private String path_ = "";
    private String library_ = "";
    private String name_ = "";
    private int ccsid_ = 0;
    private transient Converter dataConverter_ = null;
    int maxEntryLength_ = 0;
    boolean saveSenderInformation_ = false;
    boolean FIFO_ = false;
    boolean forceToAuxiliaryStorage_ = false;
    String description_ = null;
    boolean attributesRetrieved_ = false;
    transient BaseDataQueueImpl impl_ = null;
    transient Vector dataQueueListeners_ = null;
    transient Vector objectListeners_ = null;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private transient VetoableChangeSupport vetoableChangeListeners_ = null;

    public BaseDataQueue() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing BaseDataQueue object.");
        }
    }

    public BaseDataQueue(AS400 aS400, String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing BaseDataQueue object, system: " + aS400 + " path: " + string);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'path' is null.");
            throw new NullPointerException("path");
        }
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, "DTAQ");
        this.library_ = qSYSObjectPathName.getLibraryName();
        this.name_ = qSYSObjectPathName.getObjectName();
        this.path_ = string;
        this.system_ = aS400;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataQueueListener(DataQueueListener dataQueueListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding data queue listener.");
        }
        if (dataQueueListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        BaseDataQueue baseDataQueue = this;
        synchronized (baseDataQueue) {
            if (this.dataQueueListeners_ == null) {
                this.dataQueueListeners_ = new Vector();
            }
            this.dataQueueListeners_.addElement(dataQueueListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObjectListener(ObjectListener objectListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding object listener.");
        }
        if (objectListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        BaseDataQueue baseDataQueue = this;
        synchronized (baseDataQueue) {
            if (this.objectListeners_ == null) {
                this.objectListeners_ = new Vector();
            }
            this.objectListeners_.addElement(objectListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        BaseDataQueue baseDataQueue = this;
        synchronized (baseDataQueue) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        BaseDataQueue baseDataQueue = this;
        synchronized (baseDataQueue) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    synchronized void open() throws AS400SecurityException, IOException {
        boolean bl = this.impl_ == null;
        this.chooseImpl();
        if (bl) {
            this.fireObjectEvent(3);
        }
    }

    synchronized void chooseImpl() throws AS400SecurityException, IOException {
        if (this.system_ != null) {
            this.system_.signon(false);
        }
        if (this.impl_ == null) {
            if (this.system_ == null) {
                Trace.log(2, "Cannot connect to data queue server before setting system.");
                throw new ExtendedIllegalStateException("system", 4);
            }
            if (this.path_.length() == 0) {
                Trace.log(2, "Cannot connect to data queue server before setting path.");
                throw new ExtendedIllegalStateException("path", 4);
            }
            this.impl_ = (BaseDataQueueImpl)this.system_.loadImpl3("com.ibm.as400.access.BaseDataQueueImplNative", "com.ibm.as400.access.BaseDataQueueImplRemote", "com.ibm.as400.access.BaseDataQueueImplProxy");
            this.impl_.setSystemAndPath(this.system_.getImpl(), this.path_, this.name_, this.library_);
        }
    }

    public void clear() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Clearing data queue.");
        }
        this.open();
        this.impl_.clear(null);
        this.fireDataQueueEvent(0);
    }

    public void delete() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Deleting data queue.");
        }
        this.chooseImpl();
        this.impl_.delete();
        this.attributesRetrieved_ = false;
        this.fireObjectEvent(2);
    }

    public boolean exists() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking data queue existence.");
        }
        this.attributesRetrieved_ = false;
        try {
            this.getMaxEntryLength();
            return true;
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            return false;
        }
    }

    void fireDataQueueEvent(int n) {
        if (this.dataQueueListeners_ == null) {
            return;
        }
        Vector vector = (Vector)this.dataQueueListeners_.clone();
        DataQueueEvent dataQueueEvent = new DataQueueEvent(this, n);
        block6: for (int i = 0; i < vector.size(); ++i) {
            DataQueueListener dataQueueListener = (DataQueueListener)vector.elementAt(i);
            switch (n) {
                case 0: {
                    dataQueueListener.cleared(dataQueueEvent);
                    continue block6;
                }
                case 1: {
                    dataQueueListener.peeked(dataQueueEvent);
                    continue block6;
                }
                case 2: {
                    dataQueueListener.read(dataQueueEvent);
                    continue block6;
                }
                case 3: {
                    dataQueueListener.written(dataQueueEvent);
                }
            }
        }
    }

    void fireObjectEvent(int n) {
        if (this.objectListeners_ == null) {
            return;
        }
        Vector vector = (Vector)this.objectListeners_.clone();
        ObjectEvent objectEvent = new ObjectEvent(this);
        block5: for (int i = 0; i < vector.size(); ++i) {
            ObjectListener objectListener = (ObjectListener)vector.elementAt(i);
            switch (n) {
                case 1: {
                    objectListener.objectCreated(objectEvent);
                    continue block5;
                }
                case 2: {
                    objectListener.objectDeleted(objectEvent);
                    continue block5;
                }
                case 3: {
                    objectListener.objectOpened(objectEvent);
                }
            }
        }
    }

    public int getCcsid() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting CCSID:", this.ccsid_);
        }
        return this.ccsid_;
    }

    public String getDescription() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting description.");
        }
        this.open();
        if (!this.attributesRetrieved_) {
            this.retrieveAttributes();
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Description: " + this.description_);
        }
        return this.description_;
    }

    public boolean getForceToAuxiliaryStorage() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting force to auxiliary storage.");
        }
        this.open();
        if (!this.attributesRetrieved_) {
            this.retrieveAttributes();
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Force to auxiliary storage:", this.forceToAuxiliaryStorage_);
        }
        return this.forceToAuxiliaryStorage_;
    }

    public int getMaxEntryLength() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting max entry length.");
        }
        this.open();
        if (!this.attributesRetrieved_) {
            this.retrieveAttributes();
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Max entry length:", this.maxEntryLength_);
        }
        return this.maxEntryLength_;
    }

    public String getName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting name: " + this.name_);
        }
        return this.name_;
    }

    public String getPath() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting path: " + this.path_);
        }
        return this.path_;
    }

    public boolean getSaveSenderInformation() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting save sender information.");
        }
        this.open();
        if (!this.attributesRetrieved_) {
            this.retrieveAttributes();
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Save sender information:", this.saveSenderInformation_);
        }
        return this.saveSenderInformation_;
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    public boolean isFIFO() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if data queue is FIFO.");
        }
        this.open();
        if (!this.attributesRetrieved_) {
            this.retrieveAttributes();
        }
        if (Trace.traceOn_) {
            Trace.log(1, "FIFO:", this.FIFO_);
        }
        return this.FIFO_;
    }

    public void refreshAttributes() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Refreshing data queue attributes.");
        }
        this.attributesRetrieved_ = false;
        this.open();
        this.retrieveAttributes();
    }

    public void removeDataQueueListener(DataQueueListener dataQueueListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing data queue listener.");
        }
        if (dataQueueListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.dataQueueListeners_ != null) {
            this.dataQueueListeners_.removeElement(dataQueueListener);
        }
    }

    public void removeObjectListener(ObjectListener objectListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing object listener.");
        }
        if (objectListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.objectListeners_ != null) {
            this.objectListeners_.removeElement(objectListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    abstract void retrieveAttributes() throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException;

    public void setCcsid(int n) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting CCSID:", n);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.ccsid_ = n;
            this.dataConverter_ = null;
        } else {
            Integer n2 = new Integer(this.ccsid_);
            Integer n3 = new Integer(n);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("ccsid", n2, n3);
            }
            this.ccsid_ = n;
            this.dataConverter_ = null;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("ccsid", n2, n3);
            }
        }
    }

    public void setPath(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting path: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'path' is null.");
            throw new NullPointerException("path");
        }
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set property 'path' after connect.");
            throw new ExtendedIllegalStateException("path", 5);
        }
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, "DTAQ");
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.library_ = qSYSObjectPathName.getLibraryName();
            this.name_ = qSYSObjectPathName.getObjectName();
            this.path_ = string;
        } else {
            String string2 = this.path_;
            String string3 = string;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("path", string2, string3);
            }
            this.library_ = qSYSObjectPathName.getLibraryName();
            this.name_ = qSYSObjectPathName.getObjectName();
            this.path_ = string;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("path", string2, string3);
            }
        }
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + aS400);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.system_ = aS400;
        } else {
            AS400 aS4002 = this.system_;
            AS400 aS4003 = aS400;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("system", aS4002, aS4003);
            }
            this.system_ = aS400;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("system", aS4002, aS4003);
            }
        }
    }

    public String toString() {
        return "(system: " + this.system_ + " path: " + this.path_ + "):" + super.toString();
    }

    private int getCcsidToUse() {
        if (this.ccsid_ == 0) {
            return this.system_.getCcsid();
        }
        return this.ccsid_;
    }

    byte[] stringToByteArray(String string) throws IOException {
        if (this.dataConverter_ == null) {
            this.dataConverter_ = new Converter(this.getCcsidToUse(), this.system_);
        }
        return this.dataConverter_.stringToByteArray(string);
    }

    String byteArrayToString(byte[] byArray) throws UnsupportedEncodingException {
        if (this.dataConverter_ == null) {
            this.dataConverter_ = new Converter(this.getCcsidToUse(), this.system_);
        }
        return this.dataConverter_.byteArrayToString(byArray);
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
    }
}

