/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.ActionCompletedListener;
import com.ibm.as400.vaccess.ActionCompletedEventSupport;
import com.ibm.as400.vaccess.DBCellRenderer;
import com.ibm.as400.vaccess.DBDateCellRenderer;
import com.ibm.as400.vaccess.ErrorEvent;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.SQLConnection;
import com.ibm.as400.vaccess.SQLResultSetData;
import com.ibm.as400.vaccess.SerializationListener;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.SQLWarning;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class SQLResultSetFormPane
extends JComponent
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private transient JLabel recordLabel_;
    private transient JLabel recordNumber_;
    transient JButton firstButton_;
    transient JButton lastButton_;
    transient JButton nextButton_;
    transient JButton previousButton_;
    transient JButton refreshButton_;
    private transient JLabel[] labels_ = new JLabel[0];
    private transient JTextField[] values_ = new JTextField[0];
    private transient DBCellRenderer[] formatter_ = new DBCellRenderer[0];
    private JLabel status_;
    private JPanel dataArea_;
    private DBCellRenderer leftCell_ = new DBCellRenderer(2);
    private DBDateCellRenderer dateCell_ = new DBDateCellRenderer(3);
    private DBDateCellRenderer timeCell_ = new DBDateCellRenderer(1);
    private DBDateCellRenderer timestampCell_ = new DBDateCellRenderer(2);
    private static final int TYPE_CHAR = 1;
    private static final int TYPE_TIME = 2;
    private static final int TYPE_TIMESTAMP = 3;
    private static final int TYPE_DATE = 4;
    private static final int TYPE_BIT = 5;
    private transient ActionCompletedEventSupport actionListeners_ = new ActionCompletedEventSupport(this);
    transient ErrorEventSupport errorListeners_ = new ErrorEventSupport(this);
    transient int current_ = -1;
    private SQLResultSetData tableData_ = new SQLResultSetData();
    transient boolean error_;
    private transient WorkingCursorAdapter worker_ = new WorkingCursorAdapter(this);

    public SQLResultSetFormPane() {
        this.addFocusListener(new SerializationListener(this));
        this.tableData_.addErrorListener(new ErrorListener_());
        this.tableData_.addWorkingListener(this.worker_);
        this.init();
    }

    public SQLResultSetFormPane(SQLConnection sQLConnection, String string) {
        if (sQLConnection == null) {
            throw new NullPointerException("connection");
        }
        if (string == null) {
            throw new NullPointerException("query");
        }
        this.addFocusListener(new SerializationListener(this));
        this.tableData_.setConnection(sQLConnection);
        this.tableData_.setQuery(string);
        this.tableData_.addErrorListener(new ErrorListener_());
        this.tableData_.addWorkingListener(this.worker_);
        this.init();
    }

    public void addActionCompletedListener(ActionCompletedListener actionCompletedListener) {
        this.actionListeners_.addActionCompletedListener(actionCompletedListener);
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorListeners_.addErrorListener(errorListener);
    }

    public void clearWarnings() {
        this.tableData_.clearWarnings();
    }

    public void close() {
        this.tableData_.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayFirst() {
        SQLResultSetFormPane sQLResultSetFormPane = this;
        synchronized (sQLResultSetFormPane) {
            this.current_ = 0;
            this.refreshScreen();
        }
        this.actionListeners_.fireActionCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayLast() {
        SQLResultSetFormPane sQLResultSetFormPane = this;
        synchronized (sQLResultSetFormPane) {
            this.error_ = false;
            this.current_ = this.tableData_.getNumberOfRows() - 1;
            if (this.error_) {
                this.current_ = this.tableData_.getLastRecordProcessed();
            }
            this.refreshScreen();
        }
        this.actionListeners_.fireActionCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayNext() {
        SQLResultSetFormPane sQLResultSetFormPane = this;
        synchronized (sQLResultSetFormPane) {
            this.current_ = this.tableData_.getAllRecordsProcessed() ? (this.current_ + 1 == this.tableData_.getNumberOfRows() ? 0 : ++this.current_) : ++this.current_;
            this.refreshScreen();
        }
        this.actionListeners_.fireActionCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayPrevious() {
        SQLResultSetFormPane sQLResultSetFormPane = this;
        synchronized (sQLResultSetFormPane) {
            if (this.current_ < 1) {
                this.error_ = false;
                this.current_ = this.tableData_.getNumberOfRows() - 1;
                if (this.error_) {
                    this.current_ = this.tableData_.getLastRecordProcessed();
                }
            } else {
                --this.current_;
            }
            this.refreshScreen();
        }
        this.actionListeners_.fireActionCompleted();
    }

    public SQLConnection getConnection() {
        return this.tableData_.getConnection();
    }

    public synchronized int getCurrentRecord() {
        return this.current_;
    }

    public synchronized String getLabelText(int n) {
        return this.labels_[n].getText();
    }

    public String getQuery() {
        String string = this.tableData_.getQuery();
        if (string == null) {
            return "";
        }
        return string;
    }

    public synchronized String getStringValueAt(int n) {
        return this.values_[n].getText();
    }

    public synchronized Object getValueAt(int n) {
        return this.tableData_.getValueAt(this.current_, n);
    }

    public SQLWarning getWarnings() {
        return this.tableData_.getWarnings();
    }

    private void init() {
        this.recordLabel_ = new JLabel(ResourceLoader.getText("DBFORM_LABEL_RECORD_NUMBER"));
        this.recordNumber_ = new JLabel();
        String string = ResourceLoader.getText("DBFORM_TOOLTIP_FIRST");
        this.firstButton_ = new JButton(ResourceLoader.getIcon("FirstIcon.gif", string));
        this.firstButton_.setToolTipText(string);
        string = ResourceLoader.getText("DBFORM_TOOLTIP_LAST");
        this.lastButton_ = new JButton(ResourceLoader.getIcon("LastIcon.gif", string));
        this.lastButton_.setToolTipText(string);
        string = ResourceLoader.getText("DBFORM_TOOLTIP_NEXT");
        this.nextButton_ = new JButton(ResourceLoader.getIcon("NextIcon.gif", string));
        this.nextButton_.setToolTipText(string);
        string = ResourceLoader.getText("DBFORM_TOOLTIP_PREVIOUS");
        this.previousButton_ = new JButton(ResourceLoader.getIcon("PreviousIcon.gif", string));
        this.previousButton_.setToolTipText(string);
        string = ResourceLoader.getText("DBFORM_TOOLTIP_REFRESH");
        this.refreshButton_ = new JButton(ResourceLoader.getIcon("RefreshIcon.gif", null));
        this.refreshButton_.setToolTipText(string);
        ButtonListener_ buttonListener_ = new ButtonListener_();
        this.firstButton_.addActionListener(buttonListener_);
        this.lastButton_.addActionListener(buttonListener_);
        this.nextButton_.addActionListener(buttonListener_);
        this.previousButton_.addActionListener(buttonListener_);
        this.refreshButton_.addActionListener(buttonListener_);
        this.dataArea_ = new JPanel();
        this.dataArea_.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.status_ = new JLabel(ResourceLoader.getText("DBFORM_MSG_NO_DATA"));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(this.firstButton_);
        jPanel.add(this.previousButton_);
        jPanel.add(this.nextButton_);
        jPanel.add(this.lastButton_);
        jPanel.add(this.refreshButton_);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1));
        jPanel2.add(this.status_);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add("North", jPanel);
        jPanel3.add("South", jPanel2);
        this.add("South", jPanel3);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        jPanel3.add(this.recordLabel_);
        jPanel3.add(this.recordNumber_);
        this.add("North", jPanel3);
        this.add("Center", this.dataArea_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        SQLResultSetFormPane sQLResultSetFormPane = this;
        synchronized (sQLResultSetFormPane) {
            this.dataArea_.removeAll();
            IllegalStateException illegalStateException = null;
            this.error_ = false;
            if (this.tableData_.getConnection() == null) {
                illegalStateException = new IllegalStateException("connection");
                this.error_ = true;
            } else if (this.tableData_.getQuery() == null) {
                illegalStateException = new IllegalStateException("query");
                this.error_ = true;
            } else {
                this.tableData_.load();
            }
            if (this.error_) {
                this.values_ = new JTextField[0];
                this.labels_ = new JLabel[0];
                this.current_ = -1;
                this.refreshScreen();
                if (illegalStateException != null) {
                    throw illegalStateException;
                }
                return;
            }
            int n = this.tableData_.getNumberOfColumns();
            this.labels_ = new JLabel[n];
            this.values_ = new JTextField[n];
            this.formatter_ = new DBCellRenderer[n];
            this.dataArea_.setLayout(new GridLayout(n, 1));
            for (int i = 0; i < n; ++i) {
                JLabel jLabel;
                this.labels_[i] = jLabel = new JLabel(this.tableData_.getColumnLabel(i));
                int n2 = this.tableData_.getColumnType(i);
                int n3 = this.tableData_.getColumnType(i);
                switch (n3) {
                    case 91: {
                        n2 = 4;
                        break;
                    }
                    case 92: {
                        n2 = 2;
                        break;
                    }
                    case 93: {
                        n2 = 3;
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        n2 = 5;
                        break;
                    }
                    default: {
                        n2 = 1;
                    }
                }
                int n4 = this.tableData_.getColumnDisplaySize(i);
                if (n2 == 5) {
                    n4 *= 2;
                }
                JTextField jTextField = new JTextField(n4);
                jTextField.setEditable(false);
                this.values_[i] = jTextField;
                this.formatter_[i] = n2 == 4 ? this.dateCell_ : (n2 == 2 ? this.timeCell_ : (n2 == 3 ? this.timestampCell_ : this.leftCell_));
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new FlowLayout(0));
                jPanel.add(this.labels_[i]);
                jPanel.add(this.values_[i]);
                this.dataArea_.add(jPanel);
            }
            this.current_ = 0;
            this.refreshScreen();
        }
        this.actionListeners_.fireActionCompleted();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.actionListeners_ = new ActionCompletedEventSupport(this);
        this.errorListeners_ = new ErrorEventSupport(this);
        this.worker_ = new WorkingCursorAdapter(this);
        this.labels_ = new JLabel[0];
        this.values_ = new JTextField[0];
        this.formatter_ = new DBCellRenderer[0];
        this.current_ = -1;
        this.tableData_.addErrorListener(new ErrorListener_());
        this.tableData_.addWorkingListener(this.worker_);
        this.init();
    }

    private void refreshScreen() {
        if (this.tableData_.getAllRecordsProcessed() && this.tableData_.getNumberOfRows() == 0) {
            this.current_ = -1;
        }
        if (this.current_ == -1) {
            this.status_.setText(ResourceLoader.getText("DBFORM_MSG_NO_DATA"));
            int n = this.values_.length;
            for (int i = 0; i < n; ++i) {
                this.values_[i].setText("");
            }
            this.recordNumber_.setText("");
        } else {
            int n = this.values_.length;
            for (int i = 0; i < n; ++i) {
                Object object = this.tableData_.getValueAt(this.current_, i);
                this.values_[i].setText(this.formatter_[i].getText(object));
            }
            this.recordNumber_.setText(String.valueOf(this.current_ + 1));
            this.recordNumber_.setSize(this.recordNumber_.getPreferredSize());
            this.status_.setText("");
        }
        this.validate();
    }

    public void removeActionCompletedListener(ActionCompletedListener actionCompletedListener) {
        this.actionListeners_.removeActionCompletedListener(actionCompletedListener);
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorListeners_.removeErrorListener(errorListener);
    }

    public void setConnection(SQLConnection sQLConnection) throws PropertyVetoException {
        if (sQLConnection == null) {
            throw new NullPointerException("connection");
        }
        SQLConnection sQLConnection2 = this.getConnection();
        this.fireVetoableChange("connection", sQLConnection2, sQLConnection);
        this.tableData_.setConnection(sQLConnection);
        this.firePropertyChange("connection", sQLConnection2, sQLConnection);
    }

    public synchronized void setLabelText(int n, String string) {
        this.labels_[n].setText(string);
    }

    public void setQuery(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("query");
        }
        String string2 = this.getQuery();
        this.fireVetoableChange("query", string2, string);
        this.tableData_.setQuery(string);
        this.firePropertyChange("query", string2, string);
    }

    private class ErrorListener_
    implements ErrorListener {
        private ErrorListener_() {
        }

        public void errorOccurred(ErrorEvent errorEvent) {
            SQLResultSetFormPane.this.error_ = true;
            SQLResultSetFormPane.this.errorListeners_.fireError(errorEvent.getException());
        }
    }

    private class ButtonListener_
    implements ActionListener {
        private ButtonListener_() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == SQLResultSetFormPane.this.firstButton_) {
                SQLResultSetFormPane.this.displayFirst();
            } else if (object == SQLResultSetFormPane.this.lastButton_) {
                SQLResultSetFormPane.this.displayLast();
            } else if (object == SQLResultSetFormPane.this.nextButton_) {
                SQLResultSetFormPane.this.displayNext();
            } else if (object == SQLResultSetFormPane.this.previousButton_) {
                SQLResultSetFormPane.this.displayPrevious();
            } else if (object == SQLResultSetFormPane.this.refreshButton_) {
                SQLResultSetFormPane.this.load();
            }
        }
    }
}

